/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal;

public enum Color {
    NONE(-1),
    RESET(0),
    BLACK(30),
    RED(31),
    GREEN(32),
    YELLOW(33),
    BLUE(34),
    MAGENTA(35),
    CYAN(36),
    WHITE(37);

    private final String ansiString;

    private Color(int n2) {
        this.ansiString = n2 > -1 ? "\u001b[" + n2 + "m" : "";
    }

    public static String filter(String string) {
        if (null == string || !string.contains("\u001b[")) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\u001b') {
                while (string.charAt(++i) != 'm') {
                }
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String format(String string) {
        if (this.ansiString.isEmpty()) {
            return string;
        }
        return this.toString() + string + (Object)((Object)RESET);
    }

    public String toString() {
        return this.ansiString;
    }
}

