/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.gravitysnaphelper;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

public class OrientationAwareRecyclerView
extends RecyclerView {
    private float lastX = 0.0f;
    private float lastY = 0.0f;
    private boolean scrolling = false;

    public OrientationAwareRecyclerView(@NonNull Context context) {
        this(context, null);
    }

    public OrientationAwareRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OrientationAwareRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                OrientationAwareRecyclerView.this.scrolling = newState != 0;
            }
        });
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        RecyclerView.LayoutManager lm = this.getLayoutManager();
        if (lm == null) {
            return super.onInterceptTouchEvent(e);
        }
        boolean allowScroll = true;
        switch (e.getActionMasked()) {
            case 0: {
                this.lastX = e.getX();
                this.lastY = e.getY();
                if (!this.scrolling) break;
                MotionEvent newEvent = MotionEvent.obtain((MotionEvent)e);
                newEvent.setAction(1);
                return super.onInterceptTouchEvent(newEvent);
            }
            case 2: {
                float currentX = e.getX();
                float currentY = e.getY();
                float dx = Math.abs(currentX - this.lastX);
                float dy = Math.abs(currentY - this.lastY);
                allowScroll = dy > dx ? lm.canScrollVertically() : lm.canScrollHorizontally();
                break;
            }
        }
        if (!allowScroll) {
            return false;
        }
        return super.onInterceptTouchEvent(e);
    }
}

