/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.gravitysnaphelper;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.github.rubensousa.gravitysnaphelper.GravitySnapHelper;
import com.github.rubensousa.gravitysnaphelper.OrientationAwareRecyclerView;
import com.github.rubensousa.gravitysnaphelper.R;

public class GravitySnapRecyclerView
extends OrientationAwareRecyclerView {
    @NonNull
    private final GravitySnapHelper snapHelper;
    private boolean isSnappingEnabled = false;

    public GravitySnapRecyclerView(@NonNull Context context) {
        this(context, null);
    }

    public GravitySnapRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GravitySnapRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.GravitySnapRecyclerView, defStyleAttr, 0);
        int snapGravity = typedArray.getInt(R.styleable.GravitySnapRecyclerView_snapGravity, 0);
        switch (snapGravity) {
            case 0: {
                this.snapHelper = new GravitySnapHelper(0x800003);
                break;
            }
            case 1: {
                this.snapHelper = new GravitySnapHelper(48);
                break;
            }
            case 2: {
                this.snapHelper = new GravitySnapHelper(0x800005);
                break;
            }
            case 3: {
                this.snapHelper = new GravitySnapHelper(80);
                break;
            }
            case 4: {
                this.snapHelper = new GravitySnapHelper(17);
            }
            default: {
                throw new IllegalArgumentException("Invalid gravity value. Use START | END | BOTTOM | TOP | CENTER constants");
            }
        }
        this.snapHelper.setSnapToPadding(typedArray.getBoolean(R.styleable.GravitySnapRecyclerView_snapToPadding, false));
        this.snapHelper.setSnapLastItem(typedArray.getBoolean(R.styleable.GravitySnapRecyclerView_snapLastItem, false));
        this.snapHelper.setMaxFlingSizeFraction(typedArray.getFloat(R.styleable.GravitySnapRecyclerView_snapMaxFlingSizeFraction, -1.0f));
        this.snapHelper.setScrollMsPerInch(typedArray.getFloat(R.styleable.GravitySnapRecyclerView_snapScrollMsPerInch, 100.0f));
        this.enableSnapping(typedArray.getBoolean(R.styleable.GravitySnapRecyclerView_snapEnabled, true));
        typedArray.recycle();
    }

    public void smoothScrollToPosition(int position) {
        if (!this.isSnappingEnabled || !this.snapHelper.smoothScrollToPosition(position)) {
            super.smoothScrollToPosition(position);
        }
    }

    public void scrollToPosition(int position) {
        if (!this.isSnappingEnabled || !this.snapHelper.scrollToPosition(position)) {
            super.scrollToPosition(position);
        }
    }

    @NonNull
    public GravitySnapHelper getSnapHelper() {
        return this.snapHelper;
    }

    public void enableSnapping(Boolean enable) {
        if (enable.booleanValue()) {
            this.snapHelper.attachToRecyclerView(this);
        } else {
            this.snapHelper.attachToRecyclerView(null);
        }
        this.isSnappingEnabled = enable;
    }

    public boolean isSnappingEnabled() {
        return this.isSnappingEnabled;
    }

    public int getCurrentSnappedPosition() {
        return this.snapHelper.getCurrentSnappedPosition();
    }

    public void snapToNextPosition(Boolean smooth) {
        this.snapTo(true, smooth);
    }

    public void snapToPreviousPosition(Boolean smooth) {
        this.snapTo(false, smooth);
    }

    public void setSnapListener(@Nullable GravitySnapHelper.SnapListener listener) {
        this.snapHelper.setSnapListener(listener);
    }

    private void snapTo(Boolean next, Boolean smooth) {
        View snapView;
        RecyclerView.LayoutManager lm = this.getLayoutManager();
        if (lm != null && (snapView = this.snapHelper.findSnapView(lm, false)) != null) {
            int pos = this.getChildAdapterPosition(snapView);
            if (next.booleanValue()) {
                if (smooth.booleanValue()) {
                    this.smoothScrollToPosition(pos + 1);
                } else {
                    this.scrollToPosition(pos + 1);
                }
            } else if (pos > 0) {
                if (smooth.booleanValue()) {
                    this.smoothScrollToPosition(pos - 1);
                } else {
                    this.scrollToPosition(pos - 1);
                }
            }
        }
    }
}

