/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.gravitysnaphelper;

import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.core.text.TextUtilsCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Locale;

public class GravitySnapHelper
extends LinearSnapHelper {
    public static final int FLING_DISTANCE_DISABLE = -1;
    public static final float FLING_SIZE_FRACTION_DISABLE = -1.0f;
    private int gravity;
    private boolean isRtl;
    private boolean snapLastItem;
    private int nextSnapPosition;
    private boolean isScrolling = false;
    private boolean snapToPadding = false;
    private float scrollMsPerInch = 100.0f;
    private int maxFlingDistance = -1;
    private float maxFlingSizeFraction = -1.0f;
    private OrientationHelper verticalHelper;
    private OrientationHelper horizontalHelper;
    private SnapListener listener;
    private RecyclerView recyclerView;
    private RecyclerView.OnScrollListener scrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (newState == 0 && GravitySnapHelper.this.listener != null && GravitySnapHelper.this.nextSnapPosition != -1 && GravitySnapHelper.this.isScrolling) {
                GravitySnapHelper.this.listener.onSnap(GravitySnapHelper.this.nextSnapPosition);
            }
            GravitySnapHelper.this.isScrolling = newState != 0;
        }
    };

    public GravitySnapHelper(int gravity) {
        this(gravity, false, null);
    }

    public GravitySnapHelper(int gravity, @NonNull SnapListener snapListener) {
        this(gravity, false, snapListener);
    }

    public GravitySnapHelper(int gravity, boolean enableSnapLastItem) {
        this(gravity, enableSnapLastItem, null);
    }

    public GravitySnapHelper(int gravity, boolean enableSnapLastItem, @Nullable SnapListener snapListener) {
        if (gravity != 0x800003 && gravity != 0x800005 && gravity != 80 && gravity != 48 && gravity != 17) {
            throw new IllegalArgumentException("Invalid gravity value. Use START | END | BOTTOM | TOP | CENTER constants");
        }
        this.snapLastItem = enableSnapLastItem;
        this.gravity = gravity;
        this.listener = snapListener;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        if (this.recyclerView != null) {
            this.recyclerView.removeOnScrollListener(this.scrollListener);
        }
        if (recyclerView != null) {
            recyclerView.setOnFlingListener(null);
            if (this.gravity == 0x800003 || this.gravity == 0x800005) {
                this.isRtl = TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
            }
            recyclerView.addOnScrollListener(this.scrollListener);
            this.recyclerView = recyclerView;
        } else {
            this.recyclerView = null;
        }
        super.attachToRecyclerView(recyclerView);
    }

    @Nullable
    public View findSnapView(@NonNull RecyclerView.LayoutManager lm) {
        return this.findSnapView(lm, true);
    }

    @Nullable
    public View findSnapView(@NonNull RecyclerView.LayoutManager lm, boolean checkEdgeOfList) {
        View snapView = null;
        switch (this.gravity) {
            case 0x800003: {
                snapView = this.findView(lm, this.getHorizontalHelper(lm), 0x800003, checkEdgeOfList);
                break;
            }
            case 0x800005: {
                snapView = this.findView(lm, this.getHorizontalHelper(lm), 0x800005, checkEdgeOfList);
                break;
            }
            case 48: {
                snapView = this.findView(lm, this.getVerticalHelper(lm), 0x800003, checkEdgeOfList);
                break;
            }
            case 80: {
                snapView = this.findView(lm, this.getVerticalHelper(lm), 0x800005, checkEdgeOfList);
                break;
            }
            case 17: {
                snapView = lm.canScrollHorizontally() ? this.findView(lm, this.getHorizontalHelper(lm), 17, checkEdgeOfList) : this.findView(lm, this.getVerticalHelper(lm), 17, checkEdgeOfList);
            }
        }
        this.nextSnapPosition = snapView != null ? this.recyclerView.getChildAdapterPosition(snapView) : -1;
        return snapView;
    }

    @NonNull
    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        if (this.gravity == 17) {
            return super.calculateDistanceToFinalSnap(layoutManager, targetView);
        }
        int[] out = new int[2];
        if (!(layoutManager instanceof LinearLayoutManager)) {
            return out;
        }
        LinearLayoutManager lm = (LinearLayoutManager)layoutManager;
        if (lm.canScrollHorizontally()) {
            out[0] = this.isRtl && this.gravity == 0x800005 || !this.isRtl && this.gravity == 0x800003 ? this.getDistanceToStart(targetView, this.getHorizontalHelper((RecyclerView.LayoutManager)lm)) : this.getDistanceToEnd(targetView, this.getHorizontalHelper((RecyclerView.LayoutManager)lm));
        } else if (lm.canScrollVertically()) {
            out[1] = this.gravity == 48 ? this.getDistanceToStart(targetView, this.getVerticalHelper((RecyclerView.LayoutManager)lm)) : this.getDistanceToEnd(targetView, this.getVerticalHelper((RecyclerView.LayoutManager)lm));
        }
        return out;
    }

    @NonNull
    public int[] calculateScrollDistance(int velocityX, int velocityY) {
        if (this.recyclerView == null || this.verticalHelper == null && this.horizontalHelper == null || this.maxFlingDistance == -1 && this.maxFlingSizeFraction == -1.0f) {
            return super.calculateScrollDistance(velocityX, velocityY);
        }
        int[] out = new int[2];
        Scroller scroller = new Scroller(this.recyclerView.getContext(), (Interpolator)new DecelerateInterpolator());
        int maxDistance = this.getFlingDistance();
        scroller.fling(0, 0, velocityX, velocityY, -maxDistance, maxDistance, -maxDistance, maxDistance);
        out[0] = scroller.getFinalX();
        out[1] = scroller.getFinalY();
        return out;
    }

    @Nullable
    public RecyclerView.SmoothScroller createScroller(RecyclerView.LayoutManager layoutManager) {
        if (!(layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider) || this.recyclerView == null) {
            return null;
        }
        return new LinearSmoothScroller(this.recyclerView.getContext()){

            protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
                if (GravitySnapHelper.this.recyclerView == null || GravitySnapHelper.this.recyclerView.getLayoutManager() == null) {
                    return;
                }
                int[] snapDistances = GravitySnapHelper.this.calculateDistanceToFinalSnap(GravitySnapHelper.this.recyclerView.getLayoutManager(), targetView);
                int dx = snapDistances[0];
                int dy = snapDistances[1];
                int time = this.calculateTimeForDeceleration(Math.max(Math.abs(dx), Math.abs(dy)));
                if (time > 0) {
                    action.update(dx, dy, time, (Interpolator)this.mDecelerateInterpolator);
                }
            }

            protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                return GravitySnapHelper.this.scrollMsPerInch / (float)displayMetrics.densityDpi;
            }
        };
    }

    public void setSnapListener(@Nullable SnapListener listener) {
        this.listener = listener;
    }

    public void setMaxFlingDistance(@Px int distance) {
        this.maxFlingDistance = distance;
        this.maxFlingSizeFraction = -1.0f;
    }

    public void setMaxFlingSizeFraction(float fraction) {
        this.maxFlingDistance = -1;
        this.maxFlingSizeFraction = fraction;
    }

    public void setSnapLastItem(boolean snap) {
        this.snapLastItem = snap;
    }

    public void setSnapToPadding(boolean snapToPadding) {
        this.snapToPadding = snapToPadding;
    }

    public void setScrollMsPerInch(float ms) {
        this.scrollMsPerInch = ms;
    }

    public void setGravity(int newGravity) {
        this.setGravity(newGravity, true);
    }

    public void setGravity(int newGravity, Boolean smooth) {
        if (this.gravity != newGravity) {
            this.gravity = newGravity;
            this.updateSnap(smooth, false);
        }
    }

    public void updateSnap(Boolean smooth, Boolean checkEdgeOfList) {
        if (this.recyclerView == null || this.recyclerView.getLayoutManager() == null) {
            return;
        }
        RecyclerView.LayoutManager lm = this.recyclerView.getLayoutManager();
        View snapView = this.findSnapView(lm, checkEdgeOfList);
        if (snapView != null) {
            int[] out = this.calculateDistanceToFinalSnap(lm, snapView);
            if (smooth.booleanValue()) {
                this.recyclerView.smoothScrollBy(out[0], out[1]);
            } else {
                this.recyclerView.scrollBy(out[0], out[1]);
            }
        }
    }

    public boolean scrollToPosition(int position) {
        if (position == -1) {
            return false;
        }
        return this.scrollTo(position, false);
    }

    public boolean smoothScrollToPosition(int position) {
        if (position == -1) {
            return false;
        }
        return this.scrollTo(position, true);
    }

    public int getGravity() {
        return this.gravity;
    }

    public boolean getSnapLastItem() {
        return this.snapLastItem;
    }

    public int getMaxFlingDistance() {
        return this.maxFlingDistance;
    }

    public float getMaxFlingSizeFraction() {
        return this.maxFlingSizeFraction;
    }

    public float getScrollMsPerInch() {
        return this.scrollMsPerInch;
    }

    public boolean getSnapToPadding() {
        return this.snapToPadding;
    }

    public int getCurrentSnappedPosition() {
        View snappedView;
        if (this.recyclerView != null && this.recyclerView.getLayoutManager() != null && (snappedView = this.findSnapView(this.recyclerView.getLayoutManager())) != null) {
            return this.recyclerView.getChildAdapterPosition(snappedView);
        }
        return -1;
    }

    private int getFlingDistance() {
        if (this.maxFlingSizeFraction != -1.0f) {
            if (this.verticalHelper != null) {
                return (int)((float)this.recyclerView.getHeight() * this.maxFlingSizeFraction);
            }
            if (this.horizontalHelper != null) {
                return (int)((float)this.recyclerView.getWidth() * this.maxFlingSizeFraction);
            }
            return Integer.MAX_VALUE;
        }
        if (this.maxFlingDistance != -1) {
            return this.maxFlingDistance;
        }
        return Integer.MAX_VALUE;
    }

    private boolean scrollTo(int position, boolean smooth) {
        if (this.recyclerView.getLayoutManager() != null) {
            if (smooth) {
                RecyclerView.SmoothScroller smoothScroller = this.createScroller(this.recyclerView.getLayoutManager());
                if (smoothScroller != null) {
                    smoothScroller.setTargetPosition(position);
                    this.recyclerView.getLayoutManager().startSmoothScroll(smoothScroller);
                    return true;
                }
            } else {
                RecyclerView.ViewHolder viewHolder = this.recyclerView.findViewHolderForAdapterPosition(position);
                if (viewHolder != null) {
                    int[] distances = this.calculateDistanceToFinalSnap(this.recyclerView.getLayoutManager(), viewHolder.itemView);
                    this.recyclerView.scrollBy(distances[0], distances[1]);
                    return true;
                }
            }
        }
        return false;
    }

    private int getDistanceToStart(View targetView, @NonNull OrientationHelper helper) {
        int childStart;
        int distance = !this.snapToPadding ? ((childStart = helper.getDecoratedStart(targetView)) >= helper.getStartAfterPadding() / 2 ? childStart - helper.getStartAfterPadding() : childStart) : helper.getDecoratedStart(targetView) - helper.getStartAfterPadding();
        return distance;
    }

    private int getDistanceToEnd(View targetView, @NonNull OrientationHelper helper) {
        int childEnd;
        int distance = !this.snapToPadding ? ((childEnd = helper.getDecoratedEnd(targetView)) >= helper.getEnd() - (helper.getEnd() - helper.getEndAfterPadding()) / 2 ? helper.getDecoratedEnd(targetView) - helper.getEnd() : childEnd - helper.getEndAfterPadding()) : helper.getDecoratedEnd(targetView) - helper.getEndAfterPadding();
        return distance;
    }

    @Nullable
    private View findView(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull OrientationHelper helper, int gravity, boolean checkEdgeOfList) {
        if (layoutManager.getChildCount() == 0 || !(layoutManager instanceof LinearLayoutManager)) {
            return null;
        }
        LinearLayoutManager lm = (LinearLayoutManager)layoutManager;
        if (checkEdgeOfList && this.isAtEdgeOfList(lm) && !this.snapLastItem) {
            return null;
        }
        View edgeView = null;
        int distanceToTarget = Integer.MAX_VALUE;
        int center = layoutManager.getClipToPadding() ? helper.getStartAfterPadding() + helper.getTotalSpace() / 2 : helper.getEnd() / 2;
        boolean snapToStart = gravity == 0x800003 && !this.isRtl || gravity == 0x800005 && this.isRtl;
        boolean snapToEnd = gravity == 0x800003 && this.isRtl || gravity == 0x800005 && !this.isRtl;
        for (int i = 0; i < lm.getChildCount(); ++i) {
            View currentView = lm.getChildAt(i);
            int currentViewDistance = snapToStart ? (!this.snapToPadding ? Math.abs(helper.getDecoratedStart(currentView)) : Math.abs(helper.getStartAfterPadding() - helper.getDecoratedStart(currentView))) : (snapToEnd ? (!this.snapToPadding ? Math.abs(helper.getDecoratedEnd(currentView) - helper.getEnd()) : Math.abs(helper.getEndAfterPadding() - helper.getDecoratedEnd(currentView))) : Math.abs(helper.getDecoratedStart(currentView) + helper.getDecoratedMeasurement(currentView) / 2 - center));
            if (currentViewDistance >= distanceToTarget) continue;
            distanceToTarget = currentViewDistance;
            edgeView = currentView;
        }
        return edgeView;
    }

    private boolean isAtEdgeOfList(LinearLayoutManager lm) {
        if (!lm.getReverseLayout() && this.gravity == 0x800003 || lm.getReverseLayout() && this.gravity == 0x800005 || !lm.getReverseLayout() && this.gravity == 48 || lm.getReverseLayout() && this.gravity == 80) {
            return lm.findLastCompletelyVisibleItemPosition() == lm.getItemCount() - 1;
        }
        if (this.gravity == 17) {
            return lm.findFirstCompletelyVisibleItemPosition() == 0 || lm.findLastCompletelyVisibleItemPosition() == lm.getItemCount() - 1;
        }
        return lm.findFirstCompletelyVisibleItemPosition() == 0;
    }

    private OrientationHelper getVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.verticalHelper == null || this.verticalHelper.getLayoutManager() != layoutManager) {
            this.verticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.verticalHelper;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.horizontalHelper == null || this.horizontalHelper.getLayoutManager() != layoutManager) {
            this.horizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.horizontalHelper;
    }

    public static interface SnapListener {
        public void onSnap(int var1);
    }
}

