/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.gravitysnaphelper;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSnapHelper;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.github.rubensousa.gravitysnaphelper.R;

public class GravitySnapHelper
extends LinearSnapHelper {
    private OrientationHelper mVerticalHelper;
    private OrientationHelper mHorizontalHelper;
    private int mGravity;
    private boolean mIsRtlHorizontal;
    private boolean mSnapLastItemEnabled;
    SnapListener mSnapListener;
    boolean mSnapping;
    private RecyclerView.OnScrollListener mScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (newState == 2) {
                GravitySnapHelper.this.mSnapping = false;
            }
            if (newState == 0 && GravitySnapHelper.this.mSnapping && GravitySnapHelper.this.mSnapListener != null) {
                int position = GravitySnapHelper.this.getSnappedPosition(recyclerView);
                if (position != -1) {
                    GravitySnapHelper.this.mSnapListener.onSnap(position);
                }
                GravitySnapHelper.this.mSnapping = false;
            }
        }
    };

    public GravitySnapHelper(int gravity) {
        this(gravity, false, null);
    }

    public GravitySnapHelper(int gravity, boolean enableSnapLastItem) {
        this(gravity, enableSnapLastItem, null);
    }

    public GravitySnapHelper(int gravity, boolean enableSnapLastItem, SnapListener snapListener) {
        if (gravity != 0x800003 && gravity != 0x800005 && gravity != 80 && gravity != 48) {
            throw new IllegalArgumentException("Invalid gravity value. Use START | END | BOTTOM | TOP constants");
        }
        this.mSnapListener = snapListener;
        this.mGravity = gravity;
        this.mSnapLastItemEnabled = enableSnapLastItem;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        if (recyclerView != null) {
            if (this.mGravity == 0x800003 || this.mGravity == 0x800005) {
                this.mIsRtlHorizontal = recyclerView.getContext().getResources().getBoolean(R.bool.is_rtl);
            }
            if (this.mSnapListener != null) {
                recyclerView.addOnScrollListener(this.mScrollListener);
            }
        }
        super.attachToRecyclerView(recyclerView);
    }

    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int[] out = new int[2];
        out[0] = layoutManager.canScrollHorizontally() ? (this.mGravity == 0x800003 ? this.distanceToStart(targetView, this.getHorizontalHelper(layoutManager), false) : this.distanceToEnd(targetView, this.getHorizontalHelper(layoutManager), false)) : 0;
        out[1] = layoutManager.canScrollVertically() ? (this.mGravity == 48 ? this.distanceToStart(targetView, this.getVerticalHelper(layoutManager), false) : this.distanceToEnd(targetView, this.getVerticalHelper(layoutManager), false)) : 0;
        return out;
    }

    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        View snapView = null;
        if (layoutManager instanceof LinearLayoutManager) {
            switch (this.mGravity) {
                case 0x800003: {
                    snapView = this.findStartView(layoutManager, this.getHorizontalHelper(layoutManager));
                    break;
                }
                case 0x800005: {
                    snapView = this.findEndView(layoutManager, this.getHorizontalHelper(layoutManager));
                    break;
                }
                case 48: {
                    snapView = this.findStartView(layoutManager, this.getVerticalHelper(layoutManager));
                    break;
                }
                case 80: {
                    snapView = this.findEndView(layoutManager, this.getVerticalHelper(layoutManager));
                }
            }
        }
        this.mSnapping = snapView != null;
        return snapView;
    }

    public void enableLastItemSnap(boolean snap) {
        this.mSnapLastItemEnabled = snap;
    }

    private int distanceToStart(View targetView, OrientationHelper helper, boolean fromEnd) {
        if (this.mIsRtlHorizontal && !fromEnd) {
            return this.distanceToEnd(targetView, helper, true);
        }
        return helper.getDecoratedStart(targetView) - helper.getStartAfterPadding();
    }

    private int distanceToEnd(View targetView, OrientationHelper helper, boolean fromStart) {
        if (this.mIsRtlHorizontal && !fromStart) {
            return this.distanceToStart(targetView, helper, true);
        }
        return helper.getDecoratedEnd(targetView) - helper.getEndAfterPadding();
    }

    private View findStartView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean endOfList;
            int firstChild = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            if (firstChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(firstChild);
            float visibleWidth = this.mIsRtlHorizontal ? (float)(helper.getTotalSpace() - helper.getDecoratedStart(child)) / (float)helper.getDecoratedMeasurement(child) : (float)helper.getDecoratedEnd(child) / (float)helper.getDecoratedMeasurement(child);
            boolean bl = endOfList = ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() == layoutManager.getItemCount() - 1;
            if (visibleWidth > 0.5f && !endOfList) {
                return child;
            }
            if (this.mSnapLastItemEnabled && endOfList) {
                return child;
            }
            if (endOfList) {
                return null;
            }
            return layoutManager.findViewByPosition(firstChild + 1);
        }
        return null;
    }

    private View findEndView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean startOfList;
            int lastChild = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            if (lastChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(lastChild);
            float visibleWidth = this.mIsRtlHorizontal ? (float)helper.getDecoratedEnd(child) / (float)helper.getDecoratedMeasurement(child) : (float)(helper.getTotalSpace() - helper.getDecoratedStart(child)) / (float)helper.getDecoratedMeasurement(child);
            boolean bl = startOfList = ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition() == 0;
            if (visibleWidth > 0.5f && !startOfList) {
                return child;
            }
            if (this.mSnapLastItemEnabled && startOfList) {
                return child;
            }
            if (startOfList) {
                return null;
            }
            return layoutManager.findViewByPosition(lastChild - 1);
        }
        return null;
    }

    int getSnappedPosition(RecyclerView recyclerView) {
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            if (this.mGravity == 0x800003 || this.mGravity == 48) {
                return ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
            }
            if (this.mGravity == 0x800005 || this.mGravity == 80) {
                return ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition();
            }
        }
        return -1;
    }

    private OrientationHelper getVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mVerticalHelper == null) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mVerticalHelper;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mHorizontalHelper == null) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mHorizontalHelper;
    }

    public static interface SnapListener {
        public void onSnap(int var1);
    }
}

