/*
 * Decompiled with CFR 0.152.
 */
package com.github.rocketchat.livechat;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.UiThread;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.github.rocketchat.R;
import com.github.rocketchat.livechat.Application.LiveChatApplication;
import com.github.rocketchat.livechat.SignupActivity;
import com.github.rocketchat.model.Message;
import com.github.rocketchat.model.User;
import com.github.rocketchat.utils.AppUtils;
import com.stfalcon.chatkit.commons.models.IMessage;
import com.stfalcon.chatkit.messages.MessageInput;
import com.stfalcon.chatkit.messages.MessagesList;
import com.stfalcon.chatkit.messages.MessagesListAdapter;
import com.stfalcon.chatkit.utils.DateFormatter;
import io.rocketchat.common.data.model.ErrorObject;
import io.rocketchat.livechat.LiveChatAPI;
import io.rocketchat.livechat.callback.AgentListener;
import io.rocketchat.livechat.callback.AuthListener;
import io.rocketchat.livechat.callback.ConnectListener;
import io.rocketchat.livechat.callback.LoadHistoryListener;
import io.rocketchat.livechat.callback.MessageListener;
import io.rocketchat.livechat.callback.TypingListener;
import io.rocketchat.livechat.model.AgentObject;
import io.rocketchat.livechat.model.GuestObject;
import io.rocketchat.livechat.model.MessageObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class ChatActivity
extends AppCompatActivity
implements MessagesListAdapter.SelectionListener,
MessagesListAdapter.OnLoadMoreListener,
MessageInput.InputListener,
MessageInput.AttachmentsListener,
MessageListener.MessageAckListener,
DateFormatter.Formatter,
LoadHistoryListener,
AuthListener.LoginListener,
ConnectListener,
AgentListener.AgentConnectListener,
MessageListener.SubscriptionListener,
TypingListener,
AgentListener.AgentDataListener {
    public static int REQUEST_REGISTER = 0;
    private static final int TOTAL_MESSAGES_COUNT = 1000;
    private Menu menu;
    private int selectionCount;
    protected MessagesListAdapter<Message> messagesAdapter;
    private LiveChatAPI liveChatAPI;
    private LiveChatAPI.ChatRoom chatRoom;
    Handler Typinghandler = new Handler();
    Boolean typing = false;
    Boolean isAgentConnected = false;
    private Ringtone r;
    private Date lastTimestamp;
    private ProgressDialog dialog;
    private AlertDialog.Builder builder;
    private String agentEmail;
    private SharedPreferences.Editor editor;
    private MessagesList messagesList;

    public void onSelectionChanged(int count) {
        this.selectionCount = count;
        this.menu.findItem(R.id.action_copy).setVisible(count > 0);
    }

    public void onLoadMore(int page, int totalItemsCount) {
        if (totalItemsCount < 1000) {
            this.chatRoom.getChatHistory(20, this.lastTimestamp, null, (LoadHistoryListener)this);
        }
    }

    public boolean onSubmit(CharSequence input) {
        this.chatRoom.sendMessage(input.toString(), (MessageListener.MessageAckListener)this);
        if (!this.isAgentConnected.booleanValue()) {
            this.dialog.show();
        }
        return true;
    }

    public void onAddAttachments() {
    }

    public String format(Date date) {
        if (DateFormatter.isToday((Date)date)) {
            return this.getString(R.string.date_header_today);
        }
        if (DateFormatter.isYesterday((Date)date)) {
            return this.getString(R.string.date_header_yesterday);
        }
        return DateFormatter.format((Date)date, (DateFormatter.Template)DateFormatter.Template.STRING_DAY_MONTH_YEAR);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_chat);
        this.getSupportActionBar().setTitle((CharSequence)"LiveChat Room");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.messagesList = (MessagesList)this.findViewById(R.id.messagesList);
        Uri notification = RingtoneManager.getDefaultUri((int)2);
        this.r = RingtoneManager.getRingtone((Context)this.getApplicationContext(), (Uri)notification);
        MessageInput input = (MessageInput)this.findViewById(R.id.input);
        input.setInputListener((MessageInput.InputListener)this);
        input.setAttachmentsListener((MessageInput.AttachmentsListener)this);
        input.getInputEditText().addTextChangedListener(new TextWatcher(){
            Runnable onTypingTimeout = new Runnable(){

                @Override
                public void run() {
                    ChatActivity.this.typing = false;
                    ChatActivity.this.chatRoom.sendIsTyping(Boolean.valueOf(false));
                }
            };

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if (!ChatActivity.this.typing.booleanValue()) {
                    ChatActivity.this.typing = true;
                    ChatActivity.this.chatRoom.sendIsTyping(Boolean.valueOf(true));
                }
                ChatActivity.this.Typinghandler.removeCallbacks(this.onTypingTimeout);
                ChatActivity.this.Typinghandler.postDelayed(this.onTypingTimeout, 600L);
            }

            public void afterTextChanged(Editable editable) {
            }
        });
        this.dialog = new ProgressDialog((Context)this);
        this.dialog.setIndeterminate(true);
        this.dialog.setCancelable(false);
        this.dialog.setMessage((CharSequence)"Contacting agent...");
        this.builder = new AlertDialog.Builder((Context)this);
        this.builder.setMessage((CharSequence)"Are you sure to close this conversation?").setCancelable(false).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (ChatActivity.this.isAgentConnected.booleanValue()) {
                    ChatActivity.this.dialog.setMessage((CharSequence)"Closing conversation ...");
                    ChatActivity.this.dialog.show();
                    ChatActivity.this.chatRoom.closeConversation();
                } else {
                    ChatActivity.this.editor.clear();
                    ChatActivity.this.editor.commit();
                    ChatActivity.this.finish();
                }
            }
        }).setNegativeButton(17039369, null);
        SharedPreferences sharedPref = this.getPreferences(0);
        String roomInfo = sharedPref.getString("roomInfo", null);
        this.editor = sharedPref.edit();
        if (roomInfo == null) {
            Intent intent = new Intent((Context)this, SignupActivity.class);
            this.startActivityForResult(intent, REQUEST_REGISTER);
        } else {
            String title = sharedPref.getString("title", "");
            if (!title.equals("")) {
                this.getSupportActionBar().setTitle((CharSequence)title);
            }
            this.liveChatAPI = ((LiveChatApplication)this.getApplicationContext()).getLiveChatAPI();
            this.liveChatAPI.setReconnectionStrategy(null);
            LiveChatAPI liveChatAPI = this.liveChatAPI;
            liveChatAPI.getClass();
            this.chatRoom = new LiveChatAPI.ChatRoom(liveChatAPI, roomInfo);
            this.dialog.setMessage((CharSequence)"Connecting ...");
            this.dialog.show();
            this.liveChatAPI.connect((ConnectListener)this);
            this.initAdapter();
        }
    }

    private void initAdapter() {
        this.messagesAdapter = new MessagesListAdapter(this.chatRoom.getUserId(), null);
        this.messagesAdapter.enableSelectionMode((MessagesListAdapter.SelectionListener)this);
        this.messagesAdapter.setLoadMoreListener((MessagesListAdapter.OnLoadMoreListener)this);
        this.messagesAdapter.setDateHeadersFormatter((DateFormatter.Formatter)this);
        this.messagesList.setAdapter(this.messagesAdapter);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (-1 != resultCode) {
            this.finish();
        } else {
            String roonInfo = data.getStringExtra("roomInfo");
            String title = data.getStringExtra("title");
            this.editor.putString("roomInfo", roonInfo);
            this.editor.putString("title", title);
            this.editor.commit();
            this.getSupportActionBar().setTitle((CharSequence)title);
            this.liveChatAPI = ((LiveChatApplication)this.getApplicationContext()).getLiveChatAPI();
            this.liveChatAPI.setConnectListener((ConnectListener)this);
            LiveChatAPI liveChatAPI = this.liveChatAPI;
            liveChatAPI.getClass();
            this.chatRoom = new LiveChatAPI.ChatRoom(liveChatAPI, roonInfo);
            this.chatRoom.subscribeLiveChatRoom(null, (AgentListener.AgentConnectListener)this);
            this.initAdapter();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.menu = menu2;
        this.getMenuInflater().inflate(R.menu.chat_actions_menu, menu2);
        menu2.findItem(R.id.contact_via_mail).setVisible(false);
        this.onSelectionChanged(0);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == R.id.action_copy) {
            this.messagesAdapter.copySelectedMessagesText((Context)this, this.getMessageStringFormatter(), true);
            AppUtils.showToast((Context)this, R.string.copied_message, true);
        } else if (i == 16908332) {
            this.onBackPressed();
        } else if (i == R.id.action_close_conversation) {
            this.builder.show();
        } else if (i == R.id.contact_via_mail) {
            if (this.agentEmail != null) {
                this.composeEmail(new String[]{this.agentEmail}, "Need support");
            } else {
                AppUtils.showToast((Context)this, "Agent not connected", false);
            }
        }
        return true;
    }

    public void onBackPressed() {
        if (this.selectionCount == 0) {
            this.liveChatAPI.disconnect();
            super.onBackPressed();
        } else {
            this.messagesAdapter.unselectAllItems();
        }
    }

    private MessagesListAdapter.Formatter<Message> getMessageStringFormatter() {
        return new MessagesListAdapter.Formatter<Message>(){

            public String format(Message message) {
                String createdAt = new SimpleDateFormat("MMM d, EEE 'at' h:mm a", Locale.getDefault()).format(message.getCreatedAt());
                String text = message.getText();
                if (text == null) {
                    text = "[attachment]";
                }
                return String.format(Locale.getDefault(), "%s: %s (%s)", message.getUser().getName(), text, createdAt);
            }
        };
    }

    public void onConnect(String sessionID) {
        Log.i((String)"success", (String)"connection is successful");
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ChatActivity.this.dialog.setMessage((CharSequence)"Logging in ...");
                Snackbar.make((View)ChatActivity.this.findViewById(R.id.chat_activity), (int)R.string.connected, (int)0).show();
            }
        });
        this.chatRoom.login((AuthListener.LoginListener)this);
    }

    public void onDisconnect(boolean closedByServer) {
        Log.i((String)"disconnect", (String)"disconnected from server");
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (ChatActivity.this.dialog.isShowing()) {
                    ChatActivity.this.dialog.dismiss();
                }
                AppUtils.getSnackbar(ChatActivity.this.findViewById(R.id.chat_activity), R.string.disconnected_from_server).setAction((CharSequence)"RETRY", new View.OnClickListener(){

                    public void onClick(View view) {
                        ChatActivity.this.dialog.setMessage((CharSequence)"Connecting ...");
                        ChatActivity.this.dialog.show();
                        ChatActivity.this.liveChatAPI.reconnect();
                    }
                }).show();
            }
        });
    }

    public void onConnectError(Exception websocketException) {
        Log.i((String)"connect error", (String)"Connect error with server");
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (ChatActivity.this.dialog.isShowing()) {
                    ChatActivity.this.dialog.dismiss();
                }
                AppUtils.getSnackbar(ChatActivity.this.findViewById(R.id.chat_activity), R.string.connection_error).setAction((CharSequence)"RETRY", new View.OnClickListener(){

                    public void onClick(View view) {
                        ChatActivity.this.dialog.setMessage((CharSequence)"Connecting ...");
                        ChatActivity.this.dialog.show();
                        ChatActivity.this.liveChatAPI.reconnect();
                    }
                }).show();
            }
        });
    }

    public void onLogin(GuestObject object, ErrorObject error) {
        Log.i((String)"success", (String)"login is successful");
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ChatActivity.this.dialog.setMessage((CharSequence)"Loading history ...");
            }
        });
        this.chatRoom.getAgentData((AgentListener.AgentDataListener)this);
    }

    public void onAgentData(AgentObject agentObject, ErrorObject error) {
        if (error != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (ChatActivity.this.dialog.isShowing()) {
                        ChatActivity.this.dialog.dismiss();
                    }
                    ChatActivity.this.dialog.setMessage((CharSequence)"Contacting agent...");
                    AppUtils.showToast((Context)ChatActivity.this, R.string.no_agent_available, false);
                }
            });
            this.chatRoom.subscribeLiveChatRoom(null, (AgentListener.AgentConnectListener)this);
        } else {
            this.processAgent(agentObject);
            this.chatRoom.getChatHistory(20, this.lastTimestamp, null, (LoadHistoryListener)this);
        }
    }

    public void onAgentConnect(AgentObject agentObject) {
        this.processAgent(agentObject);
        this.chatRoom.getChatHistory(1, this.lastTimestamp, null, (LoadHistoryListener)this);
    }

    public void processAgent(final AgentObject agentObject) {
        this.isAgentConnected = true;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ChatActivity.this.menu.findItem(R.id.contact_via_mail).setVisible(true);
                ChatActivity.this.getSupportActionBar().setTitle((CharSequence)agentObject.getUsername());
                if (agentObject.getEmails().optJSONObject(0) != null) {
                    ChatActivity.this.agentEmail = agentObject.getEmails().optJSONObject(0).optString("address");
                    ChatActivity.this.getSupportActionBar().setSubtitle((CharSequence)ChatActivity.this.agentEmail);
                }
                if (ChatActivity.this.dialog.isShowing()) {
                    ChatActivity.this.dialog.dismiss();
                }
            }
        });
        this.chatRoom.subscribeRoom(null, (MessageListener.SubscriptionListener)this);
        this.chatRoom.subscribeTyping(null, (TypingListener)this);
    }

    public void onLoadHistory(ArrayList<MessageObject> list, int unreadNotLoaded, ErrorObject error) {
        this.lastTimestamp = list.get(list.size() - 1).getMsgTimestamp();
        final ArrayList<Message> messages = new ArrayList<Message>();
        for (MessageObject object : list) {
            if (object.getMessagetype().equalsIgnoreCase("command")) continue;
            messages.add(new Message(object.getMessageId(), new User(object.getSender().getUserId(), object.getSender().getUserName(), null, true), object.getMessage(), object.getMsgTimestamp()));
        }
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (ChatActivity.this.dialog.isShowing()) {
                    ChatActivity.this.dialog.dismiss();
                }
                ChatActivity.this.messagesAdapter.addToEnd((List)messages, false);
            }
        });
    }

    public void onMessage(String roomId, final MessageObject object) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatActivity.this.r.play();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ChatActivity.this.messagesAdapter.addToStart((IMessage)new Message(object.getMessageId(), new User(object.getSender().getUserId(), object.getSender().getUserName(), null, true), object.getMessage(), object.getMsgTimestamp()), true);
            }
        });
    }

    @UiThread
    public void onAgentDisconnect(String roomId, MessageObject object) {
        Log.i((String)"success", (String)"agent disconnect");
        this.editor.clear();
        this.editor.commit();
        if (this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
        if (object.getSender().getUserId().equals(this.chatRoom.getUserId())) {
            this.finish();
        } else {
            this.builder = new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Conversation closed by agent").setCancelable(false).setMessage((CharSequence)("Message is \"" + object.getMessage() + "\"")).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    ChatActivity.this.finish();
                }
            });
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ChatActivity.this.builder.show();
                }
            });
        }
    }

    public void onTyping(String roomId, final String user, final Boolean istyping) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (istyping.booleanValue()) {
                    ChatActivity.this.getSupportActionBar().setSubtitle((CharSequence)(user + " is typing..."));
                } else {
                    ChatActivity.this.getSupportActionBar().setSubtitle((CharSequence)ChatActivity.this.agentEmail);
                }
            }
        });
    }

    public void composeEmail(String[] addresses, String subject) {
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.setData(Uri.parse((String)"mailto:"));
        intent.putExtra("android.intent.extra.EMAIL", addresses);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        if (intent.resolveActivity(this.getPackageManager()) != null) {
            this.startActivity(intent);
        }
    }

    public void onMessageAck(MessageObject object, final ErrorObject error) {
        Log.i((String)"success", (String)"got error here");
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (ChatActivity.this.dialog.isShowing()) {
                    ChatActivity.this.dialog.dismiss();
                }
                if (error != null) {
                    AppUtils.showToast((Context)ChatActivity.this, error.getMessage(), false);
                }
            }
        });
    }
}

