/*
 * Decompiled with CFR 0.152.
 */
package com.github.redplay;

import android.content.Context;
import com.github.redplay.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Dates {
    private static volatile Dates singleton = null;
    private final Context context;
    private String mdate = "";
    private String mtime = "";

    private Dates(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Dates with(Context context) {
        if (singleton != null) return singleton;
        Class<Dates> clazz = Dates.class;
        synchronized (Dates.class) {
            if (singleton != null) return singleton;
            singleton = new Builder(context).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public Dates date(String mdate) {
        this.mdate = mdate.trim();
        return this;
    }

    public Dates time(String mtime) {
        this.mtime = mtime.trim();
        return this;
    }

    public String format(Format format) {
        if (format.strictCase.equals("Strict date")) {
            if (!this.mdate.isEmpty()) {
                if (this.validate(this.mdate, 1)) {
                    if (this.mtime.isEmpty()) {
                        return this.doFormattingWith(format.typeKey, "yyyy-MM-dd");
                    }
                    if (this.validate(this.mtime, 2)) {
                        return this.doFormattingWith(format.typeKey, "yyyy-MM-dd");
                    }
                    throw new IllegalArgumentException("Invalid time! The time format should be [HH-mm-ss] eg: 13:45:00.");
                }
                throw new IllegalArgumentException("Invalid date! The date format should be [yyyy-MM-dd] eg: 1989-06-06.");
            }
            throw new IllegalArgumentException("Date missing! The opted format type requires a valid date.");
        }
        if (format.strictCase.equals("Strict time")) {
            if (!this.mtime.isEmpty()) {
                if (this.validate(this.mtime, 2)) {
                    if (this.mdate.isEmpty()) {
                        this.mdate = "";
                        return this.doFormattingWith(format.typeKey, "HH:mm:ss");
                    }
                    if (this.validate(this.mdate, 1)) {
                        this.mdate = "";
                        return this.doFormattingWith(format.typeKey, "HH:mm:ss");
                    }
                    throw new IllegalArgumentException("Invalid date! The date format should be [yyyy-MM-dd] eg: 1989-06-06.");
                }
                throw new IllegalArgumentException("Invalid time! The time format should be [HH-mm-ss] eg: 13:45:00.");
            }
            throw new IllegalArgumentException("Time missing! The opted format type requires a valid time.");
        }
        if (format.strictCase.equals("Strict both")) {
            if (!this.mdate.isEmpty() && !this.mtime.isEmpty()) {
                if (this.validate(this.mdate, 1)) {
                    if (this.validate(this.mtime, 2)) {
                        return this.doFormattingWith(format.typeKey, "yyyy-MM-dd HH:mm:ss");
                    }
                    throw new IllegalArgumentException("Invalid time! The time format should be [HH-mm-ss] eg: 13:45:00.");
                }
                throw new IllegalArgumentException("Invalid date! The date format should be [yyyy-MM-dd] eg: 1989-06-06.");
            }
            throw new IllegalArgumentException("Date/Time missing! The opted format type requires both valid date & time.");
        }
        throw new IllegalArgumentException();
    }

    private boolean validate(String inValue, int type) {
        SimpleDateFormat format;
        switch (type) {
            case 1: {
                format = new SimpleDateFormat("yyyy-MM-dd");
                break;
            }
            case 2: {
                format = new SimpleDateFormat("HH:mm:ss");
                break;
            }
            default: {
                format = null;
            }
        }
        if (format != null) {
            format.setLenient(false);
        }
        try {
            if (format != null) {
                format.parse(inValue.trim());
            }
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    private String doFormattingWith(String formatType, String standardType) {
        String afterFormatting = "";
        String datetime = this.mdate + " " + this.mtime;
        SimpleDateFormat standardFormat = new SimpleDateFormat(standardType);
        standardFormat.setLenient(false);
        SimpleDateFormat DatesFormat = formatType.contains("X") ? new SimpleDateFormat(this.addOrdinal(formatType)) : new SimpleDateFormat(formatType);
        try {
            Date standardDate = standardFormat.parse(datetime);
            if (formatType.equals("W 'week of' MMMM, yyyy")) {
                String formattedType29 = DatesFormat.format(standardDate);
                String[] type29Array = formattedType29.split("\\s+");
                String weekOrdinal = this.getDayOrdinal(Integer.parseInt(type29Array[0]));
                afterFormatting = formattedType29.replace(type29Array[0], type29Array[0] + weekOrdinal);
            } else if (formatType.equals("D 'day of' yyyy")) {
                String formattedType30 = DatesFormat.format(standardDate);
                String[] type30Array = formattedType30.split("\\s+");
                String dayOrdinal = this.getDayOrdinal(Integer.parseInt(type30Array[0]));
                afterFormatting = formattedType30.replace(type30Array[0], type30Array[0] + dayOrdinal);
            } else if (formatType.equals("w 'week of' yyyy")) {
                String formattedType31 = DatesFormat.format(standardDate);
                String[] type31Array = formattedType31.split("\\s+");
                String weekOrdinal = this.getDayOrdinal(Integer.parseInt(type31Array[0]));
                afterFormatting = formattedType31.replace(type31Array[0], type31Array[0] + weekOrdinal);
            } else {
                afterFormatting = DatesFormat.format(standardDate);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.mdate = "";
        this.mtime = "";
        return afterFormatting;
    }

    private String addOrdinal(String formatType) {
        String formattedType = "";
        String[] fulldate = this.mdate.split("-");
        String dayOrdinal = this.getDayOrdinal(Integer.parseInt(fulldate[2]));
        formattedType = formatType.replace("X", "'" + dayOrdinal + "'");
        return formattedType;
    }

    private String getDayOrdinal(int day) {
        int hundredRemainder = day % 100;
        int tenRemainder = day % 10;
        if (hundredRemainder - tenRemainder == 10) {
            return "th";
        }
        switch (tenRemainder) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    private static class Builder {
        private final Context context;

        private Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context.getApplicationContext();
        }

        private Dates build() {
            Context context = this.context;
            return new Dates(context);
        }
    }
}

