/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.util.Property;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import razerdp.util.animation.BaseAnimationConfig;
import razerdp.util.animation.Direction;

public class ScaleConfig
extends BaseAnimationConfig<ScaleConfig> {
    float scaleFromX = 0.0f;
    float scaleFromY = 0.0f;
    float scaleToX = 1.0f;
    float scaleToY = 1.0f;
    boolean changeFrom;
    boolean changeTo;
    public static final ScaleConfig LEFT_TO_RIGHT = new ScaleConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(Direction.LEFT);
            this.to(Direction.RIGHT);
        }
    };
    public static final ScaleConfig RIGHT_TO_LEFT = new ScaleConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(Direction.RIGHT);
            this.to(Direction.LEFT);
        }
    };
    public static final ScaleConfig TOP_TO_BOTTOM = new ScaleConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(Direction.TOP);
            this.to(Direction.BOTTOM);
        }
    };
    public static final ScaleConfig BOTTOM_TO_TOP = new ScaleConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(Direction.BOTTOM);
            this.to(Direction.TOP);
        }
    };
    public static final ScaleConfig CENTER = new ScaleConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(Direction.CENTER);
            this.to(Direction.CENTER);
        }
    };

    @Override
    void resetInternal() {
        this.scaleFromX = 0.0f;
        this.scaleFromY = 0.0f;
        this.scaleToX = 1.0f;
        this.scaleToY = 1.0f;
        this.changeFrom = false;
        this.changeTo = false;
        this.pivot(0.5f, 0.5f);
        this.pivot2(0.5f, 0.5f);
    }

    public ScaleConfig() {
        super(false, false);
        this.resetInternal();
    }

    ScaleConfig(boolean resetParent, boolean resetInternal) {
        super(resetParent, resetInternal);
        this.resetInternal();
    }

    public ScaleConfig scale(float from, float to) {
        this.scaleFromX = this.scaleFromY = from;
        this.scaleToX = this.scaleToY = to;
        this.changeTo = true;
        this.changeFrom = true;
        return this;
    }

    public ScaleConfig from(Direction ... from) {
        if (from != null) {
            if (!this.changeFrom) {
                this.scaleFromY = 1.0f;
                this.scaleFromX = 1.0f;
            }
            int flag = 0;
            for (Direction direction : from) {
                flag |= direction.flag;
            }
            if (Direction.isDirectionFlag(Direction.LEFT, flag)) {
                this.pivotX = 0.0f;
                float f = this.scaleFromX = this.changeFrom ? this.scaleFromX : 0.0f;
            }
            if (Direction.isDirectionFlag(Direction.RIGHT, flag)) {
                this.pivotX = 1.0f;
                float f = this.scaleFromX = this.changeFrom ? this.scaleFromX : 0.0f;
            }
            if (Direction.isDirectionFlag(Direction.CENTER_HORIZONTAL, flag)) {
                this.pivotX = 0.5f;
                float f = this.scaleFromX = this.changeFrom ? this.scaleFromX : 0.0f;
            }
            if (Direction.isDirectionFlag(Direction.TOP, flag)) {
                this.pivotY = 0.0f;
                float f = this.scaleFromY = this.changeFrom ? this.scaleFromY : 0.0f;
            }
            if (Direction.isDirectionFlag(Direction.BOTTOM, flag)) {
                this.pivotY = 1.0f;
                float f = this.scaleFromY = this.changeFrom ? this.scaleFromY : 0.0f;
            }
            if (Direction.isDirectionFlag(Direction.CENTER_VERTICAL, flag)) {
                this.pivotY = 0.5f;
                this.scaleFromY = this.changeFrom ? this.scaleFromY : 0.0f;
            }
        }
        return this;
    }

    public ScaleConfig to(Direction ... to) {
        if (to != null) {
            if (!this.changeTo) {
                this.scaleToY = 1.0f;
                this.scaleToX = 1.0f;
            }
            int flag = 0;
            for (Direction direction : to) {
                flag |= direction.flag;
            }
            if (Direction.isDirectionFlag(Direction.LEFT, flag)) {
                this.pivotX2 = 0.0f;
            }
            if (Direction.isDirectionFlag(Direction.RIGHT, flag)) {
                this.pivotX2 = 1.0f;
            }
            if (Direction.isDirectionFlag(Direction.CENTER_HORIZONTAL, flag)) {
                this.pivotX2 = 0.5f;
            }
            if (Direction.isDirectionFlag(Direction.TOP, flag)) {
                this.pivotY2 = 0.0f;
            }
            if (Direction.isDirectionFlag(Direction.BOTTOM, flag)) {
                this.pivotY2 = 1.0f;
            }
            if (Direction.isDirectionFlag(Direction.CENTER_VERTICAL, flag)) {
                this.pivotY2 = 0.5f;
            }
        }
        return this;
    }

    public ScaleConfig scaleX(float from, float to) {
        this.scaleFromX = from;
        this.scaleToX = to;
        this.changeFrom = true;
        return this;
    }

    public ScaleConfig sclaeY(float from, float to) {
        this.scaleFromY = from;
        this.scaleToY = to;
        this.changeTo = true;
        return this;
    }

    public String toString() {
        return "ScaleConfig{scaleFromX=" + this.scaleFromX + ", scaleFromY=" + this.scaleFromY + ", scaleToX=" + this.scaleToX + ", scaleToY=" + this.scaleToY + '}';
    }

    float[] values(boolean isRevert) {
        float[] result = new float[]{isRevert ? this.scaleToX : this.scaleFromX, isRevert ? this.scaleFromX : this.scaleToX, isRevert ? this.scaleToY : this.scaleFromY, isRevert ? this.scaleFromY : this.scaleToY, isRevert ? this.pivotX2 : this.pivotX, isRevert ? this.pivotY2 : this.pivotY};
        return result;
    }

    @Override
    protected Animation buildAnimation(boolean isRevert) {
        float[] values = this.values(isRevert);
        ScaleAnimation animation = new ScaleAnimation(values[0], values[1], values[2], values[3], 1, values[4], 1, values[5]);
        this.deploy((Animation)animation);
        return animation;
    }

    @Override
    protected Animator buildAnimator(boolean isRevert) {
        final float[] values = this.values(isRevert);
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator scaleX = ObjectAnimator.ofFloat(null, (Property)View.SCALE_X, (float[])new float[]{values[0], values[1]});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat(null, (Property)View.SCALE_Y, (float[])new float[]{values[2], values[3]});
        scaleX.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                Object target = ((ObjectAnimator)animation).getTarget();
                if (target instanceof View) {
                    ((View)target).setPivotX((float)((View)target).getWidth() * values[4]);
                }
            }
        });
        scaleY.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                Object target = ((ObjectAnimator)animation).getTarget();
                if (target instanceof View) {
                    ((View)target).setPivotY((float)((View)target).getHeight() * values[5]);
                }
            }
        });
        animatorSet.playTogether(new Animator[]{scaleX, scaleY});
        this.deploy((Animator)animatorSet);
        return animatorSet;
    }
}

