/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.util.Property;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import androidx.annotation.FloatRange;
import razerdp.util.animation.BaseAnimationConfig;

public class AlphaConfig
extends BaseAnimationConfig<AlphaConfig> {
    float alphaFrom;
    float alphaTo;
    boolean changed;
    public static final AlphaConfig IN = new AlphaConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(0.0f);
            this.to(1.0f);
        }
    };
    public static final AlphaConfig OUT = new AlphaConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(1.0f);
            this.to(0.0f);
        }
    };

    @Override
    void resetInternal() {
        this.alphaFrom = 0.0f;
        this.alphaTo = 1.0f;
        this.changed = false;
    }

    public AlphaConfig() {
        super(false, false);
        this.resetInternal();
    }

    AlphaConfig(boolean resetParent, boolean resetInternal) {
        super(resetParent, resetInternal);
        this.resetInternal();
    }

    public AlphaConfig from(@FloatRange(from=0.0, to=1.0) float from) {
        this.alphaFrom = from;
        this.changed = true;
        return this;
    }

    public AlphaConfig to(@FloatRange(from=0.0, to=1.0) float to) {
        this.alphaTo = to;
        this.changed = true;
        return this;
    }

    public AlphaConfig from(int from) {
        this.alphaFrom = (float)(Math.max(0, Math.min(255, from)) / 255) + 0.5f;
        this.changed = true;
        return this;
    }

    public AlphaConfig to(int to) {
        this.alphaFrom = (float)(Math.max(0, Math.min(255, to)) / 255) + 0.5f;
        this.changed = true;
        return this;
    }

    public String toString() {
        return "AlphaConfig{alphaFrom=" + this.alphaFrom + ", alphaTo=" + this.alphaTo + '}';
    }

    @Override
    protected Animation buildAnimation(boolean isRevert) {
        AlphaAnimation animation = new AlphaAnimation(isRevert && !this.changed ? this.alphaTo : this.alphaFrom, isRevert && !this.changed ? this.alphaFrom : this.alphaTo);
        this.deploy((Animation)animation);
        return animation;
    }

    @Override
    protected Animator buildAnimator(boolean isRevert) {
        ObjectAnimator animator = ObjectAnimator.ofFloat(null, (Property)View.ALPHA, (float[])new float[]{isRevert && !this.changed ? this.alphaTo : this.alphaFrom, isRevert && !this.changed ? this.alphaFrom : this.alphaTo});
        this.deploy((Animator)animator);
        return animator;
    }
}

