/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.basepopup.WindowManagerProxy;
import razerdp.util.PopupUtils;

class PopupWindowProxy
extends PopupWindow
implements ClearMemoryObject {
    private static final String TAG = "PopupWindowProxy";
    private BasePopupContextWrapper mBasePopupContextWrapper;
    private boolean oldFocusable = true;
    private boolean isHandledFullScreen;
    private static final int FULL_SCREEN_FLAG = 5894;

    public PopupWindowProxy(BasePopupContextWrapper context) {
        super((Context)context);
        this.mBasePopupContextWrapper = context;
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.setInputMethodMode(1);
    }

    public void update() {
        try {
            this.mBasePopupContextWrapper.mWindowManagerProxy.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleFullScreenFocusable() {
        this.oldFocusable = this.isFocusable();
        this.setFocusable(false);
        this.isHandledFullScreen = true;
    }

    private void restoreFocusable() {
        if (this.mBasePopupContextWrapper != null && this.mBasePopupContextWrapper.mWindowManagerProxy != null) {
            this.mBasePopupContextWrapper.mWindowManagerProxy.updateFocus(this.oldFocusable);
        }
        this.setFocusable(this.oldFocusable);
        this.isHandledFullScreen = false;
    }

    public void showAtLocation(View parent, int gravity, int x, int y) {
        if (this.isShowing()) {
            return;
        }
        Activity activity = PopupUtils.getActivity(parent.getContext());
        if (activity == null) {
            Log.e((String)TAG, (String)"please make sure that context is instance of activity");
            return;
        }
        this.onBeforeShowExec(activity);
        super.showAtLocation(parent, gravity, x, y);
        this.onAfterShowExec(activity);
    }

    void onBeforeShowExec(Activity act) {
        if (this.isFullScreen(act)) {
            this.handleFullScreenFocusable();
        }
    }

    void onAfterShowExec(Activity act) {
        if (this.isHandledFullScreen) {
            int flag = 5894;
            if (act != null) {
                flag = act.getWindow().getDecorView().getSystemUiVisibility();
            }
            this.getContentView().setSystemUiVisibility(flag);
            this.restoreFocusable();
        }
    }

    boolean isFullScreen(Activity act) {
        if (act == null) {
            return false;
        }
        try {
            View decorView = act.getWindow().getDecorView();
            WindowManager.LayoutParams lp = act.getWindow().getAttributes();
            int i = lp.flags;
            int f = decorView.getWindowSystemUiVisibility();
            return (i & 0x400) != 0 || (f & 2) != 0 || (f & 0x200) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void dismiss() {
        if (this.mBasePopupContextWrapper != null && this.mBasePopupContextWrapper.helper != null) {
            this.mBasePopupContextWrapper.helper.dismiss(true);
        }
    }

    void superDismiss() {
        try {
            super.dismiss();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.clear(false);
        }
    }

    WindowManagerProxy prevWindow() {
        if (this.mBasePopupContextWrapper == null || this.mBasePopupContextWrapper.mWindowManagerProxy == null) {
            return null;
        }
        return this.mBasePopupContextWrapper.mWindowManagerProxy.preWindow();
    }

    @Override
    public void clear(boolean destroy) {
        if (this.mBasePopupContextWrapper != null) {
            this.mBasePopupContextWrapper.clear(destroy);
        }
        PopupUtils.clearViewFromParent(this.getContentView());
        if (destroy) {
            this.mBasePopupContextWrapper = null;
        }
    }

    static class BasePopupContextWrapper
    extends ContextWrapper
    implements ClearMemoryObject {
        BasePopupHelper helper;
        WindowManagerProxy mWindowManagerProxy;

        public BasePopupContextWrapper(Context base, BasePopupHelper helper) {
            super(base);
            this.helper = helper;
        }

        public Object getSystemService(String name) {
            if (TextUtils.equals((CharSequence)name, (CharSequence)"window")) {
                if (this.mWindowManagerProxy != null) {
                    return this.mWindowManagerProxy;
                }
                WindowManager windowManager = (WindowManager)super.getSystemService(name);
                this.mWindowManagerProxy = new WindowManagerProxy(windowManager, this.helper);
                return this.mWindowManagerProxy;
            }
            return super.getSystemService(name);
        }

        @Override
        public void clear(boolean destroy) {
            if (this.mWindowManagerProxy != null) {
                this.mWindowManagerProxy.clear(destroy);
            }
            if (destroy) {
                this.helper = null;
                this.mWindowManagerProxy = null;
            }
        }
    }
}

