/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util.animation;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import razerdp.util.animation.AlphaConfig;
import razerdp.util.animation.BaseAnimationConfig;
import razerdp.util.animation.RotationConfig;
import razerdp.util.animation.ScaleConfig;
import razerdp.util.animation.TranslationConfig;

public abstract class AnimationApi<T> {
    SparseArray<BaseAnimationConfig> configs;

    public T withAlpha(@NonNull AlphaConfig config) {
        this.appendConfigs(config);
        return (T)this;
    }

    public T withScale(@NonNull ScaleConfig config) {
        this.appendConfigs(config);
        return (T)this;
    }

    public T withTranslation(@NonNull TranslationConfig config) {
        this.appendConfigs(config);
        return (T)this;
    }

    public T withRotation(@NonNull RotationConfig config) {
        this.appendConfigs(config);
        return (T)this;
    }

    void appendConfigs(@NonNull BaseAnimationConfig config) {
        if (this.configs == null) {
            this.configs = new SparseArray();
        }
        this.configs.delete(config.key());
        this.configs.append(config.key(), (Object)config);
    }
}

