/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Looper;
import android.util.AndroidRuntimeException;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.EditText;
import android.widget.PopupWindow;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import razerdp.basepopup.BasePopup;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.PopupWindowProxy;
import razerdp.basepopup.WindowManagerProxy;
import razerdp.blur.PopupBlurOption;
import razerdp.library.R;
import razerdp.util.KeyboardUtils;
import razerdp.util.PopupUiUtils;
import razerdp.util.PopupUtils;
import razerdp.util.log.PopupLog;

public abstract class BasePopupWindow
implements BasePopup,
PopupWindow.OnDismissListener,
LifecycleObserver {
    static final String TAG = "BasePopupWindow";
    public static int DEFAULT_BACKGROUND_COLOR = Color.parseColor((String)"#8f000000");
    public static final int FLAG_KEYBOARD_ALIGN_TO_VIEW = 65536;
    public static final int FLAG_KEYBOARD_ALIGN_TO_ROOT = 131072;
    public static final int FLAG_KEYBOARD_IGNORE_OVER = 262144;
    public static final int FLAG_KEYBOARD_ANIMATE_ALIGN = 524288;
    public static final int FLAG_KEYBOARD_FORCE_ADJUST = 0x100000;
    private static final int MAX_RETRY_SHOW_TIME = 3;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    private View mAnchorDecorView;
    private boolean isDestroyed;
    private BasePopupHelper mHelper;
    Activity mContext;
    Object ownerAnchorParent;
    boolean pendingPopupWindow;
    PopupWindowProxy mPopupWindowProxy;
    View mContentView;
    View mDisplayAnimateView;
    private volatile boolean isExitAnimatePlaying = false;

    public BasePopupWindow(Context context) {
        this(context, 0, 0);
    }

    public BasePopupWindow(Context context, int width, int height) {
        this(context, width, height, 0);
    }

    public BasePopupWindow(Fragment fragment) {
        this(fragment, 0, 0);
    }

    public BasePopupWindow(Fragment fragment, int width, int height) {
        this(fragment, width, height, 0);
    }

    public BasePopupWindow(Dialog dialog) {
        this(dialog, 0, 0);
    }

    public BasePopupWindow(Dialog dialog, int width, int height) {
        this(dialog, width, height, 0);
    }

    BasePopupWindow(Object ownerAnchorParent, int width, int height, int flag) {
        this.ownerAnchorParent = ownerAnchorParent;
        Activity act = BasePopupHelper.findActivity(ownerAnchorParent);
        if (act == null) {
            throw new NullPointerException(PopupUtils.getString(R.string.basepopup_error_non_act_context, new Object[0]));
        }
        if (act instanceof LifecycleOwner) {
            this.bindLifecycleOwner((LifecycleOwner)act);
        } else {
            this.listenForLifeCycle(act);
        }
        this.onCreateConstructor(ownerAnchorParent, width, height);
        this.mContext = act;
        this.mHelper = new BasePopupHelper(this);
        this.initView(width, height);
    }

    public BasePopupWindow bindLifecycleOwner(LifecycleOwner lifecycleOwner) {
        if (this.getContext() instanceof LifecycleOwner) {
            ((LifecycleOwner)this.getContext()).getLifecycle().removeObserver((LifecycleObserver)this);
        }
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this);
        return this;
    }

    private void listenForLifeCycle(Activity act) {
        act.getWindow().getDecorView().addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
            }

            public void onViewDetachedFromWindow(View v) {
                v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                BasePopupWindow.this.onDestroy();
            }
        });
    }

    void onCreateConstructor(Object ownerAnchorParent, int width, int height) {
    }

    void initView(int width, int height) {
        this.mContentView = this.onCreateContentView();
        this.mHelper.setContentRootId(this.mContentView);
        this.mDisplayAnimateView = this.onCreateAnimateView();
        if (this.mDisplayAnimateView == null) {
            this.mDisplayAnimateView = this.mContentView;
        }
        this.setWidth(width);
        this.setHeight(height);
        this.mPopupWindowProxy = new PopupWindowProxy(new PopupWindowProxy.BasePopupContextWrapper((Context)this.getContext(), this.mHelper));
        this.mPopupWindowProxy.setContentView(this.mContentView);
        this.mPopupWindowProxy.setOnDismissListener(this);
        this.setPopupAnimationStyle(0);
        this.mHelper.preMeasurePopupView(this.mContentView, width, height);
        if (this.mContentView != null) {
            this.onViewCreated(this.mContentView);
        }
    }

    public void onViewCreated(@NonNull View contentView) {
    }

    protected Animation onCreateShowAnimation() {
        return null;
    }

    protected Animation onCreateShowAnimation(int width, int height) {
        return this.onCreateShowAnimation();
    }

    protected Animation onCreateDismissAnimation() {
        return null;
    }

    protected Animation onCreateDismissAnimation(int width, int height) {
        return this.onCreateDismissAnimation();
    }

    protected Animator onCreateShowAnimator() {
        return null;
    }

    protected Animator onCreateShowAnimator(int width, int height) {
        return this.onCreateShowAnimator();
    }

    protected View onCreateAnimateView() {
        return null;
    }

    protected Animator onCreateDismissAnimator() {
        return null;
    }

    protected Animator onCreateDismissAnimator(int width, int height) {
        return this.onCreateDismissAnimator();
    }

    public BasePopupWindow setPopupFadeEnable(boolean isPopupFadeAnimate) {
        this.mHelper.setFlag(128, isPopupFadeAnimate);
        return this;
    }

    public boolean isPopupFadeEnable() {
        return this.mHelper.isPopupFadeEnable();
    }

    public BasePopupWindow setPopupAnimationStyle(int animationStyleRes) {
        this.mHelper.animationStyleRes = animationStyleRes;
        return this;
    }

    public void showPopupWindow() {
        if (this.checkPerformShow(null)) {
            this.mHelper.withAnchor(false);
            this.tryToShowPopup(null, false);
        }
    }

    @Deprecated
    public void showPopupWindow(int anchorViewResid) {
        Activity act = this.getContext();
        if (act != null) {
            View v = act.findViewById(anchorViewResid);
            this.showPopupWindow(v);
        } else {
            this.onShowError(new NullPointerException(PopupUtils.getString(R.string.basepopup_error_non_act_context, new Object[0])));
        }
    }

    public void showPopupWindow(View anchorView) {
        if (this.checkPerformShow(anchorView)) {
            if (anchorView != null) {
                this.mHelper.withAnchor(true);
            }
            this.tryToShowPopup(anchorView, false);
        }
    }

    public void showPopupWindow(int x, int y) {
        if (this.checkPerformShow(null)) {
            this.mHelper.setShowLocation(x, y);
            this.mHelper.withAnchor(true);
            this.tryToShowPopup(null, true);
        }
    }

    public void update() {
        this.mHelper.update(null, false);
    }

    public void update(View anchorView) {
        this.mHelper.update(anchorView, false);
    }

    public void update(int x, int y) {
        if (!this.isShowing() || this.getContentView() == null) {
            return;
        }
        this.mHelper.setShowLocation(x, y);
        this.mHelper.withAnchor(true);
        this.mHelper.update(null, true);
    }

    public void update(float width, float height) {
        if (!this.isShowing() || this.getContentView() == null) {
            return;
        }
        this.setWidth((int)width).setHeight((int)height).update();
    }

    public void update(int x, int y, float width, float height) {
        if (!this.isShowing() || this.getContentView() == null) {
            return;
        }
        this.mHelper.setShowLocation(x, y);
        this.mHelper.withAnchor(true);
        this.mHelper.setPopupViewWidth((int)width);
        this.mHelper.setPopupViewHeight((int)height);
        this.mHelper.update(null, true);
    }

    void tryToShowPopup(View v, boolean positionMode) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new CalledFromWrongThreadException(PopupUtils.getString(R.string.basepopup_error_thread, new Object[0]));
        }
        if (this.isShowing() || this.mContentView == null) {
            return;
        }
        if (this.isDestroyed) {
            this.onShowError(new IllegalAccessException(PopupUtils.getString(R.string.basepopup_error_destroyed, new Object[0])));
            return;
        }
        View decorView = this.getDecorView();
        if (decorView == null) {
            this.onShowError(new NullPointerException(PopupUtils.getString(R.string.basepopup_error_decorview, this.ownerParentLog())));
            return;
        }
        if (decorView.getWindowToken() == null) {
            this.onShowError(new IllegalStateException(PopupUtils.getString(R.string.basepopup_window_not_prepare, this.ownerParentLog())));
            this.pendingPopupWindow(decorView, v, positionMode);
            return;
        }
        this.onLogInternal(PopupUtils.getString(R.string.basepopup_window_prepared, this.ownerParentLog()));
        if (!this.onPreShow()) {
            return;
        }
        this.mHelper.prepare(v, positionMode);
        try {
            if (this.isShowing()) {
                this.onShowError(new IllegalStateException(PopupUtils.getString(R.string.basepopup_has_been_shown, new Object[0])));
                return;
            }
            this.mHelper.onShow();
            if (v != null) {
                this.mPopupWindowProxy.showAtLocation(v, this.getPopupGravity(), 0, 0);
            } else {
                this.mPopupWindowProxy.showAtLocation(decorView, 0, 0, 0);
            }
            this.onLogInternal(PopupUtils.getString(R.string.basepopup_shown_successful, new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onShowError(e);
        }
    }

    protected boolean onPreShow() {
        return true;
    }

    protected void onShowError(Exception e) {
        PopupLog.e(TAG, "onShowError: ", e);
        this.onLogInternal(e.getMessage());
    }

    @Nullable
    private View getDecorView() {
        this.mAnchorDecorView = BasePopupHelper.findDecorView(this.ownerAnchorParent);
        return this.mAnchorDecorView;
    }

    void dispatchOutSideEvent(MotionEvent event) {
        if (this.mHelper.isOutSideTouchable()) {
            WindowManagerProxy proxy = this.mPopupWindowProxy.prevWindow();
            if (proxy == null) {
                if (this.mAnchorDecorView != null) {
                    this.mAnchorDecorView.getRootView().dispatchTouchEvent(event);
                } else {
                    this.mContext.getWindow().getDecorView().getRootView().dispatchTouchEvent(event);
                }
            } else {
                proxy.dispatchToDecorProxy(event);
            }
        }
    }

    private void pendingPopupWindow(@NonNull View decorView, final @Nullable View anchorView, final boolean positionMode) {
        if (this.pendingPopupWindow) {
            return;
        }
        this.pendingPopupWindow = true;
        decorView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                BasePopupWindow.this.pendingPopupWindow = false;
                v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                v.post(new Runnable(){

                    @Override
                    public void run() {
                        BasePopupWindow.this.tryToShowPopup(anchorView, positionMode);
                    }
                });
            }

            public void onViewDetachedFromWindow(View v) {
            }
        });
    }

    public BasePopupWindow setAdjustInputMethod(boolean needAdjust) {
        this.setAdjustInputMethod(needAdjust, 16);
        return this;
    }

    public BasePopupWindow setAdjustInputMethod(boolean needAdjust, int flag) {
        if (needAdjust) {
            this.setSoftInputMode(flag);
        } else {
            this.setSoftInputMode(48);
        }
        return this;
    }

    public BasePopupWindow setAdjustInputMode(int flag) {
        return this.setAdjustInputMode(0, flag);
    }

    public BasePopupWindow setAdjustInputMode(int viewId, int flag) {
        this.mHelper.keybaordAlignViewId = viewId;
        this.mHelper.setFlag(0x1F0000, false);
        this.mHelper.setFlag(flag, true);
        return this;
    }

    public BasePopupWindow setAutoShowInputMethod(boolean autoShow) {
        this.mHelper.setFlag(1024, autoShow);
        return this;
    }

    public BasePopupWindow setAutoShowInputMethod(EditText editText, boolean autoShow) {
        this.mHelper.mAutoShowInputEdittext = editText;
        return this.setAutoShowInputMethod(autoShow);
    }

    @Deprecated
    public BasePopupWindow setSoftInputMode(int softInputMode) {
        this.mHelper.mSoftInputMode = softInputMode;
        return this;
    }

    public BasePopupWindow setBackPressEnable(boolean backPressEnable) {
        this.mHelper.setFlag(4, backPressEnable);
        return this;
    }

    public View createPopupById(int layoutId) {
        return this.mHelper.inflate((Context)this.getContext(), layoutId);
    }

    public <T extends View> T findViewById(int id2) {
        if (this.mContentView != null && id2 != 0) {
            return (T)this.mContentView.findViewById(id2);
        }
        return null;
    }

    @Deprecated
    public BasePopupWindow setPopupWindowFullScreen(boolean isFullScreen) {
        return this.setOverlayStatusbar(isFullScreen);
    }

    public BasePopupWindow setOverlayStatusbar(boolean overlay) {
        this.mHelper.overlayStatusbar(overlay);
        return this;
    }

    public BasePopupWindow setOverlayNavigationBar(boolean overlay) {
        this.mHelper.overlayNavigationBar(overlay);
        return this;
    }

    public BasePopupWindow setBackgroundColor(int color) {
        this.mHelper.setPopupBackground((Drawable)new ColorDrawable(color));
        return this;
    }

    public BasePopupWindow setBackground(int drawableIds) {
        if (drawableIds == 0) {
            return this.setBackground(null);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return this.setBackground(this.getContext().getDrawable(drawableIds));
        }
        return this.setBackground(this.getContext().getResources().getDrawable(drawableIds));
    }

    public BasePopupWindow setBackground(Drawable background) {
        this.mHelper.setPopupBackground(background);
        return this;
    }

    public BasePopupWindow setBackgroundView(View backgroundView) {
        this.mHelper.setBackgroundView(backgroundView);
        return this;
    }

    public Drawable getPopupBackground() {
        return this.mHelper.getPopupBackground();
    }

    public BasePopupWindow setBlurBackgroundEnable(boolean blurBackgroundEnable) {
        return this.setBlurBackgroundEnable(blurBackgroundEnable, null);
    }

    public BasePopupWindow setBlurBackgroundEnable(boolean blurBackgroundEnable, OnBlurOptionInitListener optionInitListener) {
        Activity activity = this.getContext();
        if (activity == null) {
            this.onLogInternal("\u65e0\u6cd5\u914d\u7f6e\u9ed8\u8ba4\u6a21\u7cca\u811a\u672c\uff0c\u56e0\u4e3acontext\u4e0d\u662factivity");
            return this;
        }
        PopupBlurOption option = null;
        if (blurBackgroundEnable) {
            View decorView;
            option = new PopupBlurOption();
            option.setFullScreen(true).setBlurInDuration(-1L).setBlurOutDuration(-1L);
            if (optionInitListener != null) {
                optionInitListener.onCreateBlurOption(option);
            }
            if ((decorView = this.getDecorView()) instanceof ViewGroup && decorView.getId() == 0x1020002) {
                option.setBlurView(((ViewGroup)activity.getWindow().getDecorView()).getChildAt(0));
                option.setFullScreen(true);
            } else {
                option.setBlurView(decorView);
            }
        }
        return this.setBlurOption(option);
    }

    public BasePopupWindow setBlurOption(PopupBlurOption option) {
        this.mHelper.setToBlur(option);
        return this;
    }

    protected void setViewClickListener(View.OnClickListener listener, View ... views) {
        for (View view : views) {
            if (view == null || listener == null) continue;
            view.setOnClickListener(listener);
        }
    }

    public boolean isShowing() {
        return this.mPopupWindowProxy == null ? false : this.mPopupWindowProxy.isShowing();
    }

    public OnDismissListener getOnDismissListener() {
        return this.mHelper.mOnDismissListener;
    }

    public BasePopupWindow setOnPopupWindowShowListener(OnPopupWindowShowListener onPopupWindowShowListener) {
        this.mHelper.mOnPopupWindowShowListener = onPopupWindowShowListener;
        return this;
    }

    public BasePopupWindow setOnDismissListener(OnDismissListener onDismissListener) {
        this.mHelper.mOnDismissListener = onDismissListener;
        return this;
    }

    public OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mHelper.mOnBeforeShowCallback;
    }

    public BasePopupWindow setOnBeforeShowCallback(OnBeforeShowCallback mOnBeforeShowCallback) {
        this.mHelper.mOnBeforeShowCallback = mOnBeforeShowCallback;
        return this;
    }

    public BasePopupWindow setShowAnimation(Animation showAnimation) {
        this.mHelper.setShowAnimation(showAnimation);
        return this;
    }

    public Animation getShowAnimation() {
        return this.mHelper.mShowAnimation;
    }

    public BasePopupWindow setShowAnimator(Animator showAnimator) {
        this.mHelper.setShowAnimator(showAnimator);
        return this;
    }

    public Animator getShowAnimator() {
        return this.mHelper.mShowAnimator;
    }

    public BasePopupWindow setDismissAnimation(Animation dismissAnimation) {
        this.mHelper.setDismissAnimation(dismissAnimation);
        return this;
    }

    public Animation getDismissAnimation() {
        return this.mHelper.mDismissAnimation;
    }

    public BasePopupWindow setDismissAnimator(Animator dismissAnimator) {
        this.mHelper.setDismissAnimator(dismissAnimator);
        return this;
    }

    public Animator getDismissAnimator() {
        return this.mHelper.mDismissAnimator;
    }

    public Activity getContext() {
        return this.mContext;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public View getDisplayAnimateView() {
        return this.mDisplayAnimateView;
    }

    public PopupWindow getPopupWindow() {
        return this.mPopupWindowProxy;
    }

    public int getOffsetX() {
        return this.mHelper.getOffsetX();
    }

    public BasePopupWindow setOffsetX(int offsetX) {
        this.mHelper.offsetX = offsetX;
        return this;
    }

    public int getOffsetY() {
        return this.mHelper.getOffsetY();
    }

    public BasePopupWindow setOffsetY(int offsetY) {
        this.mHelper.offsetY = offsetY;
        return this;
    }

    public int getPopupGravity() {
        return this.mHelper.getPopupGravity();
    }

    public BasePopupWindow setPopupGravity(int popupGravity) {
        return this.setPopupGravity(GravityMode.RELATIVE_TO_ANCHOR, popupGravity);
    }

    public BasePopupWindow setPopupGravity(GravityMode mode, int popupGravity) {
        this.mHelper.setPopupGravity(mode, popupGravity);
        return this;
    }

    public BasePopupWindow setPopupGravityMode(GravityMode mode) {
        this.mHelper.gravityMode = mode;
        return this;
    }

    public boolean isAutoLocatePopup() {
        return this.mHelper.isAutoLocatePopup();
    }

    public BasePopupWindow setAutoLocatePopup(boolean isAutoLocatePopup) {
        this.mHelper.setFlag(256, isAutoLocatePopup);
        return this;
    }

    public int getHeight() {
        if (this.mContentView == null) {
            return this.mHelper.getPreMeasureHeight();
        }
        return this.mContentView.getHeight() <= 0 ? this.mHelper.getPreMeasureHeight() : this.mContentView.getHeight();
    }

    public int getWidth() {
        if (this.mContentView == null) {
            return this.mHelper.getPreMeasureWidth();
        }
        return this.mContentView.getWidth() <= 0 ? this.mHelper.getPreMeasureWidth() : this.mContentView.getWidth();
    }

    @Deprecated
    public BasePopupWindow setAllowDismissWhenTouchOutside(boolean dismissWhenTouchOutside) {
        this.setOutSideDismiss(dismissWhenTouchOutside);
        return this;
    }

    public BasePopupWindow setOutSideDismiss(boolean outSideDismiss) {
        this.mHelper.setFlag(1, outSideDismiss);
        return this;
    }

    @Deprecated
    public BasePopupWindow setAllowInterceptTouchEvent(boolean touchable) {
        this.setOutSideTouchable(!touchable);
        return this;
    }

    public BasePopupWindow setOutSideTouchable(boolean touchable) {
        this.mHelper.setFlag(2, touchable);
        return this;
    }

    public BasePopupWindow setClipChildren(boolean clipChildren) {
        this.mHelper.setFlag(16, clipChildren);
        return this;
    }

    public boolean isAllowDismissWhenTouchOutside() {
        return this.mHelper.isOutSideDismiss();
    }

    @Deprecated
    public boolean isAllowInterceptTouchEvent() {
        return !this.mHelper.isOutSideTouchable();
    }

    public boolean isOutSideTouchable() {
        return this.mHelper.isOutSideTouchable();
    }

    public BasePopupWindow setAlignBackground(boolean isAlignBackground) {
        this.mHelper.setAlignBackgound(isAlignBackground);
        return this;
    }

    public BasePopupWindow setAlignBackgroundGravity(int gravity) {
        this.mHelper.setAlignBackgroundGravity(gravity);
        return this;
    }

    public BasePopupWindow linkTo(View anchorView) {
        this.mHelper.linkTo(anchorView);
        return this;
    }

    public BasePopupWindow setWidth(int width) {
        this.mHelper.setPopupViewWidth(width);
        return this;
    }

    public BasePopupWindow setHeight(int height) {
        this.mHelper.setPopupViewHeight(height);
        return this;
    }

    public BasePopupWindow setMaxWidth(int maxWidth) {
        this.mHelper.maxWidth = maxWidth;
        return this;
    }

    public BasePopupWindow setMaxHeight(int maxHeight) {
        this.mHelper.maxHeight = maxHeight;
        return this;
    }

    public BasePopupWindow setMinWidth(int minWidth) {
        this.mHelper.minWidth = minWidth;
        return this;
    }

    public BasePopupWindow setMinHeight(int minHeight) {
        this.mHelper.minHeight = minHeight;
        return this;
    }

    public BasePopupWindow setFitSize(boolean canResize) {
        this.mHelper.setFlag(4096, canResize);
        return this;
    }

    public BasePopupWindow setMaskViewShowAnimation(Animation animation) {
        this.mHelper.mMaskViewShowAnimation = animation;
        return this;
    }

    public BasePopupWindow setMaskViewDismissAnimation(Animation animation) {
        this.mHelper.mMaskViewDismissAnimation = animation;
        return this;
    }

    public BasePopupWindow syncMaskAnimationDuration(boolean sync) {
        this.mHelper.setFlag(0x1000000, sync);
        return this;
    }

    public BasePopupWindow setOnKeyboardChangeListener(KeyboardUtils.OnKeyboardChangeListener listener) {
        this.mHelper.mUserKeyboardStateChangeListener = listener;
        return this;
    }

    public BasePopupWindow setKeyEventListener(KeyEventListener keyEventListener) {
        this.mHelper.mKeyEventListener = keyEventListener;
        return this;
    }

    public BasePopupWindow setWidthAsAnchorView(boolean widthAsAnchor) {
        this.mHelper.setFlag(0x2000000, widthAsAnchor);
        return this;
    }

    public BasePopupWindow setHeightAsAnchorView(boolean heightAsAnchor) {
        this.mHelper.setFlag(0x4000000, heightAsAnchor);
        return this;
    }

    public BasePopupWindow setLayoutDirection(int layoutDirection) {
        this.mHelper.layoutDirection = layoutDirection;
        return this;
    }

    void superDismiss() {
        try {
            this.mPopupWindowProxy.superDismiss();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mHelper.onDismiss();
        }
    }

    public void dismiss() {
        this.dismiss(true);
    }

    public void dismiss(boolean animateDismiss) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new CalledFromWrongThreadException(PopupUtils.getString(R.string.basepopup_error_thread, new Object[0]));
        }
        if (!this.isShowing() || this.mContentView == null) {
            return;
        }
        this.mHelper.dismiss(animateDismiss);
    }

    @Deprecated
    public void dismissWithOutAnimate() {
        this.dismiss(false);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        this.isDestroyed = true;
        this.onLogInternal("onDestroy");
        this.mHelper.forceDismiss();
        if (this.mPopupWindowProxy != null) {
            this.mPopupWindowProxy.clear(true);
        }
        if (this.mHelper != null) {
            this.mHelper.clear(true);
        }
        this.ownerAnchorParent = null;
        this.mAnchorDecorView = null;
        this.mPopupWindowProxy = null;
        this.mDisplayAnimateView = null;
        this.mContentView = null;
        this.mContext = null;
    }

    private boolean checkPerformShow(View v) {
        boolean result = true;
        if (this.mHelper.mOnBeforeShowCallback != null) {
            result = this.mHelper.mOnBeforeShowCallback.onBeforeShow(this.mContentView, v, this.mHelper.mShowAnimation != null || this.mHelper.mShowAnimator != null);
        }
        return result;
    }

    public boolean onDispatchKeyEvent(KeyEvent event) {
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    public boolean onBackPressed() {
        if (this.mHelper.isBackPressEnable()) {
            this.dismiss();
            return true;
        }
        return false;
    }

    public boolean onOutSideTouch() {
        boolean result = false;
        if (this.mHelper.isOutSideDismiss()) {
            this.dismiss();
            result = true;
        } else if (!this.mHelper.isOutSideTouchable()) {
            result = true;
        }
        return result;
    }

    public void onAnchorTop() {
    }

    public void onAnchorBottom() {
    }

    @Deprecated
    public void onAnchorTop(View mPopupView, View anchorView) {
    }

    @Deprecated
    public void onAnchorBottom(View mPopupView, View anchorView) {
    }

    public void onDismiss() {
        if (this.mHelper.mOnDismissListener != null) {
            this.mHelper.mOnDismissListener.onDismiss();
        }
        this.isExitAnimatePlaying = false;
    }

    public void onShowing() {
    }

    public void onPopupLayout(@NonNull Rect popupRect, @NonNull Rect anchorRect) {
    }

    public int computeGravity(@NonNull Rect popupRect, @NonNull Rect anchorRect) {
        return PopupUiUtils.computeGravity(popupRect, anchorRect);
    }

    protected float dipToPx(float dip) {
        if (this.getContext() == null) {
            return dip;
        }
        return dip * this.getContext().getResources().getDisplayMetrics().density + 0.5f;
    }

    public static void setDebugMode(boolean debugMode) {
        PopupLog.setOpenLog(debugMode);
    }

    protected void onLogInternal(String msg) {
        PopupLog.d(TAG, msg);
    }

    private String ownerParentLog() {
        return PopupUtils.getString(R.string.basepopup_host, String.valueOf(this.ownerAnchorParent));
    }

    public static final class CalledFromWrongThreadException
    extends AndroidRuntimeException {
        public CalledFromWrongThreadException(String msg) {
            super(msg);
        }
    }

    public static interface KeyEventListener {
        public boolean onKey(KeyEvent var1);
    }

    public static interface OnPopupWindowShowListener {
        public void onShowing();
    }

    public static abstract class OnDismissListener
    implements PopupWindow.OnDismissListener {
        public boolean onBeforeDismiss() {
            return true;
        }

        public void onDismissAnimationStart() {
        }
    }

    public static interface OnBlurOptionInitListener {
        public void onCreateBlurOption(PopupBlurOption var1);
    }

    public static interface OnBeforeShowCallback {
        public boolean onBeforeShow(View var1, View var2, boolean var3);
    }

    public static enum GravityMode {
        RELATIVE_TO_ANCHOR,
        ALIGN_TO_ANCHOR_SIDE;

    }
}

