/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import razerdp.basepopup.BasePopupEvent;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.basepopup.PopupBackgroundView;
import razerdp.blur.BlurImageView;
import razerdp.library.R;
import razerdp.util.PopupUtils;
import razerdp.util.log.PopupLog;

class PopupMaskLayout
extends FrameLayout
implements BasePopupEvent.EventObserver,
ClearMemoryObject {
    private BlurImageView mBlurImageView;
    private BackgroundViewHolder mBackgroundViewHolder;
    private BasePopupHelper mPopupHelper;

    private PopupMaskLayout(Context context) {
        super(context);
    }

    private PopupMaskLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private PopupMaskLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    PopupMaskLayout(Context context, BasePopupHelper helper) {
        this(context);
        this.init(context, helper);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PopupMaskLayout.this.mPopupHelper.isOutSideDismiss()) {
                    PopupMaskLayout.this.mPopupHelper.onOutSideTouch();
                }
            }
        });
    }

    private void init(Context context, BasePopupHelper mHelper) {
        this.mPopupHelper = mHelper;
        this.setLayoutAnimation(null);
        if (mHelper == null) {
            this.setBackgroundColor(0);
            return;
        }
        mHelper.observerEvent(this, this);
        if (mHelper.isAllowToBlur()) {
            this.mBlurImageView = new BlurImageView(context);
            this.mBlurImageView.applyBlurOption(mHelper.getBlurOption());
            this.addViewInLayout((View)this.mBlurImageView, -1, (ViewGroup.LayoutParams)this.generateDefaultLayoutParams());
        }
        if (mHelper.getBackgroundView() != null) {
            this.mBackgroundViewHolder = new BackgroundViewHolder(mHelper.getBackgroundView(), mHelper);
        } else if (!PopupUtils.isBackgroundInvalidated(mHelper.getPopupBackground())) {
            this.mBackgroundViewHolder = new BackgroundViewHolder(PopupBackgroundView.creaete(context, mHelper), mHelper);
        }
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.addInLayout();
        }
    }

    public void handleAlignBackground(int gravity, int contentLeft, int contentTop, int contentRight, int contentBottom) {
        int left = this.getLeft();
        int top = this.getTop();
        int right = this.getRight();
        int bottom = this.getBottom();
        switch (gravity & 7) {
            case 3: 
            case 0x800003: {
                left = contentLeft;
                break;
            }
            case 5: 
            case 0x800005: {
                right = contentRight;
                break;
            }
        }
        switch (gravity & 0x70) {
            case 48: {
                top = contentTop;
                break;
            }
            case 80: {
                bottom = contentBottom;
                break;
            }
        }
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.handleAlignBackground(left, top, right, bottom);
        }
    }

    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -1);
    }

    public void update() {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.update();
        }
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.update();
        }
    }

    public void handleStart(long duration) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.start(duration);
        }
    }

    public void handleDismiss(long duration) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.dismiss(duration);
        }
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.dismiss();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeAllViews();
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.destroy();
            this.mBackgroundViewHolder = null;
        }
        if (this.mBlurImageView != null) {
            this.mBlurImageView.destroy();
            this.mBlurImageView = null;
        }
        if (this.mPopupHelper != null) {
            this.mPopupHelper.removeEventObserver(this);
            this.mPopupHelper = null;
        }
    }

    @Override
    public void onEvent(Message msg) {
        if (msg.what == 2) {
            this.handleDismiss(msg.arg1 == 1 ? -2L : 0L);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        PopupLog.i("ddddd", this.getWindowToken(), this.getApplicationWindowToken());
        if (this.mPopupHelper != null && this.mPopupHelper.isOutSideTouchable()) {
            MotionEvent evCopy = MotionEvent.obtain((MotionEvent)ev);
            evCopy.setLocation(ev.getRawX(), ev.getRawY());
            this.mPopupHelper.dispatchOutSideEvent(evCopy);
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public void clear(boolean destroy) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.destroy();
        }
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.clear(destroy);
        }
        if (destroy) {
            this.mPopupHelper = null;
            this.mBackgroundViewHolder = null;
            this.mBlurImageView = null;
        }
    }

    final class BackgroundViewHolder
    implements ClearMemoryObject {
        View mBackgroundView;
        BasePopupHelper mHelper;

        BackgroundViewHolder(View backgroundView, BasePopupHelper helper) {
            Animation fadeIn;
            this.mBackgroundView = backgroundView;
            this.mHelper = helper;
            if (!(this.mBackgroundView instanceof PopupBackgroundView) && this.mHelper.isPopupFadeEnable() && (fadeIn = AnimationUtils.loadAnimation((Context)PopupMaskLayout.this.getContext(), (int)R.anim.basepopup_fade_in)) != null) {
                long fadeInTime = this.mHelper.showDuration - 200L;
                fadeIn.setDuration(Math.max(fadeIn.getDuration(), fadeInTime));
                fadeIn.setFillAfter(true);
                this.mBackgroundView.startAnimation(fadeIn);
            }
        }

        void addInLayout() {
            if (this.mBackgroundView != null) {
                PopupMaskLayout.this.addViewInLayout(this.mBackgroundView, -1, (ViewGroup.LayoutParams)PopupMaskLayout.this.generateDefaultLayoutParams());
            }
        }

        void handleAlignBackground(int left, int top, int right, int bottom) {
            if (this.mBackgroundView == null) {
                return;
            }
            this.mBackgroundView.layout(left, top, right, bottom);
        }

        void update() {
            if (this.mBackgroundView instanceof PopupBackgroundView) {
                ((PopupBackgroundView)this.mBackgroundView).update();
            }
        }

        void dismiss() {
            Animation fadeOut;
            if (this.mBackgroundView instanceof PopupBackgroundView) {
                ((PopupBackgroundView)this.mBackgroundView).handleAnimateDismiss();
            } else if (this.mBackgroundView != null && this.mHelper != null && this.mHelper.isPopupFadeEnable() && (fadeOut = AnimationUtils.loadAnimation((Context)PopupMaskLayout.this.getContext(), (int)R.anim.basepopup_fade_out)) != null) {
                long fadeDismissTime = this.mHelper.dismissDuration - 200L;
                fadeOut.setDuration(Math.max(fadeOut.getDuration(), fadeDismissTime));
                fadeOut.setFillAfter(true);
                this.mBackgroundView.startAnimation(fadeOut);
            }
        }

        void destroy() {
            if (this.mBackgroundView instanceof PopupBackgroundView) {
                ((PopupBackgroundView)this.mBackgroundView).destroy();
                this.mBackgroundView = null;
            } else {
                this.mBackgroundView = null;
            }
        }

        @Override
        public void clear(boolean destroy) {
            if (destroy) {
                this.mBackgroundView = null;
                this.mHelper = null;
            }
        }
    }
}

