/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Animation;
import androidx.annotation.StringRes;
import java.util.List;
import razerdp.basepopup.BasePopupSDK;

public class PopupUtils {
    public static boolean isBackgroundInvalidated(Drawable drawable) {
        return drawable == null || drawable instanceof ColorDrawable && ((ColorDrawable)drawable).getColor() == 0;
    }

    public static View clearViewFromParent(View v) {
        if (v == null) {
            return v;
        }
        ViewParent p = v.getParent();
        if (p instanceof ViewGroup) {
            ((ViewGroup)p).removeView(v);
        }
        return v;
    }

    public static boolean isListEmpty(List<?> datas) {
        return datas == null || datas.size() <= 0;
    }

    public static Activity getActivity(Context from) {
        return PopupUtils.getActivity(from, true);
    }

    public static Activity getActivity(Context from, boolean returnTopIfNull) {
        int limit = 20;
        Context result = from;
        if (result instanceof Activity) {
            return (Activity)result;
        }
        int tryCount = 0;
        while (result instanceof ContextWrapper) {
            if (result instanceof Activity) {
                return (Activity)result;
            }
            if (tryCount > 20) break;
            result = ((ContextWrapper)result).getBaseContext();
            ++tryCount;
        }
        return returnTopIfNull ? BasePopupSDK.getInstance().getTopActivity() : null;
    }

    public static float range(float value, float min, float max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double range(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static int range(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }

    public static long range(long value, long min, long max) {
        return Math.max(min, Math.min(value, max));
    }

    public static long getAnimationDuration(Animation animation, long defaultDuration) {
        if (animation == null) {
            return defaultDuration;
        }
        long result = animation.getDuration();
        return result < 0L ? defaultDuration : result;
    }

    public static long getAnimatorDuration(Animator animator, long defaultDuration) {
        if (animator == null) {
            return defaultDuration;
        }
        long duration = 0L;
        if (animator instanceof AnimatorSet) {
            AnimatorSet set = (AnimatorSet)animator;
            duration = set.getDuration();
            if (duration < 0L) {
                for (Animator childAnimation : set.getChildAnimations()) {
                    duration = Math.max(duration, childAnimation.getDuration());
                }
            }
        } else {
            duration = animator.getDuration();
        }
        return duration < 0L ? defaultDuration : duration;
    }

    public static boolean isActivityAlive(Activity act) {
        if (act == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            return !act.isFinishing() && !act.isDestroyed();
        }
        return !act.isFinishing();
    }

    public static <I, O> O cast(I input, Class<O> outClass, O ... defaultValue) {
        if (input != null && outClass.isAssignableFrom(input.getClass())) {
            try {
                return outClass.cast(input);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (defaultValue != null && defaultValue.length > 0) {
            return defaultValue[0];
        }
        return null;
    }

    public static String gravityToString(int gravity) {
        String split = " | ";
        StringBuilder result = new StringBuilder();
        if ((gravity & 0x77) == 119) {
            result.append("FILL").append(" | ");
        } else {
            if ((gravity & 0x70) == 112) {
                result.append("FILL_VERTICAL").append(" | ");
            } else {
                if ((gravity & 0x30) == 48) {
                    result.append("TOP").append(" | ");
                }
                if ((gravity & 0x50) == 80) {
                    result.append("BOTTOM").append(" | ");
                }
            }
            if ((gravity & 7) == 7) {
                result.append("FILL_HORIZONTAL").append(" | ");
            } else {
                if ((gravity & 0x800003) == 0x800003) {
                    result.append("START").append(" | ");
                } else if ((gravity & 3) == 3) {
                    result.append("LEFT").append(" | ");
                }
                if ((gravity & 0x800005) == 0x800005) {
                    result.append("END").append(" | ");
                } else if ((gravity & 5) == 5) {
                    result.append("RIGHT").append(" | ");
                }
            }
        }
        if ((gravity & 0x11) == 17) {
            result.append("CENTER").append(" | ");
        } else {
            if ((gravity & 0x70) == 16) {
                result.append("CENTER_VERTICAL").append(" | ");
            }
            if ((gravity & 7) == 1) {
                result.append("CENTER_HORIZONTAL").append(" | ");
            }
        }
        if (result.length() == 0) {
            result.append("NO GRAVITY").append(" | ");
        }
        if ((gravity & 0x10000000) == 0x10000000) {
            result.append("DISPLAY_CLIP_VERTICAL").append(" | ");
        }
        if ((gravity & 0x1000000) == 0x1000000) {
            result.append("DISPLAY_CLIP_HORIZONTAL").append(" | ");
        }
        result.delete(result.length() - " | ".length(), result.length());
        return result.toString();
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static String getString(@StringRes int strId, Object ... objs) {
        if (strId == 0) {
            return null;
        }
        try {
            return BasePopupSDK.getApplication().getResources().getString(strId, objs);
        }
        catch (Exception e) {
            return "";
        }
    }
}

