/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.WindowManagerProxy;
import razerdp.util.log.PopupLog;

@Deprecated
@SuppressLint(value={"All"})
public enum BasePopupUnsafe {
    INSTANCE;


    @Deprecated
    public void dismissAllPopup(boolean animateDismiss) {
        HashMap<String, LinkedList<WindowManagerProxy>> allCache = WindowManagerProxy.PopupWindowQueueManager.sQueueMap;
        if (!allCache.isEmpty()) {
            for (LinkedList<WindowManagerProxy> value : allCache.values()) {
                for (WindowManagerProxy proxy : value) {
                    if (proxy.mPopupHelper == null || proxy.mPopupHelper.mPopupWindow == null) continue;
                    proxy.mPopupHelper.mPopupWindow.dismiss(animateDismiss);
                }
            }
        }
    }

    @Deprecated
    @Nullable
    public StackDumpInfo dump(BasePopupWindow p) {
        if (p == null) {
            return null;
        }
        return StackFetcher.record(p);
    }

    @Deprecated
    @Nullable
    public StackDumpInfo getDump(BasePopupWindow p) {
        return StackFetcher.get(p);
    }

    @Deprecated
    @Nullable
    public WindowManager getWindowManager(BasePopupWindow p) {
        try {
            return Objects.requireNonNull(p.mPopupWindowProxy.mBasePopupContextWrapper.mWindowManagerProxy);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    @Nullable
    public View getBasePopupDecorViewProxy(BasePopupWindow p) {
        try {
            return (View)Objects.requireNonNull(((WindowManagerProxy)this.getWindowManager((BasePopupWindow)p)).mPopupDecorViewProxy);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    @Nullable
    public ViewGroup.LayoutParams getDecorViewLayoutParams(BasePopupWindow p) {
        try {
            return this.getBasePopupDecorViewProxy(p).getLayoutParams();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public void setFitWindowManagerLayoutParamsCallback(BasePopupWindow p, OnFitWindowManagerLayoutParamsCallback cb) {
        try {
            p.mHelper.mOnFitWindowManagerLayoutParamsCallback = cb;
        }
        catch (Exception e) {
            PopupLog.e(e);
        }
    }

    @Deprecated
    public static interface OnFitWindowManagerLayoutParamsCallback {
        public void onFitLayoutParams(@NonNull WindowManager.LayoutParams var1);
    }

    public static class StackDumpInfo {
        static volatile StackDumpInfo CACHE = null;
        public String className;
        public String methodName;
        public String lineNum;
        public String popupClassName;
        public String popupAddress;

        public StackDumpInfo(StackTraceElement element) {
            this.record(element);
        }

        void record(StackTraceElement element) {
            if (element != null) {
                this.className = element.getFileName();
                this.methodName = element.getMethodName();
                this.lineNum = String.valueOf(element.getLineNumber());
            }
            this.popupClassName = null;
            this.popupAddress = null;
        }

        static StackDumpInfo obtain(StackTraceElement element) {
            if (CACHE != null) {
                CACHE.record(element);
                return CACHE;
            }
            return new StackDumpInfo(element);
        }

        public String toString() {
            return "StackDumpInfo{className='" + this.className + '\'' + ", methodName='" + this.methodName + '\'' + ", lineNum='" + this.lineNum + '\'' + ", popupClassName='" + this.popupClassName + '\'' + ", popupAddress='" + this.popupAddress + '\'' + '}';
        }
    }

    static class StackFetcher {
        private static final Map<String, StackDumpInfo> STACK_MAP = new HashMap<String, StackDumpInfo>();

        StackFetcher() {
        }

        private static StackTraceElement getCurrentStackTrace() {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            int stackOffset = PopupLog.getStackOffset(trace, BasePopupUnsafe.class);
            if (stackOffset == -1 && (stackOffset = PopupLog.getStackOffset(trace, StackFetcher.class)) == -1) {
                return null;
            }
            return trace[stackOffset];
        }

        private static StackDumpInfo record(BasePopupWindow p) {
            return STACK_MAP.put(StackFetcher.key(p), StackDumpInfo.obtain(StackFetcher.getCurrentStackTrace()));
        }

        static void remove(BasePopupWindow p) {
            StackDumpInfo.CACHE = STACK_MAP.remove(StackFetcher.key(p));
        }

        private static StackDumpInfo get(BasePopupWindow p) {
            String[] msg;
            String key = StackFetcher.key(p);
            StackDumpInfo info = STACK_MAP.get(StackFetcher.key(p));
            if (!TextUtils.isEmpty((CharSequence)key) && info != null && (msg = key.split("@")).length == 2) {
                info.popupClassName = msg[0];
                info.popupAddress = msg[1];
            }
            return info;
        }

        private static String key(BasePopupWindow p) {
            return String.valueOf(p);
        }
    }
}

