/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.PopupKeyboardStateChangeListener;
import razerdp.basepopup.PopupMaskLayout;
import razerdp.basepopup.WindowManagerProxy;
import razerdp.util.PopupUiUtils;
import razerdp.util.PopupUtils;
import razerdp.util.log.PopupLog;

final class PopupDecorViewProxy
extends ViewGroup
implements PopupKeyboardStateChangeListener {
    private static final String TAG = "PopupDecorViewProxy";
    private PopupMaskLayout mMaskLayout;
    private BasePopupHelper mHelper;
    private View mTarget;
    private Rect mTouchRect = new Rect();
    private int childLeftMargin;
    private int childTopMargin;
    private int childRightMargin;
    private int childBottomMargin;
    private static int statusBarHeight;
    private CheckAndCallAutoAnchorLocate mCheckAndCallAutoAnchorLocate;
    private WindowManagerProxy mWindowManagerProxy;
    private Flag mFlag = new Flag();
    private Rect viewRect = new Rect();
    private int offset;
    private int originY;
    private ValueAnimator valueAnimator;
    private boolean lastVisibleState;

    private PopupDecorViewProxy(Context context) {
        this(context, null);
    }

    private PopupDecorViewProxy(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private PopupDecorViewProxy(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public static PopupDecorViewProxy create(Context context, WindowManagerProxy windowManagerProxy, BasePopupHelper helper) {
        PopupDecorViewProxy result = new PopupDecorViewProxy(context);
        result.init(helper, windowManagerProxy);
        return result;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void init(BasePopupHelper helper, WindowManagerProxy managerProxy) {
        this.mWindowManagerProxy = managerProxy;
        this.mHelper = helper;
        this.mHelper.registerKeyboardStateChangeListener(this);
        this.setClipChildren(this.mHelper.isClipChildren());
        this.mMaskLayout = PopupMaskLayout.create(this.getContext(), this.mHelper);
        this.mFlag.flag = 0;
        if (!this.mHelper.isOutSideTouchable()) {
            this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.addViewInLayout((View)this.mMaskLayout, -1, new ViewGroup.LayoutParams(-1, -1));
            this.mMaskLayout.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            return PopupDecorViewProxy.this.mHelper.isOutSideDismiss();
                        }
                        case 1: {
                            if (!PopupDecorViewProxy.this.mHelper.isOutSideDismiss()) break;
                            int x = (int)event.getX();
                            int y = (int)event.getY();
                            if (PopupDecorViewProxy.this.mTarget != null) {
                                View contentView = PopupDecorViewProxy.this.mTarget.findViewById(PopupDecorViewProxy.this.mHelper.getContentRootId());
                                if (contentView == null) {
                                    PopupDecorViewProxy.this.mTarget.getGlobalVisibleRect(PopupDecorViewProxy.this.mTouchRect);
                                } else {
                                    contentView.getGlobalVisibleRect(PopupDecorViewProxy.this.mTouchRect);
                                }
                            }
                            if (PopupDecorViewProxy.this.mTouchRect.contains(x, y)) break;
                            PopupDecorViewProxy.this.mHelper.onOutSideTouch();
                        }
                    }
                    return false;
                }
            });
        } else {
            this.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            Activity act = PopupUtils.scanForActivity(this.getContext(), 15);
            if (act == null) {
                return;
            }
            this.checkAndClearDecorMaskLayout(act);
            this.addMaskToDecor(act.getWindow());
        }
    }

    private void checkAndClearDecorMaskLayout(Activity act) {
        if (act == null || act.getWindow() == null) {
            return;
        }
        View decorView = act.getWindow().getDecorView();
        if (decorView instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)decorView;
            int childCount = vg.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = vg.getChildAt(i);
                if (!(child instanceof PopupMaskLayout)) continue;
                vg.removeViewInLayout(child);
            }
        }
    }

    private void addMaskToDecor(Window window) {
        View decorView;
        View view = decorView = window == null ? null : window.getDecorView();
        if (!(decorView instanceof ViewGroup)) {
            if (this.mMaskLayout != null) {
                this.mMaskLayout.onDetachedFromWindow();
                this.mMaskLayout = null;
            }
            return;
        }
        ((ViewGroup)decorView).addView((View)this.mMaskLayout, -1, -1);
    }

    public void addPopupDecorView(View target, WindowManager.LayoutParams params) {
        if (target == null) {
            throw new NullPointerException("contentView\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getChildCount() == 2) {
            this.removeViewsInLayout(1, 1);
        }
        this.mTarget = target;
        WindowManager.LayoutParams wp = new WindowManager.LayoutParams();
        wp.copyFrom(params);
        wp.x = 0;
        wp.y = 0;
        if (this.mHelper.getParaseFromXmlParams() == null) {
            View contentView = this.findContentView(target);
            if (contentView != null) {
                if (!this.mHelper.isCustomMeasure()) {
                    if (wp.width <= 0) {
                        int n = wp.width = contentView.getMeasuredWidth() <= 0 ? this.mHelper.getPopupViewWidth() : contentView.getMeasuredWidth();
                    }
                    if (wp.height <= 0) {
                        wp.height = contentView.getMeasuredHeight() <= 0 ? this.mHelper.getPopupViewHeight() : contentView.getMeasuredHeight();
                    }
                } else {
                    wp.width = this.mHelper.getPopupViewWidth();
                    wp.height = this.mHelper.getPopupViewHeight();
                }
            }
        } else {
            View child;
            if (target instanceof ViewGroup && (child = ((ViewGroup)target).getChildAt(0)) != null) {
                child.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mHelper.getParaseFromXmlParams()));
            }
            wp.width = this.mHelper.getPopupViewWidth();
            wp.height = this.mHelper.getPopupViewHeight();
            this.childLeftMargin = this.mHelper.getParaseFromXmlParams().leftMargin;
            this.childTopMargin = this.mHelper.getParaseFromXmlParams().topMargin;
            this.childRightMargin = this.mHelper.getParaseFromXmlParams().rightMargin;
            this.childBottomMargin = this.mHelper.getParaseFromXmlParams().bottomMargin;
        }
        this.addView(target, (ViewGroup.LayoutParams)wp);
    }

    private View findContentView(View root) {
        if (root == null) {
            return null;
        }
        if (!(root instanceof ViewGroup)) {
            return root;
        }
        ViewGroup rootGroup = (ViewGroup)root;
        if (rootGroup.getChildCount() <= 0) {
            return root;
        }
        String viewSimpleClassName = rootGroup.getClass().getSimpleName();
        View result = null;
        while (!this.isContentView(viewSimpleClassName)) {
            result = rootGroup.getChildAt(0);
            viewSimpleClassName = result.getClass().getSimpleName();
            if (!(result instanceof ViewGroup)) break;
            rootGroup = (ViewGroup)result;
        }
        return result;
    }

    private boolean isContentView(String contentClassName) {
        return !TextUtils.equals((CharSequence)contentClassName, (CharSequence)"PopupDecorView") && !TextUtils.equals((CharSequence)contentClassName, (CharSequence)"PopupViewContainer") && !TextUtils.equals((CharSequence)contentClassName, (CharSequence)"PopupBackgroundView");
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mFlag.flag &= 0xFFFFFFFE;
        this.mFlag.flag &= 0xFFFFFFEF;
        PopupLog.i("onMeasure", View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        if (!this.mHelper.isOutSideTouchable()) {
            this.measureWithIntercept(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureWithOutIntercept(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void measureWithIntercept(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.getResources().getConfiguration().orientation == 2) {
            if (widthSize < heightSize) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
            }
        } else if (widthSize > heightSize) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
        }
        PopupLog.i("measureWithIntercept", View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == this.mMaskLayout) {
                this.measureChild(child, View.MeasureSpec.makeMeasureSpec((int)this.getScreenWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getScreenHeight(), (int)0x40000000));
                continue;
            }
            this.measureWrappedDecorView(child, widthMeasureSpec, heightMeasureSpec);
        }
        this.setMeasuredDimension(this.getScreenWidth(), this.getScreenHeight());
    }

    private void measureWithOutIntercept(int widthMeasureSpec, int heightMeasureSpec) {
        int maxWidth = 0;
        int maxHeight = 0;
        int childState = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == this.mTarget) {
                this.measureWrappedDecorView(this.mTarget, widthMeasureSpec, heightMeasureSpec);
            } else {
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            }
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            childState = PopupDecorViewProxy.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
        }
        this.setMeasuredDimension(PopupDecorViewProxy.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), PopupDecorViewProxy.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
    }

    private void measureWrappedDecorView(View mTarget, int widthMeasureSpec, int heightMeasureSpec) {
        boolean needCheckRest;
        if (mTarget == null || mTarget.getVisibility() == 8) {
            return;
        }
        ViewGroup.LayoutParams lp = mTarget.getLayoutParams();
        widthMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)lp.width);
        heightMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)lp.height);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int gravity = this.mHelper.getPopupGravity();
        boolean isAlignAnchorMode = this.mHelper.getGravityMode() == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE;
        boolean bl = needCheckRest = this.mHelper.isClipToScreen() && this.mHelper.isShowAsDropDown();
        if (needCheckRest) {
            int restWidth = widthSize;
            if (widthSize > (restWidth = PopupUtils.range(restWidth, this.mHelper.getMinWidth(), restWidth)) && !this.mHelper.isKeepSize()) {
                widthSize = restWidth;
                this.mFlag.flag |= 1;
            }
        }
        if (this.mHelper.getMinWidth() > 0 && heightSize < this.mHelper.getMinWidth()) {
            widthSize = this.mHelper.getMinWidth();
        }
        if (this.mHelper.getMaxWidth() > 0 && widthSize > this.mHelper.getMaxWidth()) {
            widthSize = this.mHelper.getMaxWidth();
        }
        if (needCheckRest) {
            int restHeight;
            switch (gravity & 0x70) {
                case 48: {
                    int n = restHeight = isAlignAnchorMode ? this.getScreenHeight() - this.mHelper.getAnchorY() : this.mHelper.getAnchorY();
                    if (!this.mHelper.isAutoLocatePopup() || (this.mHelper.getMinHeight() <= 0 || restHeight >= this.mHelper.getMinHeight()) && restHeight > heightSize >> 2) break;
                    restHeight = isAlignAnchorMode ? this.getScreenHeight() - this.mHelper.getAnchorY() : this.getScreenHeight() - (this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight());
                    break;
                }
                default: {
                    int n = restHeight = isAlignAnchorMode ? this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight() : this.getScreenHeight() - (this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight());
                    if (!this.mHelper.isAutoLocatePopup() || (this.mHelper.getMinHeight() <= 0 || restHeight >= this.mHelper.getMinHeight()) && restHeight > heightSize >> 2) break;
                    int n2 = restHeight = isAlignAnchorMode ? this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight() : this.mHelper.getAnchorY();
                }
            }
            if ((restHeight = restHeight - this.childTopMargin - this.childBottomMargin) <= 0) {
                Log.e((String)TAG, (String)"BasePopup \u53ef\u7528\u5c55\u793a\u7a7a\u95f4\u5c0f\u4e8e\u6216\u7b49\u4e8e0\uff0c\u9ad8\u5ea6\u5c06\u6309\u539f\u6d4b\u91cf\u503c\u8bbe\u5b9a\uff0c\u4e0d\u8fdb\u884c\u8c03\u6574\u9002\u914d");
                restHeight = heightSize;
                this.mFlag.flag |= 0x10;
            } else {
                restHeight = PopupUtils.range(restHeight, this.mHelper.getMinHeight(), restHeight);
            }
            if (heightSize > restHeight && !this.mHelper.isKeepSize()) {
                heightSize = restHeight;
                this.mFlag.flag |= 0x10;
            }
        }
        if (this.mHelper.getMinHeight() > 0 && heightSize < this.mHelper.getMinHeight()) {
            heightSize = this.mHelper.getMinHeight();
        }
        if (this.mHelper.getMaxHeight() > 0 && heightSize > this.mHelper.getMaxHeight()) {
            heightSize = this.mHelper.getMaxHeight();
        }
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        mTarget.measure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        PopupLog.i("onLayout", changed, l, t, r, b);
        if (!this.mHelper.isOutSideTouchable()) {
            this.layoutWithIntercept(l, t, r, b);
        } else {
            this.layoutWithOutIntercept(l, t, r, b);
        }
    }

    private void layoutWithOutIntercept(int l, int t, int r, int b) {
        int childCount;
        if ((this.mFlag.flag & 0x100) != 0 && this.getLayoutParams() instanceof WindowManager.LayoutParams) {
            this.mWindowManagerProxy.updateViewLayout((View)this, this.getLayoutParams());
        }
        if ((childCount = this.getChildCount()) > 0) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                child.layout(l, t, r, b);
                if (child != this.mTarget || this.mMaskLayout == null || !this.mHelper.isAlignBackground() || this.mHelper.getAlignBackgroundGravity() == 0) continue;
                if (this.getLayoutParams() instanceof WindowManager.LayoutParams) {
                    WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.getLayoutParams();
                    l += p.x;
                    t += p.y;
                    r += p.x;
                    b += p.y;
                }
                this.mMaskLayout.handleAlignBackground(this.mHelper.getAlignBackgroundGravity(), l, t, r, b);
            }
        }
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void layoutWithIntercept(int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            boolean isOverFlowScreen;
            int windowBottom;
            int windowRight;
            int windowTop;
            int windowLeft;
            boolean delayLayoutMask;
            int offsetY;
            int offsetX;
            int childTop;
            int childLeft;
            int height;
            int width;
            View child;
            block31: {
                block30: {
                    child = this.getChildAt(i);
                    if (child.getVisibility() == 8) continue;
                    width = child.getMeasuredWidth();
                    height = child.getMeasuredHeight();
                    int gravity = this.mHelper.getPopupGravity();
                    childLeft = l;
                    childTop = t;
                    offsetX = this.mHelper.getOffsetX();
                    offsetY = this.mHelper.getOffsetY();
                    delayLayoutMask = this.mHelper.isAlignBackground() && this.mHelper.getAlignBackgroundGravity() != 0;
                    windowLeft = 0;
                    windowTop = 0;
                    windowRight = this.getMeasuredWidth();
                    windowBottom = this.getMeasuredHeight();
                    if (child == this.mMaskLayout) {
                        child.layout(childLeft, childTop, childLeft + width, childTop + height);
                        continue;
                    }
                    boolean isRelativeToAnchor = this.mHelper.isShowAsDropDown();
                    boolean isAlignAnchorMode = this.mHelper.getGravityMode() == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE;
                    int anchorCenterX = this.mHelper.getAnchorX() + (this.mHelper.getAnchorWidth() >> 1);
                    int anchorCenterY = this.mHelper.getAnchorY() + (this.mHelper.getAnchorHeight() >> 1);
                    switch (gravity & 7) {
                        case 3: {
                            if (!isRelativeToAnchor) break;
                            childLeft = isAlignAnchorMode ? this.mHelper.getAnchorX() : this.mHelper.getAnchorX() - width;
                            break;
                        }
                        case 5: {
                            if (isRelativeToAnchor) {
                                childLeft = isAlignAnchorMode ? this.mHelper.getAnchorX() + this.mHelper.getAnchorWidth() - width : this.mHelper.getAnchorX() + this.mHelper.getAnchorWidth();
                                break;
                            }
                            childLeft = this.getMeasuredWidth() - width;
                            break;
                        }
                        case 1: {
                            if (isRelativeToAnchor) {
                                childLeft = this.mHelper.getAnchorX();
                                offsetX += anchorCenterX - (childLeft + (width >> 1));
                                break;
                            }
                            childLeft = r - l - width >> 1;
                            break;
                        }
                        default: {
                            if (!isRelativeToAnchor) break;
                            childLeft = this.mHelper.getAnchorX();
                        }
                    }
                    windowLeft = 0;
                    windowRight = this.getMeasuredWidth();
                    childLeft = childLeft + this.childLeftMargin - this.childRightMargin;
                    switch (gravity & 0x70) {
                        case 48: {
                            if (!isRelativeToAnchor) break;
                            childTop = isAlignAnchorMode ? this.mHelper.getAnchorY() : this.mHelper.getAnchorY() - height;
                            windowTop = isAlignAnchorMode ? this.mHelper.getAnchorY() : 0;
                            windowBottom = isAlignAnchorMode ? this.getMeasuredHeight() : this.mHelper.getAnchorY();
                            break;
                        }
                        case 80: {
                            if (isRelativeToAnchor) {
                                childTop = isAlignAnchorMode ? this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight() - height : this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight();
                                windowTop = isAlignAnchorMode ? 0 : this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight();
                                windowBottom = isAlignAnchorMode ? this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight() : this.getMeasuredHeight();
                                break;
                            }
                            childTop = b - t - height;
                            break;
                        }
                        case 16: {
                            if (isRelativeToAnchor) {
                                childTop = this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight();
                                offsetY += anchorCenterY - (childTop + (height >> 1));
                                windowTop = 0;
                                windowBottom = this.getMeasuredHeight();
                                break;
                            }
                            childTop = b - t - height >> 1;
                            break;
                        }
                        default: {
                            if (!isRelativeToAnchor) break;
                            windowTop = 0;
                            windowBottom = this.getMeasuredHeight();
                            childTop = this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight();
                        }
                    }
                    childTop = childTop + this.childTopMargin - this.childBottomMargin;
                    if (!this.mHelper.isAutoLocatePopup() || !this.mHelper.isClipToScreen()) break block30;
                    int tBottom = childTop + offsetY + (this.mHelper.isFullScreen() ? 0 : -PopupUiUtils.getStatusBarHeight(this.getContext()));
                    switch (gravity & 0x70) {
                        case 48: {
                            int restHeight;
                            int n = restHeight = isAlignAnchorMode ? this.getMeasuredHeight() - this.mHelper.getAnchorY() : this.mHelper.getAnchorY();
                            if (height > restHeight) {
                                offsetY += isAlignAnchorMode ? 0 : this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight() - childTop;
                                windowTop = this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight();
                                this.postAnchorLocation(false);
                                break;
                            }
                            break block31;
                        }
                        default: {
                            int restHeight;
                            int n = restHeight = isAlignAnchorMode ? this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight() : this.getMeasuredHeight() - (this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight());
                            if (height > restHeight) {
                                offsetY -= isAlignAnchorMode ? 0 : tBottom - this.mHelper.getAnchorY();
                                windowTop = 0;
                                windowBottom = this.mHelper.getAnchorY();
                                this.postAnchorLocation(true);
                                break;
                            }
                            break block31;
                        }
                    }
                    break block31;
                }
                windowLeft = 0;
                windowTop = 0;
                windowRight = this.getMeasuredWidth();
                windowBottom = this.getMeasuredHeight();
            }
            int left = childLeft + offsetX;
            int top = childTop + offsetY + (this.mHelper.isFullScreen() ? 0 : -PopupUiUtils.getStatusBarHeight(this.getContext()));
            int right = left + width;
            int bottom = top + height;
            boolean bl = isOverFlowScreen = left < 0 || top < 0 || right > this.getMeasuredWidth() || bottom > this.getMeasuredHeight();
            if (this.mHelper.isClipToScreen() && isOverFlowScreen) {
                int tOffset = 0;
                if (left < windowLeft) {
                    tOffset = windowLeft - left;
                    if (tOffset <= windowRight - right) {
                        right = (left += tOffset) + width;
                    } else {
                        left = windowLeft;
                    }
                }
                if (right > windowRight) {
                    tOffset = right - windowRight;
                    right = tOffset <= left ? (left -= tOffset) + width : windowRight;
                }
                if (top < windowTop) {
                    tOffset = windowTop - top;
                    if (tOffset <= windowBottom - bottom) {
                        bottom = (top += tOffset) + height;
                    } else {
                        top = windowTop;
                    }
                }
                if (bottom > windowBottom) {
                    tOffset = bottom - windowBottom;
                    bottom = windowTop == 0 ? (top -= tOffset) + height : top + height;
                }
            }
            child.layout(left, top, right, bottom);
            if (!delayLayoutMask) continue;
            this.mMaskLayout.handleAlignBackground(this.mHelper.getAlignBackgroundGravity(), left, top, right, bottom);
        }
    }

    public void fitWindowParams(WindowManager.LayoutParams params) {
        if (this.getMeasuredWidth() == 0 || this.getMeasuredHeight() == 0) {
            this.mFlag.flag |= 0x100;
            return;
        }
        int offsetX = 0;
        int offsetY = 0;
        int gravity = this.mHelper.getPopupGravity();
        boolean isAlignAnchorMode = this.mHelper.getGravityMode() == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE;
        switch (this.mHelper.getPopupGravity() & 7) {
            case 3: {
                if (!this.mHelper.isShowAsDropDown()) break;
                offsetX += isAlignAnchorMode ? this.mHelper.getAnchorX() : this.mHelper.getAnchorX() - this.getMeasuredWidth();
                break;
            }
            case 5: {
                if (this.mHelper.isShowAsDropDown()) {
                    offsetX += isAlignAnchorMode ? this.mHelper.getAnchorX() + this.mHelper.getAnchorWidth() - this.getMeasuredWidth() : this.mHelper.getAnchorX() + this.mHelper.getAnchorWidth();
                    break;
                }
                offsetX += this.getScreenWidth() - this.getMeasuredWidth();
                break;
            }
            case 1: {
                offsetX += this.mHelper.isShowAsDropDown() ? this.mHelper.getAnchorX() + (this.mHelper.getAnchorWidth() - this.getMeasuredWidth() >> 1) : this.getScreenWidth() - this.getMeasuredWidth() >> 1;
                break;
            }
        }
        offsetX = offsetX + this.childLeftMargin - this.childRightMargin;
        switch (this.mHelper.getPopupGravity() & 0x70) {
            case 48: {
                if (!this.mHelper.isShowAsDropDown()) break;
                offsetY += isAlignAnchorMode ? this.mHelper.getAnchorY() : this.mHelper.getAnchorY() - this.getMeasuredHeight();
                break;
            }
            case 80: {
                if (this.mHelper.isShowAsDropDown()) {
                    offsetY += isAlignAnchorMode ? this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight() - this.getMeasuredHeight() : this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight();
                    break;
                }
                offsetY += this.getScreenHeight() - this.getMeasuredHeight();
                break;
            }
            case 16: {
                offsetY += this.mHelper.isShowAsDropDown() ? this.mHelper.getAnchorY() + (this.mHelper.getAnchorHeight() - this.getMeasuredHeight() >> 1) : this.getScreenHeight() - this.getMeasuredHeight() >> 1;
                break;
            }
        }
        offsetY = offsetY + this.childTopMargin - this.childBottomMargin;
        PopupLog.i("fitWindowParams  ::  {\n\t\tscreenWidth = " + this.getScreenWidth() + "\n\t\tscreenHeight = " + this.getScreenHeight() + "\n\t\tanchorX = " + this.mHelper.getAnchorX() + "\n\t\tanchorY = " + this.mHelper.getAnchorY() + "\n\t\tviewWidth = " + this.getMeasuredWidth() + "\n\t\tviewHeight = " + this.getMeasuredHeight() + "\n\t\toffsetX = " + offsetX + "\n\t\toffsetY = " + offsetY + "\n}");
        if (this.mHelper.isAutoLocatePopup() && this.mHelper.isClipToScreen()) {
            int tBottom = offsetY + (this.mHelper.isFullScreen() ? 0 : -PopupUiUtils.getStatusBarHeight(this.getContext()));
            switch (gravity & 0x70) {
                case 48: {
                    int restHeight;
                    int n = restHeight = isAlignAnchorMode ? this.getScreenHeight() - this.mHelper.getAnchorY() : this.mHelper.getAnchorY();
                    if (this.getMeasuredHeight() <= restHeight) break;
                    offsetY += isAlignAnchorMode ? 0 : this.mHelper.getAnchorY() + this.mHelper.getMinHeight() - offsetY;
                    this.postAnchorLocation(false);
                    break;
                }
                default: {
                    int restHeight;
                    int n = restHeight = isAlignAnchorMode ? this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight() : this.getScreenHeight() - (this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight());
                    if (this.getMeasuredHeight() <= restHeight) break;
                    offsetY -= isAlignAnchorMode ? 0 : tBottom - this.mHelper.getAnchorY();
                    this.postAnchorLocation(true);
                }
            }
        }
        params.x = offsetX + this.mHelper.getOffsetX();
        this.originY = params.y = offsetY + this.mHelper.getOffsetY();
        this.mFlag.flag &= 0xFFFFFEFF;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mMaskLayout != null) {
            this.mMaskLayout.handleStart(-2L);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mHelper != null) {
            return this.mHelper.onInterceptTouchEvent(ev);
        }
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean intercept;
        boolean bl = intercept = this.mHelper != null && this.mHelper.onDispatchKeyEvent(event);
        if (intercept) {
            return true;
        }
        if (event.getKeyCode() == 4) {
            KeyEvent.DispatcherState state;
            if (this.getKeyDispatcherState() == null) {
                return super.dispatchKeyEvent(event);
            }
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                if (state2 != null) {
                    state2.startTracking(event, (Object)this);
                }
                return true;
            }
            if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled() && this.mHelper != null) {
                PopupLog.i(TAG, "dispatchKeyEvent: >>> onBackPressed");
                return this.mHelper.onBackPressed();
            }
            return super.dispatchKeyEvent(event);
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mHelper != null && this.mHelper.onTouchEvent(event)) {
            return true;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (event.getAction() == 0 && (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight())) {
            if (this.mHelper != null) {
                PopupLog.i(TAG, "onTouchEvent:[ACTION_DOWN] >>> onOutSideTouch");
                return this.mHelper.onOutSideTouch();
            }
        } else if (event.getAction() == 4 && this.mHelper != null) {
            PopupLog.i(TAG, "onTouchEvent:[ACTION_OUTSIDE] >>> onOutSideTouch");
            return this.mHelper.onOutSideTouch();
        }
        return super.onTouchEvent(event);
    }

    int getScreenWidth() {
        int screenWidth = PopupUiUtils.getScreenWidthCompat(this.getContext());
        PopupLog.i("autoSize  width = " + screenWidth);
        return screenWidth;
    }

    int getScreenHeight() {
        int screenHeight = PopupUiUtils.getScreenHeightCompat(this.getContext());
        PopupLog.i("autoSize  height = " + screenHeight);
        return screenHeight;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mHelper.isOutSideTouchable() && this.mMaskLayout != null && this.mMaskLayout.getParent() != null) {
            ((ViewGroup)this.mMaskLayout.getParent()).removeViewInLayout((View)this.mMaskLayout);
        }
        this.mHelper.registerKeyboardStateChangeListener(null);
        if (this.mCheckAndCallAutoAnchorLocate != null) {
            this.removeCallbacks(this.mCheckAndCallAutoAnchorLocate);
            this.mCheckAndCallAutoAnchorLocate = null;
        }
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void updateLayout() {
        if (this.mHelper != null) {
            this.mHelper.onUpdate();
        }
        if (this.mMaskLayout != null) {
            this.mMaskLayout.update();
        }
        if (this.isLayoutRequested()) {
            this.requestLayout();
        }
    }

    private void removeAnchorLocationChecker() {
        if (this.mCheckAndCallAutoAnchorLocate != null) {
            this.removeCallbacks(this.mCheckAndCallAutoAnchorLocate);
        }
    }

    private void postAnchorLocation(boolean onTop) {
        if (this.mCheckAndCallAutoAnchorLocate == null) {
            this.mCheckAndCallAutoAnchorLocate = new CheckAndCallAutoAnchorLocate(onTop);
        } else {
            this.removeAnchorLocationChecker();
        }
        this.mCheckAndCallAutoAnchorLocate.onTop = onTop;
        this.postDelayed(this.mCheckAndCallAutoAnchorLocate, 32L);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        PopupDecorViewProxy v = this;
        if (this.getContext() instanceof Activity) {
            v = ((Activity)this.getContext()).getWindow().getDecorView();
        }
        v.post(new Runnable(){

            @Override
            public void run() {
                PopupDecorViewProxy.this.updateLayout();
            }
        });
    }

    @Override
    public void onKeyboardChange(int keyboardTop, int keyboardHeight, boolean isVisible, boolean fullScreen) {
        if (PopupUiUtils.getScreenOrientation(this.getContext()) == 2) {
            return;
        }
        if (this.mHelper.getSoftInputMode() == 32 || this.mHelper.getSoftInputMode() == 16) {
            int customOffset;
            int y;
            View focusView = this.findFocus();
            if (focusView == null || this.lastVisibleState == isVisible) {
                return;
            }
            focusView.getGlobalVisibleRect(this.viewRect);
            final ViewGroup.LayoutParams p = this.getLayoutParams();
            int n = this.mHelper.isOutSideTouchable() ? (p instanceof WindowManager.LayoutParams ? ((WindowManager.LayoutParams)p).y : this.mTarget.getTop()) : (y = 0);
            if (!fullScreen) {
                y -= PopupUiUtils.getStatusBarHeight(this.getContext());
            }
            if (isVisible && keyboardTop > 0) {
                boolean alignToDecorView;
                int decorBottom = y + this.mTarget.getBottom();
                int targetBottomOffset = decorBottom - keyboardTop;
                boolean bl = alignToDecorView = targetBottomOffset > 0 && y + this.viewRect.top >= targetBottomOffset;
                if (alignToDecorView) {
                    this.offset = targetBottomOffset;
                } else if (this.viewRect.bottom > keyboardTop) {
                    this.offset = this.viewRect.bottom - keyboardTop;
                }
            } else {
                this.offset = 0;
            }
            if (this.mHelper.getEventInterceptor() != null && (customOffset = this.mHelper.getEventInterceptor().onKeyboardChangeResult(keyboardHeight, isVisible, this.offset)) != 0) {
                this.offset = customOffset;
            }
            if (this.mHelper.isOutSideTouchable()) {
                if (this.valueAnimator != null) {
                    this.valueAnimator.cancel();
                }
                this.valueAnimator = ValueAnimator.ofInt((int[])new int[]{y, isVisible ? y - this.offset : this.originY});
                this.valueAnimator.setDuration(300L);
                this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        if (p instanceof WindowManager.LayoutParams) {
                            ((WindowManager.LayoutParams)p).y = (Integer)animation.getAnimatedValue();
                            PopupDecorViewProxy.this.mWindowManagerProxy.updateViewLayoutOriginal((View)PopupDecorViewProxy.this, p);
                        }
                    }
                });
                this.valueAnimator.start();
            } else {
                this.mTarget.animate().cancel();
                this.mTarget.animate().translationY((float)(-this.offset)).setDuration(300L).start();
                PopupLog.i("onKeyboardChange", isVisible, keyboardHeight, this.offset);
            }
            this.lastVisibleState = isVisible;
        }
    }

    static class Flag {
        static final int IDLE = 0;
        static final int FLAG_REST_WIDTH_NOT_ENOUGH = 1;
        static final int FLAG_REST_HEIGHT_NOT_ENOUGH = 16;
        static final int FLAG_WINDOW_PARAMS_FIT_REQUEST = 256;
        int flag;

        Flag() {
        }
    }

    private final class CheckAndCallAutoAnchorLocate
    implements Runnable {
        private boolean onTop;
        private boolean hasCalled;

        CheckAndCallAutoAnchorLocate(boolean onTop) {
            this.onTop = onTop;
        }

        @Override
        public void run() {
            if (PopupDecorViewProxy.this.mHelper == null || this.hasCalled) {
                return;
            }
            if (this.onTop) {
                PopupDecorViewProxy.this.mHelper.onAnchorTop();
            } else {
                PopupDecorViewProxy.this.mHelper.onAnchorBottom();
            }
            this.hasCalled = true;
        }
    }
}

