/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import razerdp.basepopup.BasePopupSupporter;
import razerdp.basepopup.BasePopupWindow;
import razerdp.util.PopupUtils;
import razerdp.util.log.PopupLog;

public final class BasePopupSupporterManager {
    BasePopupSupporterProxy proxy;
    private WeakReference<Activity> mTopActivity;
    private int account = 0;

    private BasePopupSupporterManager() {
    }

    void init(Context context) {
        if (this.proxy != null) {
            return;
        }
        if (context instanceof Application) {
            this.regLifeCallback((Application)context);
        } else {
            this.regLifeCallback((Application)context.getApplicationContext());
        }
        this.proxy = new BasePopupSupporterProxy(context);
    }

    public Activity getTopActivity() {
        return this.mTopActivity == null ? null : (Activity)this.mTopActivity.get();
    }

    public boolean isAppOnBackground() {
        PopupLog.i("isAppOnBackground", this.account <= 0);
        return this.account <= 0;
    }

    private void regLifeCallback(Application context) {
        context.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
                BasePopupSupporterManager.this.account++;
            }

            public void onActivityResumed(Activity activity) {
                BasePopupSupporterManager.this.mTopActivity = new WeakReference<Activity>(activity);
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
                BasePopupSupporterManager.this.account--;
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
    }

    public static BasePopupSupporterManager getInstance() {
        return SingleTonHolder.INSTANCE;
    }

    private boolean isClassExist(String name) {
        try {
            Class.forName(name);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static class SingleTonHolder {
        private static BasePopupSupporterManager INSTANCE = new BasePopupSupporterManager();

        private SingleTonHolder() {
        }
    }

    class BasePopupSupporterProxy
    implements BasePopupSupporter {
        private List<BasePopupSupporter> IMPL = new ArrayList<BasePopupSupporter>();
        private static final String IMPL_SUPPORT = "razerdp.basepopup.BasePopupSupporterSupport";
        private static final String IMPL_LIFECYCLE = "razerdp.basepopup.BasePopupSupporterLifeCycle";
        private static final String IMPL_X = "razerdp.basepopup.BasePopupSupporterX";

        BasePopupSupporterProxy(Context context) {
            try {
                if (BasePopupSupporterManager.this.isClassExist(IMPL_SUPPORT)) {
                    this.IMPL.add((BasePopupSupporter)Class.forName(IMPL_SUPPORT).newInstance());
                }
                if (BasePopupSupporterManager.this.isClassExist(IMPL_LIFECYCLE)) {
                    this.IMPL.add((BasePopupSupporter)Class.forName(IMPL_LIFECYCLE).newInstance());
                }
                if (BasePopupSupporterManager.this.isClassExist(IMPL_X)) {
                    this.IMPL.add((BasePopupSupporter)Class.forName(IMPL_X).newInstance());
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            PopupLog.i(this.IMPL);
        }

        @Override
        public View findDecorView(BasePopupWindow basePopupWindow, Activity activity) {
            if (PopupUtils.isListEmpty(this.IMPL)) {
                return null;
            }
            for (BasePopupSupporter basePopupSupporter : this.IMPL) {
                View result = basePopupSupporter.findDecorView(basePopupWindow, activity);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public BasePopupWindow attachLifeCycle(BasePopupWindow basePopupWindow, Object owner) {
            if (PopupUtils.isListEmpty(this.IMPL)) {
                return null;
            }
            for (BasePopupSupporter basePopupSupporter : this.IMPL) {
                if (basePopupWindow.lifeCycleObserver != null) {
                    return basePopupWindow;
                }
                basePopupSupporter.attachLifeCycle(basePopupWindow, owner);
            }
            return basePopupWindow;
        }

        @Override
        public BasePopupWindow removeLifeCycle(BasePopupWindow basePopupWindow, Object owner) {
            if (PopupUtils.isListEmpty(this.IMPL)) {
                return null;
            }
            for (BasePopupSupporter basePopupSupporter : this.IMPL) {
                if (basePopupWindow.lifeCycleObserver == null) {
                    return basePopupWindow;
                }
                basePopupSupporter.removeLifeCycle(basePopupWindow, owner);
            }
            return basePopupWindow;
        }
    }
}

