/*
 * Decompiled with CFR 0.152.
 */
package razerdp.widget;

import android.animation.Animator;
import android.content.Context;
import android.util.Pair;
import android.view.View;
import android.view.animation.Animation;
import java.util.HashMap;
import java.util.Map;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.QuickPopupBuilder;
import razerdp.basepopup.QuickPopupConfig;
import razerdp.widget.OnQuickPopupClickListenerWrapper;

public class QuickPopup
extends BasePopupWindow {
    private QuickPopupConfig mConfig;
    private QuickPopupBuilder.OnConfigApplyListener mOnConfigApplyListener;

    private QuickPopup(Context context) {
        super(context);
    }

    private QuickPopup(Context context, boolean delayInit) {
        super(context, delayInit);
    }

    private QuickPopup(Context context, int width, int height) {
        super(context, width, height);
    }

    private QuickPopup(Context context, int width, int height, boolean delayInit) {
        super(context, width, height, delayInit);
    }

    public QuickPopup(Context context, QuickPopupConfig config, QuickPopupBuilder.OnConfigApplyListener onConfigApplyListener, int w, int h) {
        super(context, w, h, true);
        this.mConfig = config;
        this.mOnConfigApplyListener = onConfigApplyListener;
        if (this.mConfig == null) {
            throw new NullPointerException("QuickPopupConfig must be not null!");
        }
        this.delayInit();
        this.applyConfigSetting(this.mConfig);
    }

    protected <C extends QuickPopupConfig> void applyConfigSetting(C config) {
        if (config.getPopupBlurOption() != null) {
            this.setBlurOption(config.getPopupBlurOption());
        } else {
            this.setBlurBackgroundEnable(config.isBlurBackground(), config.getOnBlurOptionInitListener());
        }
        this.setPopupFadeEnable(config.isFadeEnable());
        this.applyClick();
        this.setOffsetX(config.getOffsetX());
        this.setOffsetY(config.getOffsetY());
        this.setClipChildren(config.isClipChildren());
        this.setClipToScreen(config.isClipToScreen());
        this.setAllowDismissWhenTouchOutside(config.isDismissOutSide());
        this.setAllowInterceptTouchEvent(config.isAllowInterceptTouchEvent());
        this.setPopupGravity(config.getGravity());
        this.setAlignBackground(config.isAlignBackground());
        this.setAutoLocatePopup(config.isAutoLocated());
        this.setOnDismissListener(config.getDismissListener());
        if (config.getBackground() != null) {
            this.setBackground(config.getBackground());
        }
        this.linkTo(config.getLinkedView());
        if (this.mOnConfigApplyListener != null) {
            this.mOnConfigApplyListener.onConfigApply(this, config);
        }
    }

    private void applyClick() {
        HashMap<Integer, Pair<View.OnClickListener, Boolean>> eventsMap = this.mConfig.getListenersHolderMap();
        if (eventsMap == null || eventsMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, Pair<View.OnClickListener, Boolean>> entry : eventsMap.entrySet()) {
            int viewId = entry.getKey();
            final Pair<View.OnClickListener, Boolean> event = entry.getValue();
            Object v = this.findViewById(viewId);
            if (v == null) continue;
            if (((Boolean)event.second).booleanValue()) {
                v.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (event.first != null) {
                            if (event.first instanceof OnQuickPopupClickListenerWrapper) {
                                ((OnQuickPopupClickListenerWrapper)event.first).mQuickPopup = QuickPopup.this;
                            }
                            ((View.OnClickListener)event.first).onClick(v);
                        }
                        QuickPopup.this.dismiss();
                    }
                });
                continue;
            }
            v.setOnClickListener((View.OnClickListener)event.first);
        }
    }

    public QuickPopupConfig getConfig() {
        return this.mConfig;
    }

    @Override
    protected Animation onCreateShowAnimation() {
        return this.mConfig.getShowAnimation();
    }

    @Override
    protected Animation onCreateDismissAnimation() {
        return this.mConfig.getDismissAnimation();
    }

    @Override
    protected Animator onCreateDismissAnimator() {
        return this.mConfig.getDismissAnimator();
    }

    @Override
    protected Animator onCreateShowAnimator() {
        return this.mConfig.getShowAnimator();
    }

    @Override
    public View onCreateContentView() {
        return this.createPopupById(this.mConfig.getContentViewLayoutid());
    }
}

