/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.PopupKeyboardStateChangeListener;
import razerdp.basepopup.PopupMaskLayout;
import razerdp.util.PopupUiUtils;
import razerdp.util.PopupUtils;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

final class PopupDecorViewProxy
extends ViewGroup
implements PopupKeyboardStateChangeListener {
    private static final String TAG = "PopupDecorViewProxy";
    private PopupMaskLayout mMaskLayout;
    private BasePopupHelper mHelper;
    private View mTarget;
    private Rect mTouchRect = new Rect();
    private int childLeftMargin;
    private int childTopMargin;
    private int childRightMargin;
    private int childBottomMargin;
    private static int statusBarHeight;
    private CheckAndCallAutoAnchorLocate mCheckAndCallAutoAnchorLocate;
    private Rect viewRect = new Rect();
    private int offset;

    private PopupDecorViewProxy(Context context) {
        this(context, null);
    }

    private PopupDecorViewProxy(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private PopupDecorViewProxy(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public static PopupDecorViewProxy create(Context context, BasePopupHelper helper) {
        PopupDecorViewProxy result = new PopupDecorViewProxy(context);
        result.init(helper);
        return result;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void init(BasePopupHelper helper) {
        this.mHelper = helper;
        this.mHelper.registerKeyboardStateChangeListener(this);
        this.setClipChildren(this.mHelper.isClipChildren());
        this.mMaskLayout = PopupMaskLayout.create(this.getContext(), this.mHelper);
        if (this.mHelper.isInterceptTouchEvent()) {
            this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.addViewInLayout((View)this.mMaskLayout, -1, new ViewGroup.LayoutParams(-1, -1));
            this.mMaskLayout.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            return PopupDecorViewProxy.this.mHelper.isDismissWhenTouchOutside();
                        }
                        case 1: {
                            if (!PopupDecorViewProxy.this.mHelper.isDismissWhenTouchOutside()) break;
                            int x = (int)event.getX();
                            int y = (int)event.getY();
                            if (PopupDecorViewProxy.this.mTarget != null) {
                                View contentView = PopupDecorViewProxy.this.mTarget.findViewById(PopupDecorViewProxy.this.mHelper.getContentRootId());
                                if (contentView == null) {
                                    PopupDecorViewProxy.this.mTarget.getGlobalVisibleRect(PopupDecorViewProxy.this.mTouchRect);
                                } else {
                                    contentView.getGlobalVisibleRect(PopupDecorViewProxy.this.mTouchRect);
                                }
                            }
                            if (PopupDecorViewProxy.this.mTouchRect.contains(x, y)) break;
                            PopupDecorViewProxy.this.mHelper.onOutSideTouch();
                        }
                    }
                    return false;
                }
            });
        } else {
            this.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            Activity act = PopupUtils.scanForActivity(this.getContext(), 50);
            if (act == null) {
                return;
            }
            this.checkAndClearDecorMaskLayout(act);
            this.addMaskToDecor(act.getWindow());
        }
    }

    private void checkAndClearDecorMaskLayout(Activity act) {
        if (act == null || act.getWindow() == null || act.getWindow().getDecorView() == null) {
            return;
        }
        View decorView = act.getWindow().getDecorView();
        if (decorView instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)decorView;
            int childCount = vg.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = vg.getChildAt(i);
                if (!(child instanceof PopupMaskLayout)) continue;
                vg.removeViewInLayout(child);
            }
        }
    }

    private void addMaskToDecor(Window window) {
        View decorView;
        View view = decorView = window == null ? null : window.getDecorView();
        if (!(decorView instanceof ViewGroup)) {
            if (this.mMaskLayout != null) {
                this.mMaskLayout.onDetachedFromWindow();
                this.mMaskLayout = null;
            }
            return;
        }
        ((ViewGroup)decorView).addView((View)this.mMaskLayout, -1, -1);
    }

    public void addPopupDecorView(View target, WindowManager.LayoutParams params) {
        if (target == null) {
            throw new NullPointerException("contentView\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getChildCount() == 2) {
            this.removeViewsInLayout(1, 1);
        }
        this.mTarget = target;
        WindowManager.LayoutParams wp = new WindowManager.LayoutParams();
        wp.copyFrom(params);
        wp.x = 0;
        wp.y = 0;
        if (this.mHelper.getParaseFromXmlParams() == null) {
            View contentView = this.findContentView(target);
            if (contentView != null) {
                if (!this.mHelper.isCustomMeasure()) {
                    if (wp.width <= 0) {
                        int n = wp.width = contentView.getMeasuredWidth() <= 0 ? this.mHelper.getPopupViewWidth() : contentView.getMeasuredWidth();
                    }
                    if (wp.height <= 0) {
                        wp.height = contentView.getMeasuredHeight() <= 0 ? this.mHelper.getPopupViewHeight() : contentView.getMeasuredHeight();
                    }
                } else {
                    wp.width = this.mHelper.getPopupViewWidth();
                    wp.height = this.mHelper.getPopupViewHeight();
                }
            }
        } else {
            wp.width = this.mHelper.getPopupViewWidth();
            wp.height = this.mHelper.getPopupViewHeight();
            this.childLeftMargin = this.mHelper.getParaseFromXmlParams().leftMargin;
            this.childTopMargin = this.mHelper.getParaseFromXmlParams().topMargin;
            this.childRightMargin = this.mHelper.getParaseFromXmlParams().rightMargin;
            this.childBottomMargin = this.mHelper.getParaseFromXmlParams().bottomMargin;
        }
        this.addView(target, (ViewGroup.LayoutParams)wp);
    }

    private View findContentView(View root) {
        if (root == null) {
            return null;
        }
        if (!(root instanceof ViewGroup)) {
            return root;
        }
        ViewGroup rootGroup = (ViewGroup)root;
        if (rootGroup.getChildCount() <= 0) {
            return root;
        }
        String viewSimpleClassName = rootGroup.getClass().getSimpleName();
        View result = null;
        while (!this.isContentView(viewSimpleClassName)) {
            result = rootGroup.getChildAt(0);
            viewSimpleClassName = result.getClass().getSimpleName();
            if (!(result instanceof ViewGroup)) break;
            rootGroup = (ViewGroup)result;
        }
        return result;
    }

    private boolean isContentView(String contentClassName) {
        return !TextUtils.equals((CharSequence)contentClassName, (CharSequence)"PopupDecorView") && !TextUtils.equals((CharSequence)contentClassName, (CharSequence)"PopupViewContainer") && !TextUtils.equals((CharSequence)contentClassName, (CharSequence)"PopupBackgroundView");
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mHelper.isInterceptTouchEvent()) {
            this.measureWithIntercept(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureWithOutIntercept(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void measureWithIntercept(int widthMeasureSpec, int heightMeasureSpec) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == this.mMaskLayout) {
                this.measureChild(child, View.MeasureSpec.makeMeasureSpec((int)this.getScreenWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getScreenHeight(), (int)0x40000000));
                continue;
            }
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            int childWidthMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.childLeftMargin + this.childRightMargin), (int)lp.width);
            int fixedHeightMeasureSpec = heightMeasureSpec;
            if (this.mHelper.isClipToScreen() && this.mHelper.isShowAsDropDown() && lp.height == -1) {
                int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                int restContentHeight = this.getScreenHeight() - (this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight()) - this.childTopMargin - this.childBottomMargin;
                if (restContentHeight == 0) {
                    restContentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
                }
                fixedHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)restContentHeight, (int)mode);
            }
            int childHeightMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)fixedHeightMeasureSpec, (int)(this.childTopMargin + this.childBottomMargin), (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
        this.setMeasuredDimension(this.getScreenWidth(), this.getScreenHeight());
    }

    private void measureWithOutIntercept(int widthMeasureSpec, int heightMeasureSpec) {
        int maxWidth = 0;
        int maxHeight = 0;
        int childState = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            if (child == this.mTarget) {
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                int fixedHeightMeasureSpec = heightMeasureSpec;
                if (this.mHelper.isClipToScreen() && this.mHelper.isShowAsDropDown() && lp.height == -1) {
                    int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                    int restContentHeight = this.getScreenHeight() - (this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight()) - this.childTopMargin - this.childBottomMargin;
                    if (restContentHeight == 0) {
                        restContentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
                    }
                    fixedHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)restContentHeight, (int)mode);
                }
                int childHeightMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)fixedHeightMeasureSpec, (int)(this.childTopMargin + this.childBottomMargin), (int)lp.height);
                child.measure(widthMeasureSpec, childHeightMeasureSpec);
            } else {
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            }
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            childState = PopupDecorViewProxy.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
        }
        this.setMeasuredDimension(PopupDecorViewProxy.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), PopupDecorViewProxy.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mHelper.isInterceptTouchEvent()) {
            this.layoutWithIntercept(l, t, r, b);
        } else {
            this.layoutWithOutIntercept(l, t, r, b);
        }
    }

    private void layoutWithOutIntercept(int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                child.layout(l, t, r, b);
                if (child != this.mTarget || this.mMaskLayout == null || !this.mHelper.isAlignBackground() || this.mHelper.getAlignBackgroundGravity() == 0) continue;
                if (this.getLayoutParams() instanceof WindowManager.LayoutParams) {
                    WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.getLayoutParams();
                    l += p.x;
                    t += p.y;
                    r += p.x;
                    b += p.y;
                }
                this.mMaskLayout.handleAlignBackground(this.mHelper.getAlignBackgroundGravity(), l, t, r, b);
            }
        }
    }

    private void layoutWithIntercept(int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            boolean isOverFlowScreen;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = this.mHelper.getPopupGravity();
            int childLeft = child.getLeft();
            int childTop = child.getTop();
            int offsetX = this.mHelper.getOffsetX();
            int offsetY = this.mHelper.getOffsetY();
            boolean delayLayoutMask = this.mHelper.isAlignBackground() && this.mHelper.getAlignBackgroundGravity() != 0;
            boolean keepClipScreenTop = false;
            if (child == this.mMaskLayout) {
                child.layout(childLeft, childTop, childLeft + width, childTop + height);
                continue;
            }
            boolean isRelativeToAnchor = this.mHelper.isShowAsDropDown();
            int anchorCenterX = this.mHelper.getAnchorX() + (this.mHelper.getAnchorViewWidth() >> 1);
            int anchorCenterY = this.mHelper.getAnchorY() + (this.mHelper.getAnchorHeight() >> 1);
            switch (gravity & 7) {
                case 3: 
                case 0x800003: {
                    if (isRelativeToAnchor) {
                        childLeft = this.mHelper.getAnchorX() - width + this.childLeftMargin - this.childRightMargin;
                        break;
                    }
                    childLeft += this.childLeftMargin;
                    break;
                }
                case 5: 
                case 0x800005: {
                    if (isRelativeToAnchor) {
                        childLeft = this.mHelper.getAnchorX() + this.mHelper.getAnchorViewWidth() + this.childLeftMargin - this.childRightMargin;
                        break;
                    }
                    childLeft = this.getMeasuredWidth() - width - this.childRightMargin;
                    break;
                }
                case 1: {
                    if (isRelativeToAnchor) {
                        childLeft = this.mHelper.getAnchorX();
                        offsetX += anchorCenterX - (childLeft + (width >> 1));
                        break;
                    }
                    childLeft = (r - l - width >> 1) + this.childLeftMargin - this.childRightMargin;
                    break;
                }
                default: {
                    if (!isRelativeToAnchor) break;
                    childLeft = this.mHelper.getAnchorX() + this.childLeftMargin - this.childRightMargin;
                }
            }
            switch (gravity & 0x70) {
                case 48: {
                    if (isRelativeToAnchor) {
                        childTop = this.mHelper.getAnchorY() - height + this.childTopMargin - this.childBottomMargin;
                        break;
                    }
                    childTop += this.childTopMargin;
                    break;
                }
                case 80: {
                    if (isRelativeToAnchor) {
                        keepClipScreenTop = true;
                        childTop = this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight() + this.childTopMargin - this.childBottomMargin;
                        break;
                    }
                    childTop = b - t - height - this.childBottomMargin;
                    break;
                }
                case 16: {
                    if (isRelativeToAnchor) {
                        childTop = this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight();
                        offsetY += anchorCenterY - (childTop + (height >> 1));
                        break;
                    }
                    childTop = (b - t - height >> 1) + this.childTopMargin - this.childBottomMargin;
                    break;
                }
                default: {
                    if (isRelativeToAnchor) {
                        keepClipScreenTop = true;
                        childTop = this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight() + this.childTopMargin - this.childBottomMargin;
                        break;
                    }
                    childTop += this.childTopMargin;
                }
            }
            int left = childLeft + offsetX;
            int top = childTop + offsetY + (this.mHelper.isFullScreen() ? 0 : -this.getStatusBarHeight());
            int right = left + width;
            int bottom = top + height;
            int adjustAutoLocatedResult = 0;
            if (this.mHelper.isAutoLocatePopup()) {
                boolean onTop = false;
                if (height >= this.getFixedMeasureHeight()) {
                    onTop = anchorCenterY >= this.getFixedMeasureHeight() >> 1;
                } else {
                    int showContentHeight = Math.abs(this.getFixedMeasureHeight() - top);
                    onTop = bottom > this.getFixedMeasureHeight() && showContentHeight < top && showContentHeight < height;
                }
                this.removeAnchorLocationChecker();
                if (onTop) {
                    adjustAutoLocatedResult = -1;
                    bottom = (top += -(this.mHelper.getAnchorHeight() + height)) + height;
                    this.postAnchorLocation(true);
                } else {
                    adjustAutoLocatedResult = 1;
                    this.postAnchorLocation(false);
                }
            }
            boolean bl = isOverFlowScreen = left < 0 || top < 0 || right > this.getMeasuredWidth() || bottom > this.getFixedMeasureHeight();
            if (this.mHelper.isClipToScreen() && isOverFlowScreen) {
                int screenLeft = 0;
                int screenTop = keepClipScreenTop ? childTop : 0;
                int screenRight = this.getMeasuredWidth();
                int screenBottom = this.getFixedMeasureHeight();
                if (adjustAutoLocatedResult != 0) {
                    switch (adjustAutoLocatedResult) {
                        case -1: {
                            screenTop = 0;
                            screenBottom = childTop - this.mHelper.getAnchorHeight();
                            break;
                        }
                        case 1: {
                            if (height < this.getFixedMeasureHeight()) break;
                            screenTop = childTop;
                        }
                    }
                }
                int tOffset = 0;
                if (left < screenLeft) {
                    tOffset = screenLeft - left;
                    if (tOffset <= screenRight - right) {
                        right = (left += tOffset) + width;
                    } else {
                        left = screenLeft;
                    }
                }
                if (right > screenRight) {
                    tOffset = right - screenRight;
                    right = tOffset <= left ? (left -= tOffset) + width : screenRight;
                }
                if (top < screenTop) {
                    tOffset = screenTop - top;
                    if (tOffset <= screenBottom - bottom) {
                        bottom = (top += tOffset) + height;
                    } else {
                        top = screenTop;
                    }
                }
                if (bottom > screenBottom) {
                    tOffset = bottom - screenBottom;
                    bottom = screenTop == 0 ? (top -= tOffset) + height : top + height;
                }
            }
            child.layout(left, top, right, bottom);
            if (!delayLayoutMask) continue;
            this.mMaskLayout.handleAlignBackground(this.mHelper.getAlignBackgroundGravity(), left, top, right, bottom);
        }
    }

    private int getFixedMeasureHeight() {
        return this.mHelper.isFullScreen() ? this.getMeasuredHeight() : this.getMeasuredHeight() - this.getStatusBarHeight();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mMaskLayout != null) {
            this.mMaskLayout.handleStart(-2L);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mHelper != null) {
            return this.mHelper.onInterceptTouchEvent(ev);
        }
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean intercept;
        boolean bl = intercept = this.mHelper != null && this.mHelper.onDispatchKeyEvent(event);
        if (intercept) {
            return true;
        }
        if (event.getKeyCode() == 4) {
            KeyEvent.DispatcherState state;
            if (this.getKeyDispatcherState() == null) {
                return super.dispatchKeyEvent(event);
            }
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                if (state2 != null) {
                    state2.startTracking(event, (Object)this);
                }
                return true;
            }
            if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled() && this.mHelper != null) {
                PopupLogUtil.trace(LogTag.i, TAG, "dispatchKeyEvent: >>> onBackPressed");
                return this.mHelper.onBackPressed();
            }
            return super.dispatchKeyEvent(event);
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mHelper != null && this.mHelper.onTouchEvent(event)) {
            return true;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (event.getAction() == 0 && (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight())) {
            if (this.mHelper != null) {
                PopupLogUtil.trace(LogTag.i, TAG, "onTouchEvent:[ACTION_DOWN] >>> onOutSideTouch");
                return this.mHelper.onOutSideTouch();
            }
        } else if (event.getAction() == 4 && this.mHelper != null) {
            PopupLogUtil.trace(LogTag.i, TAG, "onTouchEvent:[ACTION_OUTSIDE] >>> onOutSideTouch");
            return this.mHelper.onOutSideTouch();
        }
        return super.onTouchEvent(event);
    }

    int getScreenWidth() {
        int screenWidth = PopupUiUtils.getScreenWidthCompat(this.getContext());
        PopupLogUtil.trace("autoSize  width = " + screenWidth);
        return screenWidth;
    }

    int getScreenHeight() {
        int screenHeight = PopupUiUtils.getScreenHeightCompat(this.getContext());
        PopupLogUtil.trace("autoSize  height = " + screenHeight);
        return screenHeight;
    }

    private int getStatusBarHeight() {
        this.checkStatusBarHeight(this.getContext());
        return statusBarHeight;
    }

    private void checkStatusBarHeight(Context context) {
        if (statusBarHeight != 0 || context == null) {
            return;
        }
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        statusBarHeight = result;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.mHelper.isInterceptTouchEvent() && this.mMaskLayout != null && this.mMaskLayout.getParent() != null) {
            ((ViewGroup)this.mMaskLayout.getParent()).removeViewInLayout((View)this.mMaskLayout);
        }
        this.mHelper.registerKeyboardStateChangeListener(null);
        if (this.mCheckAndCallAutoAnchorLocate != null) {
            this.removeCallbacks(this.mCheckAndCallAutoAnchorLocate);
            this.mCheckAndCallAutoAnchorLocate = null;
        }
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void updateLayout() {
        if (this.mMaskLayout != null) {
            this.mMaskLayout.update();
        }
        if (this.isLayoutRequested()) {
            this.requestLayout();
        }
    }

    private void removeAnchorLocationChecker() {
        if (this.mCheckAndCallAutoAnchorLocate != null) {
            this.removeCallbacks(this.mCheckAndCallAutoAnchorLocate);
        }
    }

    private void postAnchorLocation(boolean onTop) {
        if (this.mCheckAndCallAutoAnchorLocate == null) {
            this.mCheckAndCallAutoAnchorLocate = new CheckAndCallAutoAnchorLocate(onTop);
        }
        this.postDelayed(this.mCheckAndCallAutoAnchorLocate, 16L);
    }

    @Override
    public void onKeyboardChange(int keyboardHeight, boolean isVisible) {
        if (this.mHelper.getSoftInputMode() == 32 || this.mHelper.getSoftInputMode() == 16) {
            int customOffset;
            View focusView = this.findFocus();
            if (focusView == null) {
                return;
            }
            focusView.getGlobalVisibleRect(this.viewRect);
            if (isVisible) {
                boolean alignToDecorView;
                int keyboardTop = this.getScreenHeight() - keyboardHeight;
                int targetBottomOffset = this.mTarget.getBottom() - keyboardTop;
                boolean bl = alignToDecorView = targetBottomOffset > 0 && this.viewRect.top >= targetBottomOffset;
                if (alignToDecorView) {
                    this.offset = targetBottomOffset;
                } else if (this.viewRect.bottom > keyboardTop) {
                    this.offset = this.viewRect.bottom - keyboardTop;
                }
            } else {
                this.offset = 0;
            }
            if (this.mHelper.getEventInterceptor() != null && (customOffset = this.mHelper.getEventInterceptor().onKeyboardChangeResult(keyboardHeight, isVisible, this.offset)) != 0) {
                this.offset = customOffset;
            }
            this.mTarget.animate().translationY((float)(-this.offset)).setDuration(300L).start();
            PopupLogUtil.trace("onKeyboardChange : isVisible = " + isVisible + "  offset = " + this.offset);
        }
    }

    private final class CheckAndCallAutoAnchorLocate
    implements Runnable {
        private boolean onTop;
        private boolean hasCalled;

        public CheckAndCallAutoAnchorLocate(boolean onTop) {
            this.onTop = onTop;
        }

        @Override
        public void run() {
            if (PopupDecorViewProxy.this.mHelper == null || this.hasCalled) {
                return;
            }
            if (this.onTop) {
                PopupDecorViewProxy.this.mHelper.onAnchorTop();
            } else {
                PopupDecorViewProxy.this.mHelper.onAnchorBottom();
            }
            this.hasCalled = true;
        }
    }
}

