/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import razerdp.basepopup.BasePopupWindowProxy;

final class PopupCompatManager {
    private static final String TAG = "PopupCompatManager";
    private static final int FULL_SCREEN_FLAG = 5894;
    private static final PopupWindowImpl IMPL = new Impl();

    PopupCompatManager() {
    }

    public static void showAsDropDown(BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
        if (IMPL != null) {
            IMPL.showAsDropDown(popupWindow, anchor, xoff, yoff, gravity);
        }
    }

    public static void showAtLocation(BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
        if (IMPL != null) {
            IMPL.showAtLocation(popupWindow, parent, gravity, x, y);
        }
    }

    public static void clear(BasePopupWindowProxy popupWindow) {
        if (IMPL != null) {
            IMPL.clear(popupWindow);
        }
    }

    static boolean needListenUiVisibilityChange(Activity act) {
        if (act == null) {
            return false;
        }
        try {
            View decorView = act.getWindow().getDecorView();
            WindowManager.LayoutParams lp = act.getWindow().getAttributes();
            int i = lp.flags;
            int f = decorView.getWindowSystemUiVisibility();
            return (i & 0x400) != 0 && ((f & 2) != 0 || (f & 0x200) != 0);
        }
        catch (Exception e) {
            return false;
        }
    }

    static class Impl
    extends BaseImpl {
        int[] anchorLocation = new int[2];

        Impl() {
        }

        @Override
        void showAsDropDownImpl(Activity activity, BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
            if (anchor != null) {
                anchor.getLocationInWindow(this.anchorLocation);
                xoff = this.anchorLocation[0];
                yoff = this.anchorLocation[1] + anchor.getHeight();
            }
            popupWindow.callSuperShowAtLocation(activity.getWindow().getDecorView(), 0, xoff, yoff);
        }

        @Override
        void showAtLocationImpl(Activity activity, BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
            popupWindow.callSuperShowAtLocation(parent, gravity, x, y);
        }
    }

    static abstract class BaseImpl
    implements PopupWindowImpl {
        BaseImpl() {
        }

        abstract void showAsDropDownImpl(Activity var1, BasePopupWindowProxy var2, View var3, int var4, int var5, int var6);

        abstract void showAtLocationImpl(Activity var1, BasePopupWindowProxy var2, View var3, int var4, int var5, int var6);

        @Override
        public void showAsDropDown(BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
            if (this.isPopupShowing(popupWindow)) {
                return;
            }
            Activity activity = popupWindow.scanForActivity(anchor.getContext());
            if (activity == null) {
                Log.e((String)PopupCompatManager.TAG, (String)"please make sure that context is instance of activity");
                return;
            }
            this.onBeforeShowExec(popupWindow, activity);
            this.showAsDropDownImpl(activity, popupWindow, anchor, xoff, yoff, gravity);
            this.onAfterShowExec(popupWindow, activity);
        }

        @Override
        public void showAtLocation(BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
            if (this.isPopupShowing(popupWindow)) {
                return;
            }
            Activity activity = popupWindow.scanForActivity(parent.getContext());
            if (activity == null) {
                Log.e((String)PopupCompatManager.TAG, (String)"please make sure that context is instance of activity");
                return;
            }
            this.onBeforeShowExec(popupWindow, activity);
            this.showAtLocationImpl(activity, popupWindow, parent, gravity, x, y);
            this.onAfterShowExec(popupWindow, activity);
        }

        @Override
        public void clear(BasePopupWindowProxy popupWindow) {
        }

        protected void onBeforeShowExec(BasePopupWindowProxy popupWindowProxy, Activity act) {
            if (PopupCompatManager.needListenUiVisibilityChange(act)) {
                popupWindowProxy.handleFullScreenFocusable();
            }
        }

        protected void onAfterShowExec(BasePopupWindowProxy popupWindowProxy, Activity act) {
            if (popupWindowProxy.isHandledFullScreen()) {
                popupWindowProxy.getContentView().setSystemUiVisibility(5894);
                popupWindowProxy.restoreFocusable();
            }
        }

        boolean isPopupShowing(BasePopupWindowProxy popupWindow) {
            return popupWindow != null && popupWindow.callSuperIsShowing();
        }
    }

    static interface PopupWindowImpl {
        public void showAsDropDown(BasePopupWindowProxy var1, View var2, int var3, int var4, int var5);

        public void showAtLocation(BasePopupWindowProxy var1, View var2, int var3, int var4, int var5);

        public void clear(BasePopupWindowProxy var1);
    }
}

