/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.util.concurrent.atomic.AtomicInteger;
import razerdp.util.PopupUtils;

public class PopupUiUtils {
    private static final int CHECK_SHIFT = 4;
    private static final int CHECK_MASK = 48;
    private static final int PORTRAIT = 0;
    private static final int LANDSCAPE = 1;
    private static volatile Point[] mRealSizes = new Point[2];
    private static final Point point = new Point();
    private static AtomicInteger mFullDisplayCheckFlag = new AtomicInteger(0);

    public static int getNavigationBarHeight(Context context) {
        if (!PopupUiUtils.checkHasNavigationBar(context)) {
            return 0;
        }
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean checkHasNavigationBar(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            boolean hasMenuKey = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
            boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
            return !hasMenuKey && !hasBackKey;
        }
        Activity act = PopupUtils.scanForActivity(context, 50);
        if (act == null) {
            return false;
        }
        ViewGroup decorView = (ViewGroup)act.getWindow().getDecorView();
        if (decorView != null) {
            int childCount = decorView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = decorView.getChildAt(i);
                if (child == null || child.getId() == -1 || !child.isShown() || !TextUtils.equals((CharSequence)"navigationBarBackground", (CharSequence)act.getResources().getResourceEntryName(child.getId()))) continue;
                return true;
            }
        }
        return false;
    }

    public static int getScreenHeightCompat(Context context) {
        int orientation;
        if (Build.VERSION.SDK_INT < 21) {
            return context.getResources().getDisplayMetrics().heightPixels;
        }
        int n = orientation = context.getResources().getConfiguration().orientation == 1 ? 0 : 1;
        if (mRealSizes[orientation] == null) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            if (windowManager == null) {
                return context.getResources().getDisplayMetrics().heightPixels;
            }
            Display display = windowManager.getDefaultDisplay();
            display.getRealSize(point);
            PopupUiUtils.mRealSizes[orientation] = point;
        }
        return PopupUiUtils.mRealSizes[orientation].y - PopupUiUtils.getNavigationBarHeight(context);
    }

    public static int getScreenWidthCompat(Context context) {
        int orientation;
        if (Build.VERSION.SDK_INT < 21) {
            return context.getResources().getDisplayMetrics().widthPixels;
        }
        int n = orientation = context.getResources().getConfiguration().orientation == 1 ? 0 : 1;
        if (mRealSizes[orientation] == null) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            if (windowManager == null) {
                return context.getResources().getDisplayMetrics().widthPixels;
            }
            Display display = windowManager.getDefaultDisplay();
            Point point = new Point();
            display.getRealSize(point);
            PopupUiUtils.mRealSizes[orientation] = point;
        }
        return PopupUiUtils.mRealSizes[orientation].x;
    }

    public static boolean isFullDisplay(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        if ((mFullDisplayCheckFlag.get() & 0x30) != 0) {
            int flag = mFullDisplayCheckFlag.get() & 0xFFFFFFCF;
            return flag == 1;
        }
        boolean isFullDisplay = false;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager != null) {
            float height;
            float width;
            Display display = windowManager.getDefaultDisplay();
            display.getRealSize(point);
            if (PopupUiUtils.point.x < PopupUiUtils.point.y) {
                width = PopupUiUtils.point.x;
                height = PopupUiUtils.point.y;
            } else {
                width = PopupUiUtils.point.y;
                height = PopupUiUtils.point.x;
            }
            if (height * 1.0f / width * 1.0f >= 1.97f) {
                isFullDisplay = true;
                mFullDisplayCheckFlag.set(49);
            } else {
                mFullDisplayCheckFlag.set(50);
            }
        }
        return isFullDisplay;
    }
}

