/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.PopupKeyboardStateChangeListener;
import razerdp.basepopup.PopupTouchController;
import razerdp.basepopup.PopupWindowActionListener;
import razerdp.basepopup.PopupWindowLocationListener;
import razerdp.blur.PopupBlurOption;
import razerdp.library.R;

final class BasePopupHelper
implements PopupTouchController,
PopupWindowActionListener,
PopupWindowLocationListener,
PopupKeyboardStateChangeListener {
    private boolean autoShowInputMethod = false;
    private static int showCount;
    private Animation mShowAnimation;
    private Animator mShowAnimator;
    private Animation mDismissAnimation;
    private Animator mDismissAnimator;
    private BasePopupWindow.OnDismissListener mOnDismissListener;
    private BasePopupWindow.OnBeforeShowCallback mOnBeforeShowCallback;
    private int popupGravity = 0;
    private int offsetX;
    private int offsetY;
    private int preMeasureWidth;
    private int preMeasureHeight;
    private int popupViewWidth;
    private int popupViewHeight;
    private int[] mAnchorViewLocation;
    private int mAnchorViewHeight;
    private int mAnchorViewWidth;
    private boolean isAutoLocatePopup;
    private boolean isShowAsDropDown;
    private boolean dismissWhenTouchOutside = true;
    private boolean fullScreen = true;
    private volatile boolean isPopupFadeEnable = true;
    private boolean backPressEnable = true;
    private boolean interceptOutSideTouchEvent = true;
    private PopupBlurOption mBlurOption;
    private boolean mAlignBackground = false;
    private Drawable mBackgroundDrawable = new ColorDrawable(Color.parseColor((String)"#8f000000"));
    private PopupTouchController mTouchControllerDelegate;
    private PopupWindowActionListener mActionListener;
    private PopupWindowLocationListener mLocationListener;
    private PopupKeyboardStateChangeListener mKeyboardStateChangeListener;
    private boolean mClipChildren = true;
    private boolean mClipToScreen = true;
    private int mSoftInputMode = 16;
    private ViewGroup.MarginLayoutParams mParaseFromXmlParams;

    BasePopupHelper(PopupTouchController controller) {
        this.mAnchorViewLocation = new int[2];
        this.mTouchControllerDelegate = controller;
    }

    BasePopupHelper registerActionListener(PopupWindowActionListener actionListener) {
        this.mActionListener = actionListener;
        return this;
    }

    BasePopupHelper registerLocationLisener(PopupWindowLocationListener locationListener) {
        this.mLocationListener = locationListener;
        return this;
    }

    BasePopupHelper registerKeyboardStateChangeListener(PopupKeyboardStateChangeListener mKeyboardStateChangeListener) {
        this.mKeyboardStateChangeListener = mKeyboardStateChangeListener;
        return this;
    }

    public View inflate(Context context, int layoutId) {
        try {
            FrameLayout tempLayout = new FrameLayout(context);
            View result = LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)tempLayout, false);
            ViewGroup.LayoutParams childParams = result.getLayoutParams();
            if (childParams != null) {
                this.checkAndSetGravity(childParams);
                if (childParams instanceof ViewGroup.MarginLayoutParams) {
                    this.mParaseFromXmlParams = new ViewGroup.MarginLayoutParams((ViewGroup.MarginLayoutParams)childParams);
                    tempLayout = null;
                    return result;
                }
                this.mParaseFromXmlParams = new ViewGroup.MarginLayoutParams(childParams);
                tempLayout = null;
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void checkAndSetGravity(ViewGroup.LayoutParams p) {
        if (p == null) {
            return;
        }
        if (p instanceof LinearLayout.LayoutParams) {
            this.setPopupGravity(((LinearLayout.LayoutParams)p).gravity);
        } else if (p instanceof FrameLayout.LayoutParams) {
            this.setPopupGravity(((FrameLayout.LayoutParams)p).gravity);
        }
    }

    Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    BasePopupHelper setShowAnimation(Animation showAnimation) {
        if (this.mShowAnimation == showAnimation) {
            return this;
        }
        if (this.mShowAnimation != null) {
            this.mShowAnimation.cancel();
        }
        this.mShowAnimation = showAnimation;
        return this;
    }

    Animator getShowAnimator() {
        return this.mShowAnimator;
    }

    BasePopupHelper setShowAnimator(Animator showAnimator) {
        if (this.mShowAnimator == showAnimator) {
            return this;
        }
        if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
        }
        this.mShowAnimator = showAnimator;
        return this;
    }

    Animation getDismissAnimation() {
        return this.mDismissAnimation;
    }

    BasePopupHelper setDismissAnimation(Animation dismissAnimation) {
        if (this.mDismissAnimation == dismissAnimation) {
            return this;
        }
        if (this.mDismissAnimation != null) {
            this.mDismissAnimation.cancel();
        }
        this.mDismissAnimation = dismissAnimation;
        return this;
    }

    Animator getDismissAnimator() {
        return this.mDismissAnimator;
    }

    BasePopupHelper setDismissAnimator(Animator dismissAnimator) {
        if (this.mDismissAnimator == dismissAnimator) {
            return this;
        }
        if (this.mDismissAnimator != null) {
            this.mDismissAnimator.cancel();
        }
        this.mDismissAnimator = dismissAnimator;
        return this;
    }

    int getPopupViewWidth() {
        return this.popupViewWidth;
    }

    BasePopupHelper setPopupViewWidth(int popupViewWidth) {
        this.popupViewWidth = popupViewWidth;
        return this;
    }

    int getPopupViewHeight() {
        return this.popupViewHeight;
    }

    BasePopupHelper setPopupViewHeight(int popupViewHeight) {
        this.popupViewHeight = popupViewHeight;
        return this;
    }

    int getPreMeasureWidth() {
        return this.preMeasureWidth;
    }

    BasePopupHelper setPreMeasureWidth(int preMeasureWidth) {
        this.preMeasureWidth = preMeasureWidth;
        return this;
    }

    int getPreMeasureHeight() {
        return this.preMeasureHeight;
    }

    BasePopupHelper setPreMeasureHeight(int preMeasureHeight) {
        this.preMeasureHeight = preMeasureHeight;
        return this;
    }

    boolean isPopupFadeEnable() {
        return this.isPopupFadeEnable;
    }

    BasePopupHelper setPopupFadeEnable(PopupWindow popupWindow, boolean needPopupFadeAnima) {
        if (popupWindow == null) {
            return this;
        }
        this.isPopupFadeEnable = needPopupFadeAnima;
        popupWindow.setAnimationStyle(needPopupFadeAnima ? R.style.PopupAnimaFade : 0);
        return this;
    }

    boolean isShowAsDropDown() {
        return this.isShowAsDropDown;
    }

    BasePopupHelper setShowAsDropDown(boolean showAsDropDown) {
        this.isShowAsDropDown = showAsDropDown;
        return this;
    }

    int getPopupGravity() {
        return this.popupGravity;
    }

    BasePopupHelper setPopupGravity(int popupGravity) {
        if (popupGravity == this.popupGravity) {
            return this;
        }
        this.popupGravity = popupGravity;
        return this;
    }

    public BasePopupHelper setClipChildren(boolean clipChildren) {
        this.mClipChildren = clipChildren;
        return this;
    }

    int getOffsetX() {
        return this.offsetX;
    }

    BasePopupHelper setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    int getOffsetY() {
        return this.offsetY;
    }

    BasePopupHelper setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    boolean isAutoShowInputMethod() {
        return this.autoShowInputMethod;
    }

    BasePopupHelper setAutoShowInputMethod(PopupWindow popupWindow, boolean autoShowInputMethod) {
        if (popupWindow == null) {
            return this;
        }
        this.autoShowInputMethod = autoShowInputMethod;
        popupWindow.setSoftInputMode(autoShowInputMethod ? 16 : 1);
        return this;
    }

    public BasePopupHelper setSoftInputMode(int inputMethodType) {
        this.mSoftInputMode = inputMethodType;
        return this;
    }

    boolean isAutoLocatePopup() {
        return this.isAutoLocatePopup;
    }

    BasePopupHelper setAutoLocatePopup(boolean autoLocatePopup) {
        this.isAutoLocatePopup = autoLocatePopup;
        if (autoLocatePopup) {
            this.isShowAsDropDown = true;
        }
        return this;
    }

    BasePopupWindow.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    BasePopupHelper setOnDismissListener(BasePopupWindow.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    BasePopupWindow.OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mOnBeforeShowCallback;
    }

    BasePopupHelper setOnBeforeShowCallback(BasePopupWindow.OnBeforeShowCallback onBeforeShowCallback) {
        this.mOnBeforeShowCallback = onBeforeShowCallback;
        return this;
    }

    boolean isDismissWhenTouchOutside() {
        return this.dismissWhenTouchOutside;
    }

    BasePopupHelper setDismissWhenTouchOutside(PopupWindow popupWindow, boolean dismissWhenTouchOutside) {
        if (popupWindow == null) {
            return this;
        }
        this.dismissWhenTouchOutside = dismissWhenTouchOutside;
        return this;
    }

    boolean isInterceptTouchEvent() {
        return this.interceptOutSideTouchEvent;
    }

    BasePopupHelper setInterceptTouchEvent(PopupWindow popupWindow, boolean intecept) {
        if (popupWindow == null) {
            return this;
        }
        this.interceptOutSideTouchEvent = intecept;
        return this;
    }

    public BasePopupHelper setClipToScreen(boolean clipToScreen) {
        this.mClipToScreen = clipToScreen;
        return this;
    }

    BasePopupHelper getAnchorLocation(View v) {
        if (v == null) {
            return this;
        }
        v.getLocationOnScreen(this.mAnchorViewLocation);
        this.mAnchorViewWidth = v.getWidth();
        this.mAnchorViewHeight = v.getHeight();
        return this;
    }

    int getAnchorViewWidth() {
        return this.mAnchorViewWidth;
    }

    int getAnchorHeight() {
        return this.mAnchorViewHeight;
    }

    int getAnchorX() {
        return this.mAnchorViewLocation[0];
    }

    int getAnchorY() {
        return this.mAnchorViewLocation[1];
    }

    public boolean isBackPressEnable() {
        return this.backPressEnable;
    }

    public boolean isClipToScreen() {
        return this.mClipToScreen;
    }

    BasePopupHelper setBackPressEnable(PopupWindow popupWindow, boolean backPressEnable) {
        if (popupWindow == null) {
            return this;
        }
        this.backPressEnable = backPressEnable;
        return this;
    }

    boolean isFullScreen() {
        return this.fullScreen;
    }

    BasePopupHelper setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
        return this;
    }

    PopupBlurOption getBlurOption() {
        return this.mBlurOption;
    }

    BasePopupHelper applyBlur(PopupBlurOption option) {
        this.mBlurOption = option;
        return this;
    }

    long getShowAnimationDuration() {
        long duration = 0L;
        if (this.mShowAnimation != null) {
            duration = this.mShowAnimation.getDuration();
        } else if (this.mShowAnimator != null) {
            duration = this.mShowAnimator.getDuration();
        }
        return duration < 0L ? 500L : duration;
    }

    long getExitAnimationDuration() {
        long duration = 0L;
        if (this.mDismissAnimation != null) {
            duration = this.mDismissAnimation.getDuration();
        } else if (this.mDismissAnimator != null) {
            duration = this.mDismissAnimator.getDuration();
        }
        return duration < 0L ? 500L : duration;
    }

    public Drawable getPopupBackground() {
        return this.mBackgroundDrawable;
    }

    public BasePopupHelper setPopupBackground(Drawable background) {
        this.mBackgroundDrawable = background;
        return this;
    }

    public boolean isAlignBackground() {
        return this.mAlignBackground;
    }

    public BasePopupHelper setAlignBackgound(boolean mAlignBackground) {
        this.mAlignBackground = mAlignBackground;
        return this;
    }

    public boolean isAllowToBlur() {
        return this.mBlurOption != null && this.mBlurOption.isAllowToBlur();
    }

    public boolean isClipChildren() {
        return this.mClipChildren;
    }

    public ViewGroup.MarginLayoutParams getParaseFromXmlParams() {
        return this.mParaseFromXmlParams;
    }

    public int getShowCount() {
        return showCount;
    }

    public void handleShow() {
        if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
            ++showCount;
        }
    }

    public void handleDismiss() {
        if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
            --showCount;
            showCount = Math.max(0, showCount);
        }
    }

    @Override
    public boolean onBeforeDismiss() {
        return this.mTouchControllerDelegate.onBeforeDismiss();
    }

    @Override
    public boolean callDismissAtOnce() {
        return this.mTouchControllerDelegate.callDismissAtOnce();
    }

    @Override
    public boolean onDispatchKeyEvent(KeyEvent event) {
        return this.mTouchControllerDelegate.onDispatchKeyEvent(event);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.mTouchControllerDelegate.onInterceptTouchEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return this.mTouchControllerDelegate.onTouchEvent(event);
    }

    @Override
    public boolean onBackPressed() {
        return this.mTouchControllerDelegate.onBackPressed();
    }

    @Override
    public boolean onOutSideTouch() {
        return this.mTouchControllerDelegate.onOutSideTouch();
    }

    @Override
    public void onShow(boolean hasAnimate) {
        if (this.mActionListener != null) {
            this.mActionListener.onShow(hasAnimate);
        }
    }

    @Override
    public void onDismiss(boolean hasAnimate) {
        if (this.mActionListener != null) {
            this.mActionListener.onDismiss(hasAnimate);
        }
    }

    @Override
    public void onAnchorTop() {
        if (this.mLocationListener != null) {
            this.mLocationListener.onAnchorTop();
        }
    }

    @Override
    public void onAnchorBottom() {
        if (this.mLocationListener != null) {
            this.mLocationListener.onAnchorBottom();
        }
    }

    public int getSoftInputMode() {
        return this.mSoftInputMode;
    }

    @Override
    public void onKeyboardChange(int keyboardHeight, boolean isVisible) {
        if (this.mKeyboardStateChangeListener != null) {
            this.mKeyboardStateChangeListener.onKeyboardChange(keyboardHeight, isVisible);
        }
    }
}

