/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util.log;

import android.text.TextUtils;
import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import razerdp.util.log.LogTag;

public class LogUtil {
    private static final boolean[] mIsDebugMode = new boolean[]{false};
    private static final String TAG = "basepopup";
    private static final String SUFFIX = ".java";
    private static final int sStartStackTraceOffset = 3;
    private static final String CLASS_LogTag_LINE_FORMAT = "%s.%s()_%s";
    private static final String sPACKAGENAME = "razerdp";
    private static final boolean isExactMode = false;
    private static final int MAX_LOG_MSG_LENGTH = 4000;

    public static void trace(String msg) {
        LogUtil.trace(LogTag.i, msg);
    }

    public static void trace(Throwable throwable) {
        LogUtil.trace(LogTag.i, throwable);
    }

    public static void trace(LogTag LogTag2, String msg) {
        LogUtil.trace(LogTag2, TAG, msg);
    }

    public static void trace(LogTag LogTag2, Throwable throwable) {
        LogUtil.trace(LogTag2, TAG, throwable);
    }

    public static void trace(LogTag LogTag2, String tag, String msg) {
        LogUtil.trace(LogTag2, tag, msg, null);
    }

    public static void trace(LogTag LogTag2, String tag, Throwable throwable) {
        LogUtil.trace(LogTag2, tag, null, throwable);
    }

    public static void trace(LogTag LogTag2, String tag, String msg, Throwable throwable) {
        if (!LogUtil.checkOpenLog()) {
            return;
        }
        LogUtil.traceInternal(LogTag2, tag, LogUtil.getLogMsg(msg, throwable));
    }

    private static void traceInternal(LogTag LogTag2, String tag, String content) {
        try {
            long length = content.length();
            if (length <= 4000L) {
                LogUtil.logByLogTag(LogTag2, tag, content);
            } else {
                while (content.length() > 4000) {
                    String logContent = content.substring(0, 4000);
                    content = content.replace(logContent, "");
                    LogUtil.logByLogTag(LogTag2, tag, logContent);
                }
                LogUtil.logByLogTag(LogTag2, tag, content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void logByLogTag(LogTag LogTag2, String tag, String outPutMsg) {
        switch (LogTag2) {
            case i: {
                Log.i((String)tag, (String)outPutMsg);
                break;
            }
            case d: {
                Log.d((String)tag, (String)outPutMsg);
                break;
            }
            case w: {
                Log.w((String)tag, (String)outPutMsg);
                break;
            }
            case e: {
                Log.e((String)tag, (String)outPutMsg);
                break;
            }
            case v: {
                Log.v((String)tag, (String)outPutMsg);
                break;
            }
            default: {
                Log.i((String)tag, (String)outPutMsg);
            }
        }
    }

    private static String getLogMsg(String msg, Throwable throwable) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            return LogUtil.wrapLogWithLogTagLocation(msg);
        }
        if (throwable != null) {
            return LogUtil.wrapLogWithLogTagLocation(LogUtil.getCrashInfo(throwable));
        }
        return "\u6ca1\u6709\u65e5\u5fd7\u54e6";
    }

    private static boolean checkOpenLog() {
        return mIsDebugMode[0];
    }

    public static void setOpenLog(boolean openLog) {
        LogUtil.mIsDebugMode[0] = openLog;
    }

    public static boolean isOpenLog() {
        return mIsDebugMode[0];
    }

    private static String wrapLogWithLogTagLocation(String msg) {
        StackTraceElement element = LogUtil.getCurrentStackTrace();
        String className = "unknow";
        String methodName = "unknow";
        int lineNumber = -1;
        if (element != null) {
            className = element.getFileName();
            methodName = element.getMethodName();
            lineNumber = element.getLineNumber();
        }
        StringBuilder sb = new StringBuilder();
        msg = LogUtil.wrapJson(msg);
        sb.append("  (").append(className).append(":").append(lineNumber).append(") #").append(methodName).append("\uff1a ").append(msg);
        return sb.toString();
    }

    public static String wrapJson(String jsonStr) {
        String message;
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return "json\u4e3a\u7a7a";
        }
        try {
            if (jsonStr.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(jsonStr);
                message = jsonObject.toString(2);
                message = "\n================JSON================\n" + message + '\n' + "================JSON================\n";
            } else if (jsonStr.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(jsonStr);
                message = jsonArray.toString(4);
                message = "\n================JSONARRAY================\n" + message + '\n' + "================JSONARRAY================\n";
            } else {
                message = jsonStr;
            }
        }
        catch (JSONException e) {
            message = jsonStr;
        }
        return message;
    }

    public static String getCrashInfo(Throwable tr) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        tr.printStackTrace(printWriter);
        for (Throwable cause = tr.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        String crashInfo = ((Object)writer).toString();
        printWriter.close();
        return crashInfo;
    }

    private static StackTraceElement getCurrentStackTrace() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int stackOffset = LogUtil.getStackOffset(trace, LogUtil.class);
        if (stackOffset == -1 && (stackOffset = LogUtil.getStackOffset(trace, Logger.class)) == -1 && (stackOffset = LogUtil.getStackOffset(trace, Log.class)) == -1) {
            return null;
        }
        StackTraceElement caller = trace[stackOffset];
        return caller;
    }

    private static int getStackOffset(StackTraceElement[] trace, Class cla) {
        for (int i = 3; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            String name = e.getClassName();
            if (cla.equals(LogUtil.class) && i < trace.length - 1 && trace[i + 1].getClassName().equals(LogUtil.class.getName()) || !name.equals(cla.getName())) continue;
            return ++i;
        }
        return -1;
    }
}

