/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.HackPopupDecorView;
import razerdp.basepopup.PopupController;
import razerdp.blur.BlurImageView;
import razerdp.util.log.LogTag;
import razerdp.util.log.LogUtil;

final class HackWindowManager
implements WindowManager {
    private static final String TAG = "HackWindowManager";
    private WeakReference<WindowManager> mWindowManager;
    private WeakReference<PopupController> mPopupController;
    private WeakReference<HackPopupDecorView> mHackPopupDecorView;
    private WeakReference<BasePopupHelper> mPopupHelper;
    private WeakReference<BlurImageView> mBlurImageView;

    public HackWindowManager(WindowManager windowManager, PopupController popupController) {
        this.mWindowManager = new WeakReference<WindowManager>(windowManager);
        this.mPopupController = new WeakReference<PopupController>(popupController);
    }

    public Display getDefaultDisplay() {
        return this.getWindowManager() == null ? null : this.getWindowManager().getDefaultDisplay();
    }

    public void removeViewImmediate(View view) {
        if (this.getWindowManager() == null) {
            return;
        }
        LogUtil.trace(LogTag.i, TAG, "WindowManager.removeViewImmediate  >>>  " + view.getClass().getSimpleName());
        if (this.checkProxyValided(view) && this.getHackPopupDecorView() != null) {
            if (this.getBlurImageView() != null) {
                try {
                    this.getWindowManager().removeViewImmediate((View)this.getBlurImageView());
                    this.mBlurImageView.clear();
                    this.mBlurImageView = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.getWindowManager().removeViewImmediate((View)hackPopupDecorView);
            hackPopupDecorView.setPopupController(null);
            this.mHackPopupDecorView.clear();
            this.mHackPopupDecorView = null;
        } else {
            this.getWindowManager().removeViewImmediate(view);
        }
    }

    public void addView(View view, ViewGroup.LayoutParams params) {
        if (this.getWindowManager() == null) {
            return;
        }
        LogUtil.trace(LogTag.i, TAG, "WindowManager.addView  >>>  " + view.getClass().getSimpleName());
        if (this.checkProxyValided(view)) {
            BasePopupHelper helper = this.getBasePopupHelper();
            BlurImageView blurImageView = null;
            if (helper != null && helper.isAllowToBlur()) {
                blurImageView = new BlurImageView(view.getContext());
                blurImageView.attachBlurOption(helper.getBlurOption());
                this.mBlurImageView = new WeakReference<BlurImageView>(blurImageView);
                this.getWindowManager().addView((View)blurImageView, this.generateBlurBackgroundWindowParams(params));
            }
            params = this.applyHelper(params);
            HackPopupDecorView hackPopupDecorView = new HackPopupDecorView(view.getContext());
            this.mHackPopupDecorView = new WeakReference<HackPopupDecorView>(hackPopupDecorView);
            hackPopupDecorView.setPopupController(this.getPopupController());
            hackPopupDecorView.addBlurImageview(blurImageView);
            hackPopupDecorView.addView(view, params);
            this.getWindowManager().addView((View)hackPopupDecorView, params);
        } else {
            this.getWindowManager().addView(view, params);
        }
    }

    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        if (this.getWindowManager() == null) {
            return;
        }
        LogUtil.trace(LogTag.i, TAG, "WindowManager.updateViewLayout  >>>  " + view.getClass().getSimpleName());
        if (this.checkProxyValided(view) && this.getHackPopupDecorView() != null) {
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.getWindowManager().updateViewLayout((View)hackPopupDecorView, params);
        } else {
            this.getWindowManager().updateViewLayout(view, params);
        }
    }

    public void removeView(View view) {
        if (this.getWindowManager() == null) {
            return;
        }
        LogUtil.trace(LogTag.i, TAG, "WindowManager.removeView  >>>  " + view.getClass().getSimpleName());
        if (this.checkProxyValided(view) && this.getHackPopupDecorView() != null) {
            if (this.getBlurImageView() != null) {
                try {
                    this.getWindowManager().removeView((View)this.getBlurImageView());
                    this.mBlurImageView.clear();
                    this.mBlurImageView = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.getWindowManager().removeView((View)hackPopupDecorView);
            hackPopupDecorView.setPopupController(null);
            this.mHackPopupDecorView.clear();
            this.mHackPopupDecorView = null;
        } else {
            this.getWindowManager().removeView(view);
        }
    }

    private ViewGroup.LayoutParams generateBlurBackgroundWindowParams(ViewGroup.LayoutParams params) {
        ViewGroup.LayoutParams result = new ViewGroup.LayoutParams(params);
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams mResults = new WindowManager.LayoutParams();
            mResults.copyFrom((WindowManager.LayoutParams)params);
            mResults.flags |= 8;
            mResults.flags |= 0x10;
            mResults.flags |= 0x100;
            mResults.x = 0;
            mResults.y = 0;
            mResults.format = 1;
            result = mResults;
        }
        result.width = -1;
        result.height = -1;
        return result;
    }

    private ViewGroup.LayoutParams applyHelper(ViewGroup.LayoutParams params) {
        if (!(params instanceof WindowManager.LayoutParams) || this.getBasePopupHelper() == null) {
            return params;
        }
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
        BasePopupHelper helper = this.getBasePopupHelper();
        if (helper == null) {
            return params;
        }
        if (!helper.isInterceptTouchEvent()) {
            LogUtil.trace(LogTag.i, TAG, "applyHelper  >>>  \u4e0d\u62e6\u622a\u4e8b\u4ef6");
            p.flags |= 0x20;
            p.flags |= 0x40000;
        }
        if (helper.isFullScreen()) {
            LogUtil.trace(LogTag.i, TAG, "applyHelper  >>>  \u5168\u5c4f");
            p.flags |= 0x100;
            p.softInputMode = 1;
        }
        LogUtil.trace(LogTag.i, TAG, "PopupWindow\u7a97\u53e3\u7684window type >>  " + p.type);
        return p;
    }

    private boolean checkProxyValided(View v) {
        if (v == null) {
            return false;
        }
        String viewSimpleClassName = v.getClass().getSimpleName();
        return TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupDecorView") || TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupViewContainer");
    }

    private HackPopupDecorView getHackPopupDecorView() {
        if (this.mHackPopupDecorView == null) {
            return null;
        }
        return (HackPopupDecorView)((Object)this.mHackPopupDecorView.get());
    }

    private WindowManager getWindowManager() {
        if (this.mWindowManager == null) {
            return null;
        }
        return (WindowManager)this.mWindowManager.get();
    }

    private PopupController getPopupController() {
        if (this.mPopupController == null) {
            return null;
        }
        return (PopupController)this.mPopupController.get();
    }

    private BasePopupHelper getBasePopupHelper() {
        if (this.mPopupHelper == null) {
            return null;
        }
        return (BasePopupHelper)this.mPopupHelper.get();
    }

    private BlurImageView getBlurImageView() {
        if (this.mBlurImageView == null) {
            return null;
        }
        return (BlurImageView)((Object)this.mBlurImageView.get());
    }

    void bindPopupHelper(BasePopupHelper helper) {
        this.mPopupHelper = new WeakReference<BasePopupHelper>(helper);
    }
}

