/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.PopupWindow;
import razerdp.basepopup.PopupController;

public abstract class BasePopupWindowProxy
extends PopupWindow {
    private static final String TAG = "BasePopupWindowProxy";
    private static final int MAX_SCAN_ACTIVITY_COUNT = 50;
    private volatile int tryScanActivityCount = 0;
    private PopupController mController;

    public BasePopupWindowProxy(Context context, PopupController mController) {
        super(context);
        this.mController = mController;
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, PopupController mController) {
        super(context, attrs);
        this.mController = mController;
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, int defStyleAttr, PopupController mController) {
        super(context, attrs, defStyleAttr);
        this.mController = mController;
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, PopupController mController) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mController = mController;
    }

    public BasePopupWindowProxy(View contentView, PopupController mController) {
        super(contentView);
        this.mController = mController;
    }

    public BasePopupWindowProxy(int width, int height, PopupController mController) {
        super(width, height);
        this.mController = mController;
    }

    public BasePopupWindowProxy(View contentView, int width, int height, PopupController mController) {
        super(contentView, width, height);
        this.mController = mController;
    }

    public BasePopupWindowProxy(View contentView, int width, int height, boolean focusable, PopupController mController) {
        super(contentView, width, height, focusable);
        this.mController = mController;
    }

    void callSuperShowAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        Activity activity = this.scanForActivity(anchor.getContext());
        if (activity == null) {
            Log.e((String)TAG, (String)"please make sure that context is instance of activity");
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            super.showAsDropDown(anchor, xoff, yoff, gravity);
        } else {
            super.showAsDropDown(anchor, xoff, yoff);
        }
    }

    void callSuperShowAtLocation(View parent, int gravity, int x, int y) {
        super.showAtLocation(parent, gravity, x, y);
    }

    boolean callSuperIsShowing() {
        return super.isShowing();
    }

    void resetTryScanActivityCount() {
        this.tryScanActivityCount = 0;
    }

    Activity scanForActivity(Context cont) {
        if (cont == null) {
            return null;
        }
        if (cont instanceof Activity) {
            return (Activity)cont;
        }
        if (cont instanceof ContextWrapper) {
            if (this.tryScanActivityCount > 50) {
                return null;
            }
            ++this.tryScanActivityCount;
            return this.scanForActivity(((ContextWrapper)cont).getBaseContext());
        }
        return null;
    }

    public void dismiss() {
        if (this.mController == null) {
            return;
        }
        boolean performDismiss = this.mController.onBeforeDismiss();
        if (!performDismiss) {
            return;
        }
        boolean dismissAtOnce = this.mController.callDismissAtOnce();
        if (dismissAtOnce) {
            this.callSuperDismiss();
        }
    }

    void callSuperDismiss() {
        super.dismiss();
    }
}

