/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import razerdp.basepopup.BasePopup;
import razerdp.basepopup.PopupController;
import razerdp.basepopup.PopupWindowProxy;
import razerdp.library.R;
import razerdp.util.InputMethodUtils;
import razerdp.util.SimpleAnimUtil;

public abstract class BasePopupWindow
implements BasePopup,
PopupWindow.OnDismissListener,
PopupController {
    private static final String TAG = "BasePopupWindow";
    private static final int MAX_RETRY_SHOW_TIME = 3;
    private PopupWindowProxy mPopupWindow;
    private View mPopupView;
    private WeakReference<Context> mContext;
    protected View mAnimaView;
    protected View mDismissView;
    private boolean autoShowInputMethod = false;
    private OnDismissListener mOnDismissListener;
    private OnBeforeShowCallback mOnBeforeShowCallback;
    private Animation mShowAnimation;
    private Animator mShowAnimator;
    private Animation mExitAnimation;
    private Animator mExitAnimator;
    private boolean isExitAnimaPlaying = false;
    private boolean needPopupFadeAnima = true;
    private int popupGravity = 0;
    private int offsetX;
    private int offsetY;
    private int popupViewWidth;
    private int popupViewHeight;
    private int[] mAnchorViewLocation;
    private boolean isAutoLocatePopup;
    private boolean showAtDown;
    private boolean dismissWhenTouchOuside;
    private int mPopupLayoutId;
    private volatile int retryCounter;
    private Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
            BasePopupWindow.this.isExitAnimaPlaying = true;
        }

        public void onAnimationEnd(Animator animation) {
            BasePopupWindow.this.mPopupWindow.callSuperDismiss();
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationCancel(Animator animation) {
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };
    private Animation.AnimationListener mAnimationListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            BasePopupWindow.this.isExitAnimaPlaying = true;
        }

        public void onAnimationEnd(Animation animation) {
            BasePopupWindow.this.mPopupWindow.callSuperDismiss();
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };

    public BasePopupWindow(Context context) {
        this.initView(context, -1, -1);
    }

    public BasePopupWindow(Context context, int w, int h) {
        this.initView(context, w, h);
    }

    private void initView(Context context, int w, int h) {
        this.mContext = new WeakReference<Context>(context);
        this.mPopupView = this.onCreatePopupView();
        this.mAnimaView = this.initAnimaView();
        if (this.mAnimaView != null) {
            this.mPopupLayoutId = this.mAnimaView.getId();
        }
        this.checkPopupAnimaView();
        this.mPopupWindow = new PopupWindowProxy(this.mPopupView, w, h, (PopupController)this);
        this.mPopupWindow.setOnDismissListener(this);
        this.setDismissWhenTouchOutside(true);
        this.preMeasurePopupView(w, h);
        this.setNeedPopupFade(Build.VERSION.SDK_INT <= 22);
        this.mDismissView = this.getClickToDismissView();
        if (this.mDismissView != null && !(this.mDismissView instanceof AdapterView)) {
            this.mDismissView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BasePopupWindow.this.dismiss();
                }
            });
        }
        if (this.mAnimaView != null && !(this.mAnimaView instanceof AdapterView)) {
            this.mAnimaView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
        }
        this.mShowAnimation = this.initShowAnimation();
        this.mShowAnimator = this.initShowAnimator();
        this.mExitAnimation = this.initExitAnimation();
        this.mExitAnimator = this.initExitAnimator();
        this.mAnchorViewLocation = new int[2];
    }

    private void checkPopupAnimaView() {
        if (this.mPopupView != null && this.mAnimaView != null && this.mPopupView == this.mAnimaView) {
            try {
                this.mPopupView = new FrameLayout(this.getContext());
                if (this.mPopupLayoutId == 0) {
                    ((FrameLayout)this.mPopupView).addView(this.mAnimaView);
                } else {
                    this.mAnimaView = View.inflate((Context)this.getContext(), (int)this.mPopupLayoutId, (ViewGroup)((FrameLayout)this.mPopupView));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void preMeasurePopupView(int w, int h) {
        if (this.mPopupView != null) {
            if (Build.VERSION.SDK_INT <= 18) {
                int contentViewHeight = -1;
                ViewGroup.LayoutParams layoutParams = this.mPopupView.getLayoutParams();
                if (layoutParams != null && layoutParams.height == -2) {
                    contentViewHeight = -2;
                }
                ViewGroup.LayoutParams p = new ViewGroup.LayoutParams(-1, contentViewHeight);
                this.mPopupView.setLayoutParams(p);
            }
            this.mPopupView.measure(w, h);
            this.popupViewWidth = this.mPopupView.getMeasuredWidth();
            this.popupViewHeight = this.mPopupView.getMeasuredHeight();
            this.mPopupView.setFocusableInTouchMode(true);
        }
    }

    protected abstract Animation initShowAnimation();

    public abstract View getClickToDismissView();

    protected Animator initShowAnimator() {
        return null;
    }

    public EditText getInputView() {
        return null;
    }

    protected Animation initExitAnimation() {
        return null;
    }

    protected Animator initExitAnimator() {
        return null;
    }

    public BasePopupWindow setNeedPopupFade(boolean needPopupFadeAnima) {
        this.needPopupFadeAnima = needPopupFadeAnima;
        this.setPopupAnimaStyle(needPopupFadeAnima ? R.style.PopupAnimaFade : 0);
        return this;
    }

    public boolean isNeedPopupFade() {
        return this.needPopupFadeAnima;
    }

    public BasePopupWindow setPopupAnimaStyle(int animaStyleRes) {
        this.mPopupWindow.setAnimationStyle(animaStyleRes);
        this.mPopupWindow.update();
        return this;
    }

    public void showPopupWindow() {
        if (this.checkPerformShow(null)) {
            this.showAtDown = false;
            this.tryToShowPopup(null);
        }
    }

    public void showPopupWindow(int anchorViewResid) {
        Context context = this.getContext();
        assert (context != null) : "context is null";
        if (context instanceof Activity) {
            View v = ((Activity)context).findViewById(anchorViewResid);
            this.showPopupWindow(v);
        } else {
            Log.e((String)TAG, (String)"can not get token from context,make sure that context is instance of activity");
        }
    }

    public void showPopupWindow(View v) {
        if (this.checkPerformShow(v)) {
            this.showAtDown = true;
            this.tryToShowPopup(v);
        }
    }

    private void tryToShowPopup(View v) {
        try {
            if (v != null) {
                int[] offset = this.calculateOffset(v);
                if (this.showAtDown) {
                    this.mPopupWindow.showAsDropDown(v, offset[0], offset[1]);
                } else {
                    this.mPopupWindow.showAtLocation(v, this.popupGravity, offset[0], offset[1]);
                }
            } else {
                Context context = this.getContext();
                assert (context != null) : "context is null ! please make sure your activity is not be destroyed";
                if (context instanceof Activity) {
                    this.mPopupWindow.showAtLocation(((Activity)context).findViewById(0x1020002), this.popupGravity, this.offsetX, this.offsetY);
                } else {
                    Log.e((String)TAG, (String)"can not get token from context,make sure that context is instance of activity");
                }
            }
            if (this.mShowAnimation != null && this.mAnimaView != null) {
                this.mAnimaView.clearAnimation();
                this.mAnimaView.startAnimation(this.mShowAnimation);
            }
            if (this.mShowAnimation == null && this.mShowAnimator != null && this.mAnimaView != null) {
                this.mShowAnimator.start();
            }
            if (this.autoShowInputMethod && this.getInputView() != null) {
                this.getInputView().requestFocus();
                InputMethodUtils.showInputMethod((View)this.getInputView(), 150L);
            }
            this.retryCounter = 0;
        }
        catch (Exception e) {
            if (e instanceof WindowManager.BadTokenException) {
                this.retryToShowPopup(v);
                Log.e((String)TAG, (String)"have no window token,retry to show");
                e.printStackTrace();
            }
            Log.e((String)TAG, (String)("show error\n" + e.getMessage()));
            e.printStackTrace();
        }
    }

    private void retryToShowPopup(final View v) {
        Context context;
        if (this.retryCounter > 3) {
            return;
        }
        if (this.isShowing()) {
            this.dismissWithOutAnima();
        }
        if ((context = this.getContext()) instanceof Activity) {
            boolean availabled;
            Activity act = (Activity)context;
            if (Build.VERSION.SDK_INT >= 17) {
                availabled = !act.isFinishing() && !act.isDestroyed();
            } else {
                boolean bl = availabled = !act.isFinishing();
            }
            if (availabled) {
                View rootView = act.findViewById(0x1020002);
                if (rootView == null) {
                    return;
                }
                rootView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BasePopupWindow.this.retryCounter++;
                        BasePopupWindow.this.tryToShowPopup(v);
                    }
                }, 350L);
            }
        }
    }

    private int[] calculateOffset(View anchorView) {
        int[] offset = new int[]{this.offsetX, this.offsetY};
        anchorView.getLocationOnScreen(this.mAnchorViewLocation);
        if (this.isAutoLocatePopup) {
            boolean onTop;
            boolean bl = onTop = this.getScreenHeight() - (this.mAnchorViewLocation[1] + offset[1]) < this.getHeight();
            if (onTop) {
                offset[1] = -anchorView.getHeight() - this.getHeight() - offset[1];
                this.showOnTop(this.mPopupView);
            } else {
                this.showOnDown(this.mPopupView);
            }
        }
        return offset;
    }

    public BasePopupWindow setAdjustInputMethod(boolean needAdjust) {
        this.setAdjustInputMethod(needAdjust, 16);
        return this;
    }

    public BasePopupWindow setAdjustInputMethod(boolean needAdjust, int flag) {
        if (needAdjust) {
            this.mPopupWindow.setSoftInputMode(flag);
        } else {
            this.mPopupWindow.setSoftInputMode(48);
        }
        return this;
    }

    public BasePopupWindow setAutoShowInputMethod(boolean autoShow) {
        this.autoShowInputMethod = autoShow;
        if (autoShow) {
            this.setAdjustInputMethod(true);
        } else {
            this.setAdjustInputMethod(false);
        }
        return this;
    }

    public BasePopupWindow setBackPressEnable(boolean backPressEnable) {
        this.mPopupWindow.setBackgroundDrawable((Drawable)(backPressEnable ? new ColorDrawable() : null));
        return this;
    }

    public View createPopupById(int resId) {
        if (resId != 0) {
            this.mPopupLayoutId = resId;
            return LayoutInflater.from((Context)this.getContext()).inflate(resId, null);
        }
        return null;
    }

    protected View findViewById(int id2) {
        if (this.mPopupView != null && id2 != 0) {
            return this.mPopupView.findViewById(id2);
        }
        return null;
    }

    public BasePopupWindow setPopupWindowFullScreen(boolean needFullScreen) {
        this.fitPopupWindowOverStatusBar(needFullScreen);
        return this;
    }

    protected void setViewClickListener(View.OnClickListener listener, View ... views) {
        for (View view : views) {
            if (view == null || listener == null) continue;
            view.setOnClickListener(listener);
        }
    }

    private void fitPopupWindowOverStatusBar(boolean needFullScreen) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Field mLayoutInScreen = PopupWindow.class.getDeclaredField("mLayoutInScreen");
                mLayoutInScreen.setAccessible(true);
                mLayoutInScreen.set((Object)this.mPopupWindow, needFullScreen);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isShowing() {
        return this.mPopupWindow.isShowing();
    }

    public OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public BasePopupWindow setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    public OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mOnBeforeShowCallback;
    }

    public BasePopupWindow setOnBeforeShowCallback(OnBeforeShowCallback mOnBeforeShowCallback) {
        this.mOnBeforeShowCallback = mOnBeforeShowCallback;
        return this;
    }

    public BasePopupWindow setShowAnimation(Animation showAnimation) {
        if (this.mShowAnimation != null && this.mAnimaView != null) {
            this.mAnimaView.clearAnimation();
            this.mShowAnimation.cancel();
        }
        if (showAnimation != this.mShowAnimation) {
            this.mShowAnimation = showAnimation;
        }
        return this;
    }

    public Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    public BasePopupWindow setShowAnimator(Animator showAnimator) {
        if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
        }
        if (showAnimator != this.mShowAnimator) {
            this.mShowAnimator = showAnimator;
        }
        return this;
    }

    public Animator getShowAnimator() {
        return this.mShowAnimator;
    }

    public BasePopupWindow setExitAnimation(Animation exitAnimation) {
        if (this.mExitAnimation != null && this.mAnimaView != null) {
            this.mAnimaView.clearAnimation();
            this.mExitAnimation.cancel();
        }
        if (exitAnimation != this.mExitAnimation) {
            this.mExitAnimation = exitAnimation;
        }
        return this;
    }

    public Animation getExitAnimation() {
        return this.mExitAnimation;
    }

    public BasePopupWindow setExitAnimator(Animator exitAnimator) {
        if (this.mExitAnimator != null) {
            this.mExitAnimator.cancel();
        }
        if (exitAnimator != this.mExitAnimator) {
            this.mExitAnimator = exitAnimator;
        }
        return this;
    }

    public Animator getExitAnimator() {
        return this.mExitAnimator;
    }

    public Context getContext() {
        return this.mContext == null ? null : (Context)this.mContext.get();
    }

    public View getPopupWindowView() {
        return this.mPopupView;
    }

    public PopupWindow getPopupWindow() {
        return this.mPopupWindow;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public BasePopupWindow setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public BasePopupWindow setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    public int getPopupGravity() {
        return this.popupGravity;
    }

    public BasePopupWindow setPopupGravity(int popupGravity) {
        this.popupGravity = popupGravity;
        return this;
    }

    public boolean isAutoLocatePopup() {
        return this.isAutoLocatePopup;
    }

    public BasePopupWindow setAutoLocatePopup(boolean autoLocatePopup) {
        this.showAtDown = true;
        this.isAutoLocatePopup = autoLocatePopup;
        return this;
    }

    public int getHeight() {
        int height = this.mPopupWindow.getHeight();
        return height <= 0 ? this.popupViewHeight : height;
    }

    public int getWidth() {
        int width = this.mPopupWindow.getWidth();
        return width <= 0 ? this.popupViewWidth : width;
    }

    public boolean isShowAtDown() {
        return this.showAtDown;
    }

    public BasePopupWindow setShowAtDown(boolean showAtDown) {
        this.showAtDown = showAtDown;
        return this;
    }

    public BasePopupWindow setDismissWhenTouchOutside(boolean dismissWhenTouchOutside) {
        this.dismissWhenTouchOuside = dismissWhenTouchOutside;
        if (dismissWhenTouchOutside) {
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setOutsideTouchable(true);
            this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        } else {
            this.mPopupWindow.setFocusable(false);
            this.mPopupWindow.setOutsideTouchable(false);
            this.mPopupWindow.setBackgroundDrawable(null);
        }
        return this;
    }

    public boolean isDismissWhenTouchOuside() {
        return this.dismissWhenTouchOuside;
    }

    public void dismiss() {
        try {
            this.mPopupWindow.dismiss();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"dismiss error");
            e.printStackTrace();
        }
    }

    @Override
    public boolean onBeforeDismiss() {
        return this.checkPerformDismiss();
    }

    @Override
    public boolean callDismissAtOnce() {
        boolean hasAnima = false;
        if (this.mExitAnimation != null && this.mAnimaView != null) {
            if (!this.isExitAnimaPlaying) {
                this.mExitAnimation.setAnimationListener(this.mAnimationListener);
                this.mAnimaView.clearAnimation();
                this.mAnimaView.startAnimation(this.mExitAnimation);
                this.isExitAnimaPlaying = true;
                hasAnima = true;
            }
        } else if (this.mExitAnimator != null && !this.isExitAnimaPlaying) {
            this.mExitAnimator.removeListener(this.mAnimatorListener);
            this.mExitAnimator.addListener(this.mAnimatorListener);
            this.mExitAnimator.start();
            this.isExitAnimaPlaying = true;
            hasAnima = true;
        }
        return !hasAnima;
    }

    public void dismissWithOutAnima() {
        if (!this.checkPerformDismiss()) {
            return;
        }
        try {
            if (this.mExitAnimation != null && this.mAnimaView != null) {
                this.mAnimaView.clearAnimation();
            }
            if (this.mExitAnimator != null) {
                this.mExitAnimator.removeAllListeners();
            }
            this.mPopupWindow.callSuperDismiss();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"dismiss error");
            e.printStackTrace();
        }
    }

    private boolean checkPerformDismiss() {
        boolean callDismiss = true;
        if (this.mOnDismissListener != null) {
            callDismiss = this.mOnDismissListener.onBeforeDismiss();
        }
        return callDismiss && !this.isExitAnimaPlaying;
    }

    private boolean checkPerformShow(View v) {
        boolean result = true;
        if (this.mOnBeforeShowCallback != null) {
            result = this.mOnBeforeShowCallback.onBeforeShow(this.mPopupView, v, this.mShowAnimation != null || this.mShowAnimator != null);
        }
        return result;
    }

    protected Animation getTranslateAnimation(int start, int end, int durationMillis) {
        return SimpleAnimUtil.getTranslateAnimation(start, end, durationMillis);
    }

    protected Animation getScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        return SimpleAnimUtil.getScaleAnimation(fromX, toX, fromY, toY, pivotXType, pivotXValue, pivotYType, pivotYValue);
    }

    protected Animation getDefaultScaleAnimation() {
        return SimpleAnimUtil.getDefaultScaleAnimation();
    }

    protected Animation getDefaultAlphaAnimation() {
        return SimpleAnimUtil.getDefaultAlphaAnimation();
    }

    protected AnimatorSet getDefaultSlideFromBottomAnimationSet() {
        return SimpleAnimUtil.getDefaultSlideFromBottomAnimationSet(this.mAnimaView);
    }

    public int getScreenHeight() {
        return this.getContext().getResources().getDisplayMetrics().heightPixels;
    }

    public int getScreenWidth() {
        return this.getContext().getResources().getDisplayMetrics().widthPixels;
    }

    protected void showOnTop(View mPopupView) {
    }

    protected void showOnDown(View mPopupView) {
    }

    public void onDismiss() {
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
        this.isExitAnimaPlaying = false;
    }

    public static abstract class OnDismissListener
    implements PopupWindow.OnDismissListener {
        public boolean onBeforeDismiss() {
            return true;
        }
    }

    public static interface OnBeforeShowCallback {
        public boolean onBeforeShow(View var1, View var2, boolean var3);
    }
}

