/*
 * Decompiled with CFR 0.152.
 */
package com.github.raychatter;

import com.github.raychatter.ExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class AnnotationHandler
implements HandlerExceptionResolver {
    protected static final String DEFAULT_ERROR_STRING = "<error>%s</error>";
    protected static final String USER_TEMPLATE = "error.template";
    protected static final String DEFAULT_TEMPLATE = "defaults/default.template";
    private static final String UTF_8 = "UTF-8";
    private static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private static final int DEFAULT_STATUS_CODE = HttpStatus.INTERNAL_SERVER_ERROR.value();
    private boolean useHandledExceptionMessage = true;
    private boolean useGetCause = true;

    public void setUseHandledExceptionMessage(boolean flag) {
        this.useHandledExceptionMessage = flag;
    }

    public void setUseGetCause(boolean flag) {
        this.useGetCause = flag;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception thrownException) {
        Exception handledException = this.getHandledException(thrownException);
        ExceptionHandler annotation = this.getAnnotationFrom(handledException);
        Exception messageException = this.getMessageException(thrownException, handledException);
        try {
            if (annotation == null) {
                handledException.printStackTrace();
                return this.respondWithDefault(messageException, response);
            }
            return this.handleException(annotation, messageException, response);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ModelAndView();
        }
    }

    protected Exception getHandledException(Exception thrownException) {
        if (this.useGetCause) {
            return this.getAnnotatedException(thrownException);
        }
        return thrownException;
    }

    protected Exception getMessageException(Exception thrownException, Exception annotatedException) {
        if (this.useHandledExceptionMessage) {
            return annotatedException;
        }
        return thrownException;
    }

    protected ModelAndView handleException(ExceptionHandler annotation, Exception handledException, HttpServletResponse response) throws IOException {
        response.setContentType(annotation.contentType());
        response.setStatus(annotation.httpStatus().value());
        try {
            String message = this.formatMessage(handledException);
            response.getWriter().write(message);
        }
        catch (IOException e) {
            return this.respondWithDefault(handledException, response);
        }
        return new ModelAndView();
    }

    protected ModelAndView respondWithDefault(Exception handledException, HttpServletResponse response) throws IOException {
        response.setContentType(DEFAULT_CONTENT_TYPE);
        response.setStatus(DEFAULT_STATUS_CODE);
        response.getWriter().write(this.formatDefaultMessage(handledException));
        return new ModelAndView();
    }

    protected Exception getAnnotatedException(Exception exception) {
        Throwable causedException = exception.getCause();
        if (this.getAnnotationFrom(exception) != null || causedException == null) {
            return exception;
        }
        return this.getAnnotatedException((Exception)causedException);
    }

    protected ExceptionHandler getAnnotationFrom(Exception exception) {
        return exception.getClass().getAnnotation(ExceptionHandler.class);
    }

    protected String formatMessage(Exception handledException) throws IOException {
        return String.format(this.readTemplate(), handledException.getMessage());
    }

    protected String formatDefaultMessage(Exception handledException) throws IOException {
        return String.format(this.readDefaultTemplate(), handledException.getMessage());
    }

    protected String readTemplate() throws IOException {
        InputStream templateFile = this.getResource(USER_TEMPLATE);
        return new Scanner(templateFile, UTF_8).useDelimiter("\\A").next().trim();
    }

    protected String readDefaultTemplate() {
        try {
            InputStream templateFile = this.getResource(DEFAULT_TEMPLATE);
            return new Scanner(templateFile, UTF_8).useDelimiter("\\A").next().trim();
        }
        catch (IOException ex) {
            return DEFAULT_ERROR_STRING;
        }
    }

    protected InputStream getResource(String resource) throws IOException {
        return new ClassPathResource(resource).getInputStream();
    }
}

