/*
 * Decompiled with CFR 0.152.
 */
package com.github.rahul.githuboauth;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.github.rahul.githuboauth.ErrorCallback;
import com.github.rahul.githuboauth.R;
import com.github.rahul.githuboauth.SuccessCallback;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0004J\u0012\u0010\u001c\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020 2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J&\u0010!\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010&\u001a\u00020\u0017H\u0016J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/github/rahul/githuboauth/GithubOAuthDialogFragment;", "Landroid/support/v4/app/DialogFragment;", "()V", "CLIENT_ID", "", "CLIENT_SECRET", "TAG", "debug", "", "mErrorCallback", "Lcom/github/rahul/githuboauth/ErrorCallback;", "getMErrorCallback", "()Lcom/github/rahul/githuboauth/ErrorCallback;", "setMErrorCallback", "(Lcom/github/rahul/githuboauth/ErrorCallback;)V", "mSuccessCallback", "Lcom/github/rahul/githuboauth/SuccessCallback;", "getMSuccessCallback", "()Lcom/github/rahul/githuboauth/SuccessCallback;", "setMSuccessCallback", "(Lcom/github/rahul/githuboauth/SuccessCallback;)V", "scope", "buildURL", "", "view", "Landroid/view/View;", "getOAuthTokenFromCode", "code", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateDialog", "Landroid/app/Dialog;", "onCreateView", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onStart", "setupWebview", "Companion", "github-oauth_release"})
public final class GithubOAuthDialogFragment
extends DialogFragment {
    private String CLIENT_ID = "";
    private String CLIENT_SECRET = "";
    private boolean debug;
    private String scope = "";
    private final String TAG = "github-oauth";
    @Nullable
    private SuccessCallback mSuccessCallback;
    @Nullable
    private ErrorCallback mErrorCallback;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @Nullable
    public final SuccessCallback getMSuccessCallback() {
        return this.mSuccessCallback;
    }

    public final void setMSuccessCallback(@Nullable SuccessCallback successCallback) {
        this.mSuccessCallback = successCallback;
    }

    @Nullable
    public final ErrorCallback getMErrorCallback() {
        return this.mErrorCallback;
    }

    public final void setMErrorCallback(@Nullable ErrorCallback errorCallback) {
        this.mErrorCallback = errorCallback;
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog != null) {
            int width = -1;
            int height = -1;
            dialog.getWindow().setLayout(width, height);
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle == null) {
            Intrinsics.throwNpe();
        }
        String string = bundle.getString("id", "");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"arguments!!.getString(\"id\", \"\")");
        this.CLIENT_ID = string;
        Bundle bundle2 = this.getArguments();
        if (bundle2 == null) {
            Intrinsics.throwNpe();
        }
        String string2 = bundle2.getString("secret", "");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"arguments!!.getString(\"secret\", \"\")");
        this.CLIENT_SECRET = string2;
        Bundle bundle3 = this.getArguments();
        if (bundle3 == null) {
            Intrinsics.throwNpe();
        }
        String string3 = bundle3.getString("scope", "");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"arguments!!.getString(\"scope\", \"\")");
        this.scope = string3;
        Bundle bundle4 = this.getArguments();
        if (bundle4 == null) {
            Intrinsics.throwNpe();
        }
        this.debug = bundle4.getBoolean("debug", false);
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view;
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        View view2 = view = inflater.inflate(R.layout.fragment_github_oauth, container, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
        this.setupWebview(view2);
        this.buildURL(view);
        return view;
    }

    private final void buildURL(View view) {
        String urlToLoad = "https://github.com/login/oauth/authorize?client_id=" + this.CLIENT_ID;
        CharSequence charSequence = this.scope;
        if (charSequence.length() > 0) {
            urlToLoad = urlToLoad + "&scope=" + this.scope;
        }
        ((WebView)view.findViewById(R.id.webView)).loadUrl(urlToLoad);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void setupWebview(View view) {
        WebView webView = (WebView)view.findViewById(R.id.webView);
        Intrinsics.checkExpressionValueIsNotNull((Object)webView, (String)"view.webView");
        WebSettings webSettings = webView.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)webSettings, (String)"view.webView.settings");
        webSettings.setJavaScriptEnabled(true);
        WebView webView2 = (WebView)view.findViewById(R.id.webView);
        Intrinsics.checkExpressionValueIsNotNull((Object)webView2, (String)"view.webView");
        webView2.setWebViewClient(new WebViewClient(this, view){
            final /* synthetic */ GithubOAuthDialogFragment this$0;
            final /* synthetic */ View $view;

            public void onPageFinished(@Nullable WebView webview, @Nullable String url) {
                super.onPageFinished(webview, url);
                ProgressBar progressBar = (ProgressBar)this.$view.findViewById(R.id.progressBar);
                Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"view.progressBar");
                progressBar.setVisibility(8);
            }

            public boolean shouldOverrideUrlLoading(@NotNull WebView webView, @NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)webView, (String)"webView");
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                super.shouldOverrideUrlLoading(webView, url);
                ProgressBar progressBar = (ProgressBar)this.$view.findViewById(R.id.progressBar);
                Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"view.progressBar");
                progressBar.setVisibility(0);
                try {
                    String code = Uri.parse((String)url).getQueryParameter("code");
                    if (code != null) {
                        WebView webView2 = (WebView)this.$view.findViewById(R.id.webView);
                        Intrinsics.checkExpressionValueIsNotNull((Object)webView2, (String)"view.webView");
                        webView2.setVisibility(8);
                        this.this$0.getOAuthTokenFromCode(this.$view, code);
                        if (GithubOAuthDialogFragment.access$getDebug$p(this.this$0)) {
                            Log.d((String)GithubOAuthDialogFragment.access$getTAG$p(this.this$0), (String)("code fetched is: " + code));
                        }
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                return false;
            }
            {
                this.this$0 = $outer;
                this.$view = $captured_local_variable$1;
            }
        });
    }

    public final void getOAuthTokenFromCode(@NotNull View view, @NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        LinearLayout linearLayout = (LinearLayout)view.findViewById(R.id.progressView);
        Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"view.progressView");
        linearLayout.setVisibility(0);
        OkHttpClient client = new OkHttpClient();
        HttpUrl.Builder url = HttpUrl.parse((String)"https://github.com/login/oauth/access_token").newBuilder();
        url.addQueryParameter("client_id", this.CLIENT_ID);
        url.addQueryParameter("client_secret", this.CLIENT_SECRET);
        url.addQueryParameter("code", code);
        String urlOauth = url.build().toString();
        Request request = new Request.Builder().header("Accept", "application/json").url(urlOauth).build();
        client.newCall(request).enqueue(new Callback(this){
            final /* synthetic */ GithubOAuthDialogFragment this$0;

            public void onFailure(@Nullable Request request, @NotNull IOException exp) {
                Intrinsics.checkParameterIsNotNull((Object)exp, (String)"exp");
                if (this.this$0.getMErrorCallback() != null) {
                    ErrorCallback errorCallback = this.this$0.getMErrorCallback();
                    if (errorCallback == null) {
                        Intrinsics.throwNpe();
                    }
                    errorCallback.onError(exp);
                }
                if (GithubOAuthDialogFragment.access$getDebug$p(this.this$0)) {
                    Log.d((String)GithubOAuthDialogFragment.access$getTAG$p(this.this$0), (String)("IOException: " + exp.getMessage()));
                }
                this.this$0.dismiss();
            }

            public void onResponse(@NotNull Response response) throws IOException {
                block13: {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    if (response.isSuccessful()) {
                        String jsonData = response.body().string();
                        if (GithubOAuthDialogFragment.access$getDebug$p(this.this$0)) {
                            Log.d((String)GithubOAuthDialogFragment.access$getTAG$p(this.this$0), (String)("response is: " + jsonData));
                        }
                        try {
                            JSONObject jsonObject = new JSONObject(jsonData);
                            String authToken = jsonObject.getString("access_token");
                            if (this.this$0.getMSuccessCallback() != null) {
                                SuccessCallback successCallback = this.this$0.getMSuccessCallback();
                                if (successCallback == null) {
                                    Intrinsics.throwNpe();
                                }
                                String string = authToken;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"authToken");
                                successCallback.onSuccess(string);
                            }
                            if (GithubOAuthDialogFragment.access$getDebug$p(this.this$0)) {
                                Log.d((String)GithubOAuthDialogFragment.access$getTAG$p(this.this$0), (String)("token is: " + authToken));
                            }
                            break block13;
                        }
                        catch (JSONException exp) {
                            if (this.this$0.getMErrorCallback() != null) {
                                ErrorCallback errorCallback = this.this$0.getMErrorCallback();
                                if (errorCallback == null) {
                                    Intrinsics.throwNpe();
                                }
                                errorCallback.onError((Exception)((Object)exp));
                            }
                            if (GithubOAuthDialogFragment.access$getDebug$p(this.this$0)) {
                                Log.d((String)GithubOAuthDialogFragment.access$getTAG$p(this.this$0), (String)("json exception: " + exp.getMessage()));
                            }
                            break block13;
                        }
                    }
                    if (this.this$0.getMErrorCallback() != null) {
                        ErrorCallback errorCallback = this.this$0.getMErrorCallback();
                        if (errorCallback == null) {
                            Intrinsics.throwNpe();
                        }
                        errorCallback.onError(new Exception(response.message()));
                    }
                    if (GithubOAuthDialogFragment.access$getDebug$p(this.this$0)) {
                        Log.d((String)GithubOAuthDialogFragment.access$getTAG$p(this.this$0), (String)("onResponse: not success: " + response.message()));
                    }
                }
                this.this$0.dismiss();
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @NotNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            Intrinsics.throwNpe();
        }
        return new Dialog(this, (Context)fragmentActivity, this.getTheme()){
            final /* synthetic */ GithubOAuthDialogFragment this$0;

            public void onBackPressed() {
                View view = this.this$0.getView();
                if (view == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"view!!");
                if (((WebView)view.findViewById(R.id.webView)).canGoBack()) {
                    View view2 = this.this$0.getView();
                    if (view2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view!!");
                    ((WebView)view2.findViewById(R.id.webView)).goBack();
                } else {
                    this.dismiss();
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    public static final /* synthetic */ boolean access$getDebug$p(GithubOAuthDialogFragment $this) {
        return $this.debug;
    }

    public static final /* synthetic */ void access$setDebug$p(GithubOAuthDialogFragment $this, boolean bl) {
        $this.debug = bl;
    }

    @NotNull
    public static final /* synthetic */ String access$getTAG$p(GithubOAuthDialogFragment $this) {
        return $this.TAG;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/rahul/githuboauth/GithubOAuthDialogFragment$Companion;", "", "()V", "newInstance", "Lcom/github/rahul/githuboauth/GithubOAuthDialogFragment;", "args", "Landroid/os/Bundle;", "github-oauth_release"})
    public static final class Companion {
        @NotNull
        public final GithubOAuthDialogFragment newInstance(@NotNull Bundle args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            GithubOAuthDialogFragment f = new GithubOAuthDialogFragment();
            f.setArguments(args);
            return f;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

