/*
 * Decompiled with CFR 0.152.
 */
package com.github.rahul.githuboauth;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.v7.app.AppCompatActivity;
import com.github.rahul.githuboauth.ErrorCallback;
import com.github.rahul.githuboauth.GithubOAuthDialogFragment;
import com.github.rahul.githuboauth.SuccessCallback;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\t\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/github/rahul/githuboauth/GithubAuthenticator;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "authFragment", "Lcom/github/rahul/githuboauth/GithubOAuthDialogFragment;", "authenticate", "", "Builder", "Companion", "github-oauth_release"})
public final class GithubAuthenticator {
    private GithubOAuthDialogFragment authFragment;
    private final Context context;
    @NotNull
    public static final String GITHUB_URL = "https://github.com/login/oauth/authorize";
    @NotNull
    public static final String GITHUB_OAUTH = "https://github.com/login/oauth/access_token";
    public static final Companion Companion = new Companion(null);

    public final void authenticate() {
        block1: {
            GithubOAuthDialogFragment githubOAuthDialogFragment = this.authFragment;
            if (githubOAuthDialogFragment == null) break block1;
            Context context = this.context;
            if (context == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.support.v7.app.AppCompatActivity");
            }
            githubOAuthDialogFragment.show(((AppCompatActivity)context).getSupportFragmentManager(), "Auth");
        }
    }

    public GithubAuthenticator(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Nullable
    public static final /* synthetic */ GithubOAuthDialogFragment access$getAuthFragment$p(GithubAuthenticator $this) {
        return $this.authFragment;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0006J\u0018\u0010\u001b\u001a\u00020\b2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000fH\u0002J\u0012\u0010\u001c\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\u001e\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0007J\u0014\u0010\u000e\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000f2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/rahul/githuboauth/GithubAuthenticator$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "clearBeforeLaunch", "", "mClientId", "", "mClientSecret", "mErrorCallback", "Lcom/github/rahul/githuboauth/ErrorCallback;", "mHasScopes", "mIsDebug", "scopeList", "Ljava/util/ArrayList;", "mScopeList", "setMScopeList", "(Ljava/util/ArrayList;)V", "mSuccessCallback", "Lcom/github/rahul/githuboauth/SuccessCallback;", "build", "Lcom/github/rahul/githuboauth/GithubAuthenticator;", "clientId", "clientSecret", "debug", "active", "getScopeFromList", "onError", "callback", "onSuccess", "github-oauth_release"})
    public static final class Builder {
        private String mClientId;
        private String mClientSecret;
        private boolean mIsDebug;
        private ArrayList<String> mScopeList;
        private boolean mHasScopes;
        private boolean clearBeforeLaunch;
        private SuccessCallback mSuccessCallback;
        private ErrorCallback mErrorCallback;
        private final Context context;

        private final void setMScopeList(ArrayList<String> scopeList) {
            this.mScopeList = new ArrayList();
            this.mScopeList = scopeList;
        }

        @NotNull
        public final Builder clientId(@NotNull String clientId) {
            Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
            this.mClientId = clientId;
            return this;
        }

        @NotNull
        public final Builder clientSecret(@NotNull String clientSecret) {
            Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
            this.mClientSecret = clientSecret;
            return this;
        }

        @NotNull
        public final Builder debug(boolean active) {
            this.mIsDebug = active;
            return this;
        }

        @NotNull
        public final Builder scopeList(@NotNull ArrayList<String> scopeList) {
            Intrinsics.checkParameterIsNotNull(scopeList, (String)"scopeList");
            this.setMScopeList(scopeList);
            if (this.mScopeList != null) {
                Collection collection;
                ArrayList<String> arrayList = this.mScopeList;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                if (!(collection = (Collection)arrayList).isEmpty()) {
                    this.mHasScopes = true;
                }
            }
            return this;
        }

        @NotNull
        public final Builder clearBeforeLaunch(boolean clearBeforeLaunch) {
            this.clearBeforeLaunch = clearBeforeLaunch;
            return this;
        }

        @MainThread
        @NotNull
        public final Builder onSuccess(@Nullable SuccessCallback callback) {
            this.mSuccessCallback = callback;
            return this;
        }

        @MainThread
        @NotNull
        public final Builder onError(@Nullable ErrorCallback callback) {
            this.mErrorCallback = callback;
            return this;
        }

        private final String getScopeFromList(ArrayList<String> scopeList) {
            String scopeString = "";
            ArrayList<String> arrayList = scopeList;
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            for (String scope : arrayList) {
                if (Intrinsics.areEqual((Object)scopeString, (Object)"") ^ true) {
                    scopeString = scopeString + ",";
                }
                scopeString = scopeString + scope;
            }
            return scopeString;
        }

        @NotNull
        public final GithubAuthenticator build() {
            Bundle args = new Bundle();
            args.putString("id", this.mClientId);
            args.putString("secret", this.mClientSecret);
            if (this.mHasScopes) {
                args.putString("scope", this.getScopeFromList(this.mScopeList));
            }
            args.putBoolean("debug", this.mIsDebug);
            GithubOAuthDialogFragment authFragment = GithubOAuthDialogFragment.Companion.newInstance(args);
            authFragment.setMSuccessCallback(this.mSuccessCallback);
            authFragment.setMErrorCallback(this.mErrorCallback);
            GithubAuthenticator authenticator = new GithubAuthenticator(this.context);
            authenticator.authFragment = authFragment;
            return authenticator;
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/rahul/githuboauth/GithubAuthenticator$Companion;", "", "()V", "GITHUB_OAUTH", "", "GITHUB_URL", "builder", "Lcom/github/rahul/githuboauth/GithubAuthenticator$Builder;", "context", "Landroid/content/Context;", "github-oauth_release"})
    public static final class Companion {
        @NotNull
        public final Builder builder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return new Builder(context);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

