/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.markdown.confluence.gradle.plugin;

import com.github.qwazer.markdown.confluence.core.ConfluenceConfig;
import com.github.qwazer.markdown.confluence.core.SpringConfig;
import com.github.qwazer.markdown.confluence.core.service.MainService;
import com.github.qwazer.markdown.confluence.core.ssl.SslUtil;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.util.Assert;

public class ConfluenceGradleTask
extends DefaultTask {
    @TaskAction
    public void confluence() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        AnnotationConfigApplicationContext annotationConfigApplicationContext = new AnnotationConfigApplicationContext(new Class[]{SpringConfig.class});
        MainService mainService = (MainService)annotationConfigApplicationContext.getBean(MainService.class);
        ConfluenceConfig confluenceConfig = (ConfluenceConfig)this.getProject().getExtensions().findByType(ConfluenceConfig.class);
        ConfluenceGradleTask.validate(confluenceConfig);
        if (confluenceConfig.isSslTrustAll()) {
            SslUtil.sslTrustAll();
        }
        mainService.processAll(confluenceConfig);
        annotationConfigApplicationContext.close();
    }

    protected static void validate(ConfluenceConfig config) {
        Assert.notNull((Object)config);
        Assert.hasLength((String)config.getRestApiUrl());
        Assert.hasLength((String)config.getSpaceKey());
        Assert.notNull(config.getPages());
        for (ConfluenceConfig.Page page : config.getPages()) {
            Assert.hasLength((String)page.getParentTitle());
            Assert.hasLength((String)page.getTitle());
            Assert.notNull((Object)page.getSrcFile());
            Assert.isTrue((!page.getParentTitle().equals(page.getTitle()) ? 1 : 0) != 0, (String)String.format("Page with title %s cannot be parent of itself ", page.getTitle()));
        }
        ConfluenceGradleTask.validateNoDuplicates(config.getPages());
    }

    protected static void validateNoDuplicates(Collection<ConfluenceConfig.Page> pages) {
        TreeSet<ConfluenceConfig.Page> set = new TreeSet<ConfluenceConfig.Page>(new Comparator<ConfluenceConfig.Page>(){

            @Override
            public int compare(ConfluenceConfig.Page o1, ConfluenceConfig.Page o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        set.addAll(pages);
        if (set.size() < pages.size()) {
            throw new IllegalArgumentException("Found duplicate pageTitle in confluence pages");
        }
    }
}

