/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.markdown.confluence.gradle.plugin;

import com.github.qwazer.markdown.confluence.core.OkHttpUtils;
import com.github.qwazer.markdown.confluence.core.Utils;
import com.github.qwazer.markdown.confluence.core.service.AttachmentService;
import com.github.qwazer.markdown.confluence.core.service.ConfluenceService;
import com.github.qwazer.markdown.confluence.core.service.MarkdownService;
import com.github.qwazer.markdown.confluence.core.service.PageService;
import com.github.qwazer.markdown.confluence.core.ssl.SslUtil;
import com.github.qwazer.markdown.confluence.gradle.plugin.AuthenticationType;
import com.github.qwazer.markdown.confluence.gradle.plugin.ConfluenceExtension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import okhttp3.OkHttpClient;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class ConfluenceGradleTask
extends DefaultTask {
    @TaskAction
    public void confluence() throws IOException {
        String restApiUrl;
        ConfluenceExtension extension = (ConfluenceExtension)Objects.requireNonNull(this.getProject().getExtensions().findByType(ConfluenceExtension.class));
        extension.getConfiguredPages().forEach(page -> {
            Utils.require(Files.exists(page.getSrcFile().toPath(), new LinkOption[0]), "File not found: " + page.getSrcFile());
            Utils.require(!page.getTitle().equals(page.getParentTitle()), String.format("Page title cannot be the same as page parent title: \"%s\"", page.getTitle()));
            Utils.require(page.isTitleSet(), "Page title cannot be blank/empty");
            Utils.require(page.isParentTitleSet(), "Parent's title cannot be blank/empty");
        });
        AuthenticationType authenticationType = (AuthenticationType)((Object)extension.getAuthenticationType().getOrElse((Object)AuthenticationType.BASIC));
        String authentication = (String)extension.getAuthentication().get();
        String authorizationHeader = authenticationType.getAuthorizationHeader(authentication);
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(30L)).readTimeout(Duration.ofSeconds(60L)).writeTimeout(Duration.ofSeconds(60L)).addInterceptor(OkHttpUtils.getAuthorizationInterceptor(authorizationHeader));
        boolean sslTrustAll = (Boolean)extension.getSslTrustAll().getOrElse((Object)false);
        if (sslTrustAll) {
            httpClientBuilder.sslSocketFactory(SslUtil.INSECURE_SSL_CONTEXT.getSocketFactory(), SslUtil.INSECURE_TRUST_MANAGER);
            httpClientBuilder.hostnameVerifier((hostname, session) -> true);
        }
        OkHttpClient httpClient = httpClientBuilder.build();
        try {
            restApiUrl = new URL((String)extension.getRestApiUrl().get()).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid restApiUrl value supplied: " + (String)extension.getRestApiUrl().get());
        }
        String spaceKey = (String)extension.getSpaceKey().get();
        Utils.require(!spaceKey.trim().isEmpty(), "Confluence space key cannot be blank/empty");
        ConfluenceService confluenceService = new ConfluenceService(restApiUrl, spaceKey, httpClient);
        Long parseTimeout = (Long)extension.getParseTimeout().getOrNull();
        MarkdownService markdownService = parseTimeout == null ? new MarkdownService() : new MarkdownService(parseTimeout);
        AttachmentService attachmentService = new AttachmentService(confluenceService);
        PageService pageService = new PageService(confluenceService, attachmentService, markdownService);
        Map pageVariables = (Map)extension.getPageVariables().getOrElse(Collections.emptyMap());
        extension.getPages().forEach(page -> {
            try {
                pageService.publishWikiPage((ConfluenceExtension.Page)page, pageVariables);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

