/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.markdown.confluence.gradle.plugin;

import com.github.qwazer.markdown.confluence.gradle.plugin.AuthenticationType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

public abstract class ConfluenceExtension {
    private List<Page> pages;

    abstract Property<AuthenticationType> getAuthenticationType();

    abstract Property<String> getAuthentication();

    abstract Property<String> getRestApiUrl();

    abstract Property<String> getSpaceKey();

    abstract Property<Boolean> getSslTrustAll();

    abstract MapProperty<String, String> getPageVariables();

    abstract Property<Long> getParseTimeout();

    abstract NamedDomainObjectContainer<Page> getConfiguredPages();

    public void pages(Action<? super NamedDomainObjectContainer<Page>> action) {
        action.execute(this.getConfiguredPages());
    }

    public List<Page> getPages() {
        if (this.pages == null) {
            this.pages = this.getPages(new ArrayList<Page>((Collection<Page>)this.getConfiguredPages()));
        }
        return this.pages;
    }

    private List<Page> getPages(List<Page> pages) {
        if (pages.isEmpty()) {
            return Collections.emptyList();
        }
        return pages.stream().collect(Collectors.partitioningBy(page -> this.hasParent((Page)page, pages))).entrySet().stream().sorted(Map.Entry.comparingByKey()).flatMap(entry -> {
            if (((Boolean)entry.getKey()).booleanValue()) {
                return this.getPages((List)entry.getValue()).stream();
            }
            return ((List)entry.getValue()).stream();
        }).collect(Collectors.toList());
    }

    boolean hasParent(Page page, List<Page> pages) {
        return pages.stream().anyMatch(pageFromPages -> pageFromPages != page && page.getParentTitle().equals(pageFromPages.getName()));
    }

    public static abstract class Page
    implements Named {
        private final String name;
        private String parentTitle;
        private File srcFile;
        private List<String> labels = new ArrayList<String>();

        public Page(String name) {
            this.name = name;
        }

        public String getContent() throws IOException {
            return new String(Files.readAllBytes(this.getSrcFile().toPath()), StandardCharsets.UTF_8);
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getTitle() {
            return this.getName();
        }

        public boolean isTitleSet() {
            return !this.getTitle().trim().isEmpty();
        }

        public String getParentTitle() {
            return this.parentTitle;
        }

        public void setParentTitle(String parentTitle) {
            this.parentTitle = parentTitle;
        }

        public boolean isParentTitleSet() {
            String parentTitle = this.getParentTitle();
            return parentTitle != null && !parentTitle.trim().isEmpty();
        }

        public File getSrcFile() {
            return this.srcFile;
        }

        public void setSrcFile(File srcFile) {
            this.srcFile = srcFile;
        }

        public List<String> getLabels() {
            return this.labels;
        }

        public void setLabels(List<Object> labels) {
            if (labels == null) {
                throw new IllegalArgumentException("labels cannot be null");
            }
            this.labels = labels.stream().map(Object::toString).collect(Collectors.toList());
        }
    }
}

