/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.markdown.confluence.core.service;

import com.github.qwazer.markdown.confluence.core.ConfluenceException;
import com.github.qwazer.markdown.confluence.core.model.ConfluencePage;
import com.github.qwazer.markdown.confluence.core.service.AttachmentService;
import com.github.qwazer.markdown.confluence.core.service.ConfluenceService;
import com.github.qwazer.markdown.confluence.core.service.MarkdownService;
import com.github.qwazer.markdown.confluence.gradle.plugin.ConfluenceExtension;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageService {
    public static final Pattern INLINE_IMAGE_PATTERN = Pattern.compile("!\\[(.*)]\\((\\S+)(.*)\\)");
    private static final Logger LOG = LoggerFactory.getLogger(PageService.class);
    private final ConfluenceService confluenceService;
    private final MarkdownService markdownService;
    private final AttachmentService attachmentService;

    public PageService(ConfluenceService confluenceService) {
        this(confluenceService, new AttachmentService(confluenceService), new MarkdownService());
    }

    public PageService(ConfluenceService confluenceService, AttachmentService attachmentService, MarkdownService markdownService) {
        Objects.requireNonNull(confluenceService);
        Objects.requireNonNull(attachmentService);
        Objects.requireNonNull(markdownService);
        this.confluenceService = confluenceService;
        this.attachmentService = attachmentService;
        this.markdownService = markdownService;
    }

    public Pair<String, Map<String, Path>> prepareWikiText(ConfluenceExtension.Page page) throws IOException {
        return this.prepareWikiText(page, Collections.emptyMap());
    }

    public Pair<String, Map<String, Path>> prepareWikiText(ConfluenceExtension.Page page, Map<String, String> pageVariables) throws IOException {
        String markdownText = page.getContent();
        HashMap<String, Path> inlineImages = new HashMap<String, Path>();
        Matcher matcher = INLINE_IMAGE_PATTERN.matcher(markdownText);
        while (matcher.find()) {
            String uri = matcher.group(2);
            if (uri.toLowerCase().startsWith("http") || uri.startsWith("/")) continue;
            String parent = page.getSrcFile().getParent();
            Path path = parent != null ? Paths.get(parent, uri) : Paths.get(uri, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                inlineImages.put(uri, path);
                continue;
            }
            String message = String.format("Could not find local image '%s' referenced in the '%s' markdown file", page, page.getSrcFile());
            throw new ConfluenceException(message);
        }
        String wikiText = this.markdownService.convertMarkdown2Wiki(markdownText, pageVariables);
        for (Map.Entry entry : inlineImages.entrySet()) {
            String patternString = "!" + (String)entry.getKey() + "\\|";
            String replacementString = "!" + ((Path)entry.getValue()).getFileName().toString() + "|";
            wikiText = wikiText.replaceAll(patternString, replacementString);
        }
        return new Pair((Object)wikiText, inlineImages);
    }

    public Long publishWikiPage(ConfluenceExtension.Page page) throws IOException {
        return this.publishWikiPage(page, Collections.emptyMap());
    }

    public Long publishWikiPage(ConfluenceExtension.Page page, Map<String, String> pageVariables) throws IOException {
        Pair<String, Map<String, Path>> pair = this.prepareWikiText(page, pageVariables);
        String wikiText = (String)pair.getFirst();
        Map images = (Map)pair.getSecond();
        ConfluencePage confluencePage = this.confluenceService.findPageByTitle(page.getName());
        if (confluencePage != null) {
            LOG.info("Updating existing page: {}", (Object)confluencePage);
            confluencePage.setContent(wikiText);
            confluencePage.setLabels(page.getLabels());
            this.confluenceService.updatePage(confluencePage);
            this.confluenceService.addLabels(confluencePage.getId(), page.getLabels());
        } else {
            confluencePage = new ConfluencePage();
            confluencePage.setContent(wikiText);
            confluencePage.setTitle(page.getTitle());
            confluencePage.setLabels(page.getLabels());
            Long ancestorId = this.confluenceService.findAncestorId(page.getParentTitle());
            confluencePage.setAncestorId(ancestorId);
            LOG.info("Creating new Confluence page: {}", (Object)confluencePage);
            Long pageId = this.confluenceService.createPage(confluencePage);
            confluencePage.setId(pageId);
            this.confluenceService.addLabels(pageId, page.getLabels());
        }
        for (Map.Entry entry : images.entrySet()) {
            this.attachmentService.postAttachmentToPage(confluencePage.getId(), (Path)entry.getValue());
        }
        return confluencePage.getId();
    }
}

