/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.markdown.confluence.core.service;

import com.github.qwazer.markdown.confluence.core.service.markdown.WikiConfluenceSerializer;
import java.util.Map;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.Node;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.Visitor;

public class MarkdownService {
    private final PegDownProcessor pegDownProcessor;

    public MarkdownService() {
        this.pegDownProcessor = new PegDownProcessor(WikiConfluenceSerializer.extensions());
    }

    public MarkdownService(long parseTimeOut) {
        this.pegDownProcessor = new PegDownProcessor(WikiConfluenceSerializer.extensions(), parseTimeOut);
    }

    public String convertMarkdown2Wiki(final String markdown, Map<String, String> pageVariables) {
        RootNode root = this.pegDownProcessor.parseMarkdown(markdown.toCharArray());
        WikiConfluenceSerializer ser = new WikiConfluenceSerializer(pageVariables){

            @Override
            protected void notImplementedYet(Node node) {
                int[] lc = WikiConfluenceSerializer.lineAndColFromNode(markdown, node);
                throw new UnsupportedOperationException(String.format("Node [%s] not supported yet. line=[%d] col=[%d]", node.getClass().getSimpleName(), lc[0], lc[1]));
            }
        };
        root.accept((Visitor)ser);
        return ser.toString();
    }
}

