/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.markdown.confluence.core.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.qwazer.markdown.confluence.core.ConfluenceException;
import com.github.qwazer.markdown.confluence.core.NotFoundException;
import com.github.qwazer.markdown.confluence.core.model.ConfluencePage;
import com.github.qwazer.markdown.confluence.core.model.ConfluenceSpace;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluenceService.class);
    private static final String BODY = "body";
    private static final String EXPAND = "expand";
    private static final String ID = "id";
    private static final String SPACE = "space";
    private static final String SPACE_KEY = "spaceKey";
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String PAGE_VERSION = "version";
    private static final String VERSION_NUMBER = "number";
    private final HttpUrl baseUrl;
    private final String spaceKey;
    private final OkHttpClient httpClient;
    private final ObjectMapper mapper;

    public ConfluenceService(@Nonnull String baseUrl, @Nonnull String spaceKey, @Nonnull OkHttpClient httpClient) {
        this(baseUrl, spaceKey, httpClient, new ObjectMapper());
    }

    public ConfluenceService(@Nonnull String baseUrl, @Nonnull String spaceKey, @Nonnull OkHttpClient httpClient, @Nonnull ObjectMapper mapper) {
        this.baseUrl = HttpUrl.parse((String)baseUrl);
        this.spaceKey = spaceKey;
        this.httpClient = httpClient;
        this.mapper = mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public Request getSpaceRequest(String spaceKey) {
        HttpUrl url = this.baseUrl.newBuilder().addPathSegments(String.format("space/%s", spaceKey)).build();
        return new Request.Builder().get().url(url).build();
    }

    @Nullable
    public ConfluenceSpace getSpace(String spaceKey) {
        try {
            return (ConfluenceSpace)this.mapper.convertValue((Object)this.executeRequest(this.getSpaceRequest(spaceKey)), ConfluenceSpace.class);
        }
        catch (IllegalArgumentException e) {
            throw new ConfluenceException(e.getMessage(), e);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public ConfluenceSpace getOrCreateSpace(String spaceKey) {
        ConfluenceSpace existingSpace = this.getSpace(spaceKey);
        if (existingSpace == null) {
            return this.createSpace(new ConfluenceSpace(spaceKey));
        }
        return existingSpace;
    }

    public Request createSpaceRequest(ConfluenceSpace space) {
        HttpUrl url = this.baseUrl.newBuilder().addPathSegment(SPACE).build();
        return new Request.Builder().url(url).post(RequestBody.create((String)((JsonNode)this.mapper.convertValue((Object)space, JsonNode.class)).toString(), (MediaType)MediaType.parse((String)"application/json"))).build();
    }

    public ConfluenceSpace createSpace(ConfluenceSpace space) {
        return (ConfluenceSpace)this.mapper.convertValue((Object)this.executeRequest(this.createSpaceRequest(space)), ConfluenceSpace.class);
    }

    public Request findPageByTitleRequest(String title) {
        HttpUrl url = this.baseUrl.newBuilder().addPathSegment("content").setQueryParameter(SPACE_KEY, this.spaceKey).setQueryParameter(TITLE, title).setQueryParameter(EXPAND, "body.storage,version,ancestors,metadata.labels").build();
        return new Request.Builder().get().url(url).build();
    }

    @Nullable
    public ConfluencePage findPageByTitle(String title) {
        try {
            return ConfluenceService.parseResponseEntityToConfluencePage(this.executeRequest(this.findPageByTitleRequest(title)));
        }
        catch (NotFoundException e) {
            LOG.debug("Page \"{}\" not found in space \"{}\"", (Object)title, (Object)this.spaceKey);
            return null;
        }
    }

    public Request findSpaceHomePageRequest() {
        HttpUrl url = this.baseUrl.newBuilder().addPathSegment("content").setQueryParameter(SPACE_KEY, this.spaceKey).setQueryParameter(EXPAND, "body.storage,version,ancestors").build();
        return new Request.Builder().get().url(url).build();
    }

    public ConfluencePage findSpaceHomePage() {
        return ConfluenceService.parseResponseEntityToConfluencePage(this.executeRequest(this.findSpaceHomePageRequest()));
    }

    public void updatePage(ConfluencePage page) {
        this.executeRequest(this.updatePageRequest(page));
    }

    public Request updatePageRequest(ConfluencePage page) {
        HttpUrl url = this.baseUrl.newBuilder().addPathSegments(String.format("content/%s", page.getId())).build();
        ObjectNode requestBody = this.buildPostBody(page);
        requestBody.put(ID, page.getId());
        requestBody.set(PAGE_VERSION, (JsonNode)this.mapper.createObjectNode().put(VERSION_NUMBER, page.getVersion() + 1));
        return new Request.Builder().url(url).put(RequestBody.create((String)requestBody.toString(), (MediaType)MediaType.parse((String)"application/json"))).build();
    }

    /*
     * Exception decompiling
     */
    private JsonNode executeRequest(Request request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Request createPageRequest(ConfluencePage page) {
        HttpUrl url = this.baseUrl.newBuilder().addPathSegment("content").build();
        ObjectNode requestBody = this.buildPostBody(page);
        return new Request.Builder().url(url).post(RequestBody.create((String)requestBody.toString(), (MediaType)MediaType.parse((String)"application/json"))).build();
    }

    public Long createPage(ConfluencePage page) {
        return ConfluenceService.parsePageIdFromResponse(this.executeRequest(this.createPageRequest(page)));
    }

    public Request addLabelsRequest(Long pageId, @Nonnull String labelName) {
        HttpUrl url = this.baseUrl.newBuilder().addPathSegments(String.format("content/%d/label", pageId)).build();
        JsonNode requestBody = this.buildAddLabelPostBody(labelName);
        return new Request.Builder().url(url).post(RequestBody.create((String)requestBody.toString(), (MediaType)MediaType.parse((String)"application/json"))).build();
    }

    public void addLabels(Long pageId, @Nonnull Collection<String> labels) {
        Objects.requireNonNull(labels);
        if (labels.isEmpty()) {
            return;
        }
        labels.forEach(label -> this.executeRequest(this.addLabelsRequest(pageId, (String)label)));
    }

    private JsonNode buildAddLabelPostBody(@Nonnull String labelName) {
        ObjectNode label = this.mapper.createObjectNode().put("name", labelName.replaceAll("\\.", "-")).put("prefix", "global");
        return this.mapper.createArrayNode().add((JsonNode)label);
    }

    protected static ConfluencePage parseResponseEntityToConfluencePage(JsonNode responseBody) {
        JsonNode first;
        if (responseBody == null) {
            return null;
        }
        JsonNode results = responseBody.get("results");
        if (results != null && (first = results.get(0)) != null) {
            ArrayNode arrayNode;
            JsonNode ancestors;
            JsonNode labelsNode;
            JsonNode metadataNode;
            JsonNode valueNode;
            JsonNode storageNode;
            ConfluencePage confluencePage = new ConfluencePage();
            confluencePage.setId(first.get(ID).asLong());
            confluencePage.setVersion(first.get(PAGE_VERSION).get(VERSION_NUMBER).asInt());
            confluencePage.setTitle(first.get(TITLE).asText());
            JsonNode bodyNode = first.get(BODY);
            if (bodyNode != null && (storageNode = bodyNode.get("storage")) != null && (valueNode = storageNode.get("value")) != null) {
                confluencePage.setContent(valueNode.asText());
            }
            if ((metadataNode = first.get("metadata")) != null && (labelsNode = metadataNode.get("labels")) != null) {
                List<String> labels = labelsNode.findValues("name").stream().map(JsonNode::asText).collect(Collectors.toList());
                confluencePage.setLabels(labels);
            }
            if ((ancestors = first.get("ancestors")) instanceof ArrayNode && !(arrayNode = (ArrayNode)ancestors).isEmpty()) {
                Long ancestorId = arrayNode.get(arrayNode.size() - 1).get(ID).asLong();
                LOG.debug("ancestors: {} : {}, choose -> {}", new Object[]{ancestors.getClass().getName(), ancestors, ancestorId});
                confluencePage.setAncestorId(ancestorId);
            }
            return confluencePage;
        }
        return null;
    }

    private ObjectNode buildPostBody(ConfluencePage confluencePage) {
        ObjectNode spaceNode = this.mapper.createObjectNode();
        spaceNode.put("key", this.spaceKey);
        ObjectNode storageData = this.mapper.createObjectNode();
        storageData.put("value", confluencePage.getContent());
        storageData.put("representation", "wiki");
        ObjectNode storageNode = this.mapper.createObjectNode();
        storageNode.set("storage", (JsonNode)storageData);
        ObjectNode bodyNode = this.mapper.createObjectNode();
        bodyNode.put(TYPE, "page");
        bodyNode.put(TITLE, confluencePage.getTitle());
        bodyNode.set(SPACE, (JsonNode)spaceNode);
        bodyNode.set(BODY, (JsonNode)storageNode);
        if (confluencePage.getAncestorId() != null) {
            ObjectNode ancestor = this.mapper.createObjectNode();
            ancestor.put(TYPE, "page");
            ancestor.put(ID, confluencePage.getAncestorId());
            ArrayNode ancestors = this.mapper.createArrayNode();
            ancestors.add((JsonNode)ancestor);
            bodyNode.set("ancestors", (JsonNode)ancestors);
        }
        return bodyNode;
    }

    public Long findAncestorId(String title) {
        LOG.info("Looking up ancestor id by title {}", (Object)title);
        ConfluencePage page = this.findPageByTitle(title);
        if (page != null) {
            return page.getId();
        }
        LOG.info("Using page home id ({}) as ancestorId", (Object)this.spaceKey);
        return this.findSpaceHomePage().getId();
    }

    private static Long parsePageIdFromResponse(JsonNode responseEntity) {
        try {
            return responseEntity.get(ID).asLong();
        }
        catch (Exception e) {
            throw new ConfluenceException("Error Parsing JSON Response from Confluence!", e);
        }
    }

    private static String parseAttachmentIdFromResponse(JsonNode responseEntity) {
        JsonNode id;
        JsonNode first;
        JsonNode results = responseEntity.get("results");
        if (results != null && (first = results.get(0)) != null && (id = first.get(ID)) != null) {
            return id.asText();
        }
        return null;
    }

    public Request getAttachmentIdRequest(Long pageId, String attachmentFilename) {
        HttpUrl url = this.baseUrl.newBuilder().addPathSegments(String.format("content/%d/child/attachment", pageId)).addQueryParameter("filename", attachmentFilename).build();
        return new Request.Builder().get().url(url).build();
    }

    public String getAttachmentId(Long pageId, String attachmentFilename) {
        return ConfluenceService.parseAttachmentIdFromResponse(this.executeRequest(this.getAttachmentIdRequest(pageId, attachmentFilename)));
    }

    public Request createAttachmentRequest(@Nonnull Long pageId, @Nonnull String filePath) {
        Objects.requireNonNull(pageId);
        Objects.requireNonNull(filePath);
        Path path = Paths.get(filePath, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("File not found: " + filePath);
        }
        HttpUrl url = this.baseUrl.newBuilder().addPathSegments(String.format("content/%d/child/attachment", pageId)).build();
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", path.getFileName().toString(), RequestBody.create((File)path.toFile(), (MediaType)MediaType.parse((String)"application/octet-stream"))).build();
        return new Request.Builder().url(url).header("X-Atlassian-Token", "no-check").post((RequestBody)requestBody).build();
    }

    public void createAttachment(Long pageId, String filePath) {
        this.executeRequest(this.createAttachmentRequest(pageId, filePath));
    }

    public Request updateAttachmentRequest(@Nonnull Long pageId, @Nonnull String attachmentId, @Nonnull String filePath) {
        Objects.requireNonNull(pageId);
        Objects.requireNonNull(attachmentId);
        Objects.requireNonNull(filePath);
        Path path = Paths.get(filePath, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("File not found: " + filePath);
        }
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", path.getFileName().toString(), RequestBody.create((File)path.toFile(), (MediaType)MediaType.parse((String)"application/octet-stream"))).build();
        HttpUrl url = this.baseUrl.newBuilder().addPathSegments(String.format("content/%d/child/attachment/%s/data", pageId, attachmentId)).build();
        return new Request.Builder().url(url).header("X-Atlassian-Token", "no-check").post((RequestBody)requestBody).build();
    }

    public void updateAttachment(Long pageId, String attachmentId, String filePath) {
        this.executeRequest(this.updateAttachmentRequest(pageId, attachmentId, filePath));
    }
}

