/*
 * Decompiled with CFR 0.152.
 */
package com.github.psxpaul.util;

import java.io.Closeable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"findOpenPort", "", "isPortOpen", "", "port", "waitForPortOpen", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "process", "Ljava/lang/Process;", "gradle-execfork-plugin"})
public final class PortUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int findOpenPort() {
        Closeable closeable = new ServerSocket(0);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ServerSocket it = (ServerSocket)closeable;
            boolean bl3 = false;
            int n = it.getLocalPort();
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isPortOpen(int port) {
        Closeable closeable = new Socket();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            boolean bl3;
            Socket it = (Socket)closeable;
            boolean bl4 = false;
            InetAddress inetAddress = InetAddress.getByName("127.0.0.1");
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(\"127.0.0.1\")");
            InetAddress inetAddress2 = inetAddress;
            InetSocketAddress socketAddress = new InetSocketAddress(inetAddress2, port);
            try {
                it.connect(socketAddress);
                bl3 = true;
            }
            catch (ConnectException e) {
                bl3 = false;
            }
            boolean bl5 = bl3;
            return bl5;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void waitForPortOpen(int port, long timeout, @NotNull TimeUnit unit, @NotNull Process process) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        long millisToWait = unit.toMillis(timeout);
        long waitUntil = System.currentTimeMillis() + millisToWait;
        while (System.currentTimeMillis() < waitUntil) {
            Thread.sleep(100L);
            if (!process.isAlive()) {
                throw new GradleException("Process died before port " + port + " was opened");
            }
            if (!PortUtilsKt.isPortOpen(port)) continue;
            return;
        }
        throw new GradleException("Timed out waiting for port " + port + " to be opened");
    }
}

