/*
 * Decompiled with CFR 0.152.
 */
package com.github.psxpaul.stream;

import com.github.psxpaul.stream.InputStreamPipeKt;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/psxpaul/stream/InputStreamPipe;", "Ljava/lang/AutoCloseable;", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "pattern", "", "(Ljava/io/InputStream;Ljava/io/OutputStream;Ljava/lang/String;)V", "buffer", "Ljava/util/LinkedList;", "", "log", "Lorg/slf4j/Logger;", "patternLatch", "Ljava/util/concurrent/CountDownLatch;", "patternLength", "thread", "Ljava/lang/Thread;", "close", "", "waitForPattern", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "gradle-execfork-plugin"})
public final class InputStreamPipe
implements AutoCloseable {
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final OutputStream outputStream;
    @Nullable
    private final String pattern;
    @NotNull
    private final Logger log;
    private final int patternLength;
    @NotNull
    private final CountDownLatch patternLatch;
    @NotNull
    private final LinkedList<Integer> buffer;
    @NotNull
    private final Thread thread;

    public InputStreamPipe(@NotNull InputStream inputStream, @NotNull OutputStream outputStream, @Nullable String pattern) {
        int n;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.pattern = pattern;
        Logger logger = LoggerFactory.getLogger(InputStreamPipe.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(InputStreamPipe::class.java)");
        this.log = logger;
        String string = this.pattern;
        if (string == null) {
            byArray = null;
        } else {
            String string2 = string;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray2 = string2.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        }
        logger = byArray;
        this.patternLength = logger == null ? 0 : (n = ((Logger)logger).length);
        this.patternLatch = new CountDownLatch(this.pattern != null ? 1 : 0);
        this.buffer = new LinkedList();
        this.thread = new Thread(() -> InputStreamPipe.thread$lambda-0(this));
        this.thread.start();
    }

    public final void waitForPattern() {
        this.patternLatch.await();
    }

    public final void waitForPattern(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!this.patternLatch.await(timeout, unit)) {
            throw new GradleException("The waitForOutput pattern did not appear before timeout was reached.");
        }
    }

    @Override
    public void close() {
        this.log.debug("closing given outputstream");
        this.outputStream.close();
    }

    /*
     * WARNING - void declaration
     */
    private static final void thread$lambda-0(InputStreamPipe this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = InputStreamPipeKt.safeRead(this$0.inputStream);
        while (n != -1) {
            this$0.outputStream.write(n);
            this$0.outputStream.flush();
            if (this$0.patternLength == 0 || this$0.patternLatch.getCount() == 0L) {
                this$0.log.debug("skipping pattern checking");
            } else if (this$0.buffer.size() < this$0.patternLength - 1) {
                this$0.buffer.addLast(n);
            } else {
                void $this$mapTo$iv$iv;
                this$0.buffer.addLast(n);
                Iterable $this$map$iv = this$0.buffer;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    int n2 = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Byte by = (byte)p0;
                    collection.add(by);
                }
                byte[] byArray = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
                boolean bl = false;
                String bufferStr = new String(byArray, Charsets.UTF_8);
                this$0.log.debug("checking if |" + StringsKt.replace$default((String)bufferStr, (String)"\n", (String)"\\n", (boolean)false, (int)4, null) + "| equals |" + this$0.pattern + '|');
                if (Intrinsics.areEqual((Object)bufferStr, (Object)this$0.pattern)) {
                    this$0.patternLatch.countDown();
                }
                this$0.buffer.removeFirst();
            }
            n = InputStreamPipeKt.safeRead(this$0.inputStream);
        }
        this$0.close();
    }
}

