/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.xlog_android.lib;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

final class Strings {
    static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence) {
            return '\"' + Strings.printableToString(obj.toString()) + '\"';
        }
        Class<?> cls = obj.getClass();
        if (Byte.class == cls) {
            return Strings.byteToString((Byte)obj);
        }
        if (cls.isArray()) {
            return Strings.arrayToString(cls.getComponentType(), obj);
        }
        return obj.toString();
    }

    private static String printableToString(String string) {
        int codePoint;
        int length = string.length();
        StringBuilder builder = new StringBuilder(length);
        block10: for (int i = 0; i < length; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            switch (Character.getType(codePoint)) {
                case 0: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    switch (codePoint) {
                        case 10: {
                            builder.append("\\n");
                            continue block10;
                        }
                        case 13: {
                            builder.append("\\r");
                            continue block10;
                        }
                        case 9: {
                            builder.append("\\t");
                            continue block10;
                        }
                        case 12: {
                            builder.append("\\f");
                            continue block10;
                        }
                        case 8: {
                            builder.append("\\b");
                            continue block10;
                        }
                    }
                    builder.append("\\u").append(String.format("%04x", codePoint).toUpperCase(Locale.US));
                    continue block10;
                }
                default: {
                    builder.append(Character.toChars(codePoint));
                }
            }
        }
        return builder.toString();
    }

    private static String arrayToString(Class<?> cls, Object obj) {
        if (Byte.TYPE == cls) {
            return Strings.byteArrayToString((byte[])obj);
        }
        if (Short.TYPE == cls) {
            return Arrays.toString((short[])obj);
        }
        if (Character.TYPE == cls) {
            return Arrays.toString((char[])obj);
        }
        if (Integer.TYPE == cls) {
            return Arrays.toString((int[])obj);
        }
        if (Long.TYPE == cls) {
            return Arrays.toString((long[])obj);
        }
        if (Float.TYPE == cls) {
            return Arrays.toString((float[])obj);
        }
        if (Double.TYPE == cls) {
            return Arrays.toString((double[])obj);
        }
        if (Boolean.TYPE == cls) {
            return Arrays.toString((boolean[])obj);
        }
        return Strings.arrayToString((Object[])obj);
    }

    private static String byteArrayToString(byte[] bytes) {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(Strings.byteToString(bytes[i]));
        }
        return builder.append(']').toString();
    }

    private static String byteToString(Byte b) {
        if (b == null) {
            return "null";
        }
        return "0x" + String.format("%02x", b).toUpperCase(Locale.US);
    }

    private static String arrayToString(Object[] array) {
        StringBuilder buf = new StringBuilder();
        Strings.arrayToString(array, buf, new HashSet<Object[]>());
        return buf.toString();
    }

    private static void arrayToString(Object[] array, StringBuilder builder, Set<Object[]> seen) {
        if (array == null) {
            builder.append("null");
            return;
        }
        seen.add(array);
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            Object element;
            if (i > 0) {
                builder.append(", ");
            }
            if ((element = array[i]) == null) {
                builder.append("null");
                continue;
            }
            Class<?> elementClass = element.getClass();
            if (elementClass.isArray() && elementClass.getComponentType() == Object.class) {
                Object[] arrayElement = (Object[])element;
                if (seen.contains(arrayElement)) {
                    builder.append("[...]");
                    continue;
                }
                Strings.arrayToString(arrayElement, builder, seen);
                continue;
            }
            builder.append(Strings.toString(element));
        }
        builder.append(']');
        seen.remove(array);
    }

    private Strings() {
        throw new AssertionError((Object)"No instances.");
    }
}

