/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.xlog_android.lib;

import android.os.Looper;
import android.util.Log;
import com.github.promeg.xlog_android.lib.Strings;
import com.promegu.xlog.base.MethodToLog;
import com.taobao.android.dexposed.XC_MethodHook;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public class XLogMethodHook
extends XC_MethodHook {
    private long startTime;
    private Member mMember;
    private MethodToLog mMethodToLog;

    public XLogMethodHook(Member member, MethodToLog methodToLog) {
        this.mMember = member;
        this.mMethodToLog = methodToLog;
    }

    protected void beforeHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
        Class<?>[] parameterTypes = null;
        parameterTypes = this.mMember instanceof Method ? ((Method)this.mMember).getParameterTypes() : ((Constructor)this.mMember).getParameterTypes();
        StringBuilder builder = new StringBuilder("\u21e2 ");
        builder.append(param.method.getName()).append('(');
        for (int i = 0; i < param.args.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            if (this.mMethodToLog != null && this.mMethodToLog.getParameterNames().size() > i) {
                builder.append((String)this.mMethodToLog.getParameterNames().get(i)).append('=');
            } else {
                builder.append(parameterTypes[i].getSimpleName()).append('=');
            }
            builder.append(Strings.toString(param.args[i]));
        }
        builder.append(')');
        if (Looper.myLooper() != Looper.getMainLooper()) {
            builder.append(" [Thread:\"").append(Thread.currentThread().getName()).append("\"]");
        }
        Log.d((String)XLogMethodHook.asTag(this.mMember.getDeclaringClass()), (String)builder.toString());
        this.startTime = System.currentTimeMillis();
    }

    protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
        long lengthMillis = System.currentTimeMillis() - this.startTime;
        StringBuilder builder = new StringBuilder("\u21e0 ").append(param.method.getName()).append(" [").append(lengthMillis).append("ms]");
        if (param.getResult() != null) {
            builder.append(" = ");
            builder.append(Strings.toString(param.getResult()));
        }
        Log.d((String)XLogMethodHook.asTag(this.mMember.getDeclaringClass()), (String)builder.toString());
    }

    private static String asTag(Class<?> cls) {
        if (cls.isAnonymousClass()) {
            return XLogMethodHook.asTag(cls.getEnclosingClass());
        }
        return cls.getSimpleName();
    }
}

