/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.xlog_android.lib;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.util.Log;
import com.github.promeg.xlog_android.lib.MultiDexHelper;
import com.github.promeg.xlog_android.lib.XLogInitializer;
import com.github.promeg.xlog_android.lib.XLogMethodHook;
import com.promegu.xlog.base.MethodToLog;
import com.promegu.xlog.base.XLog;
import com.promegu.xlog.base.XLogSetting;
import com.taobao.android.dexposed.DexposedBridge;
import com.taobao.android.dexposed.XC_MethodHook;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Set;

public class XLogConfig {
    private static final String TAG = "XLogConfig";
    public static final String XLOG_SharedPreferences = "xlog_settings";
    public static final String PREF_CONFIG = "xlog_config";
    public static final int NONE = 0;
    public static final int ANNOTATED = 1;
    public static final int SPECIFIED = 2;
    public static final int ALL = 3;

    private XLogConfig() {
    }

    public static ConfigBuilder newConfigBuilder(Context context) {
        return new ConfigBuilder(context);
    }

    public static void config(XLogInitializer initializer) {
        SharedPreferences sharedPreferences = initializer.getContext().getSharedPreferences(XLOG_SharedPreferences, 0);
        sharedPreferences.edit().putString(PREF_CONFIG, initializer.toString()).commit();
        if (DexposedBridge.canDexposed((Context)initializer.getContext())) {
            XLogConfig.hookAllMethods(initializer.getContext());
        }
    }

    private static void hookAllMethods(Context context) {
        try {
            XLogSetting xLogSetting = MultiDexHelper.getXLogSetting(context, "com.promegu.xlogger");
            Set<Member> methodsToHook = MultiDexHelper.getAllMethodsWithAnnoation(context, XLog.class, xLogSetting);
            if (methodsToHook == null) {
                return;
            }
            for (Member member : methodsToHook) {
                MethodToLog methodToLog = null;
                if (!(member instanceof Method) && !(member instanceof Constructor)) continue;
                for (MethodToLog m : xLogSetting.methodToLogs) {
                    if (m == null || !m.matchMethodOrConstructor(member)) continue;
                    methodToLog = m;
                    break;
                }
                DexposedBridge.hookMethod((Member)member, (XC_MethodHook)new XLogMethodHook(member, methodToLog));
                Log.d((String)TAG, (String)("hooked: " + member.toString()));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ConfigBuilder {
        final Context mContext;
        int mBenchmark = 0;

        private ConfigBuilder(Context context) {
            this.mContext = context.getApplicationContext();
        }

        private ConfigBuilder benchmark(int benchmark) {
            this.mBenchmark = benchmark;
            return this;
        }

        public XLogInitializer build() {
            return new XLogInitializer(this.mContext, this.mBenchmark);
        }
    }
}

