/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.adapter;

import android.app.Activity;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.powyin.scroll.adapter.AdapterDelegate;
import com.powyin.scroll.adapter.PowViewHolder;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class MultipleViewPageAdapter<T>
extends PagerAdapter
implements AdapterDelegate<T> {
    private PowViewHolder[] mHolderInstances;
    private Constructor<? extends PowViewHolder>[] mHolderConstructor;
    private Class[] mHolderGenericDataClass;
    private Activity mActivity;
    private List<T> mDataList = new ArrayList<T>();
    private boolean mEnnableChach = true;
    private PowViewHolder[] mCache = new PowViewHolder[100];

    @SafeVarargs
    public static <T> MultipleViewPageAdapter<T> getByViewHolder(Activity activity, Class<? extends PowViewHolder<? extends T>> ... arrClass) {
        return new MultipleViewPageAdapter<T>(activity, arrClass);
    }

    @SafeVarargs
    public MultipleViewPageAdapter(Activity activity, Class<? extends PowViewHolder<? extends T>> ... viewHolderClass) {
        int i;
        Class[] arrClass = new Class[viewHolderClass.length];
        System.arraycopy(viewHolderClass, 0, arrClass, 0, viewHolderClass.length);
        this.mActivity = activity;
        this.mHolderInstances = new PowViewHolder[arrClass.length];
        this.mHolderGenericDataClass = new Class[arrClass.length];
        this.mHolderConstructor = new Constructor[arrClass.length];
        for (i = 0; i < arrClass.length; ++i) {
            try {
                this.mHolderConstructor[i] = arrClass[i].getConstructor(Activity.class, ViewGroup.class);
                this.mHolderConstructor[i].setAccessible(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i < arrClass.length; ++i) {
            Type genericType;
            Class typeClass = arrClass[i];
            do {
                genericType = typeClass.getGenericSuperclass();
            } while ((typeClass = typeClass.getSuperclass()) != PowViewHolder.class && typeClass != Object.class);
            if (typeClass != PowViewHolder.class || genericType == PowViewHolder.class) {
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u7ee7\u627f\u6cdb\u578bViewHolder");
            }
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type genericClass = paramType.getActualTypeArguments()[0];
            if (genericClass instanceof Class) {
                this.mHolderGenericDataClass[i] = (Class)genericClass;
                continue;
            }
            if (genericClass instanceof ParameterizedType) {
                this.mHolderGenericDataClass[i] = (Class)((ParameterizedType)genericClass).getRawType();
                continue;
            }
            throw new RuntimeException("get genericClass error");
        }
    }

    public Object instantiateItem(ViewGroup container, int position) {
        PowViewHolder target = null;
        T itemData = this.mDataList.get(position);
        if (this.mCache[position] != null) {
            target = this.mCache[position];
            container.addView(target.mItemView);
            target.mData = itemData;
            target.onViewAttachedToWindow();
            return target;
        }
        for (int i = 0; i < this.mHolderInstances.length; ++i) {
            if (itemData == null) {
                throw new RuntimeException("data must not be Null");
            }
            if (!this.mHolderGenericDataClass[i].isAssignableFrom(itemData.getClass())) continue;
            if (this.mHolderInstances[i] == null) {
                try {
                    this.mHolderInstances[i] = this.mHolderConstructor[i].newInstance(this.mActivity, null);
                    this.mHolderInstances[i].mViewHolder = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
            }
            this.mHolderInstances[i].mPosition = position;
            if (!this.mHolderInstances[i].acceptData(itemData)) continue;
            target = this.mHolderInstances[i];
            this.mHolderInstances[i] = null;
            break;
        }
        if (target == null) {
            throw new RuntimeException("can not find holder to load the data");
        }
        if (this.mEnnableChach) {
            this.mCache[position] = target;
        }
        container.addView(target.mItemView);
        target.mData = itemData;
        target.loadData(null, itemData, position);
        target.onViewAttachedToWindow();
        return target;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        PowViewHolder target = (PowViewHolder)object;
        container.removeView(target.mItemView);
        target.onViewDetachedFromWindow();
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        super.setPrimaryItem(container, position, object);
    }

    public float getPageWidth(int position) {
        return super.getPageWidth(position);
    }

    public int getCount() {
        int size = this.mDataList.size();
        if (this.mCache.length < size) {
            PowViewHolder[] rep = new PowViewHolder[size];
            System.arraycopy(this.mCache, 0, rep, 0, this.mCache.length);
            this.mCache = rep;
        }
        return size;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == ((PowViewHolder)object).mItemView;
    }

    @Override
    public List<T> getDataList() {
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(this.mDataList);
        return ret;
    }

    @Override
    public int getDataCount() {
        return this.mDataList.size();
    }

    @Override
    public void loadData(List<T> dataList) {
        this.mDataList.clear();
        if (dataList != null && dataList.size() > 0) {
            this.mDataList.addAll(dataList);
        }
        this.notifyDataSetChanged();
    }

    @Override
    public void addData(int position, T data) {
    }

    @Override
    public void addData(int position, List<T> dataList) {
    }

    @Override
    public void addDataAtLast(List<T> dataList) {
    }

    @Override
    public void addDataAtLast(List<T> dataList, AdapterDelegate.LoadedStatus status, int delayTime) {
    }

    @Override
    public T removeData(int position) {
        return null;
    }

    @Override
    public void removeData(T data) {
    }

    @Override
    public void clearData() {
    }

    @Override
    public void enableLoadMore(boolean enable) {
    }

    @Override
    public void setLoadMoreStatus(AdapterDelegate.LoadedStatus status) {
    }

    @Override
    public void loadMore() {
    }

    @Override
    public void completeLoadMore() {
    }

    @Override
    public void setOnLoadMoreListener(AdapterDelegate.OnLoadMoreListener loadMoreListener) {
    }

    @Override
    public void setHeadView(View view) {
        throw new RuntimeException("not Support");
    }

    @Override
    public void setFootView(View view) {
        throw new RuntimeException("not Support");
    }

    @Override
    public void removeHeadView() {
        throw new RuntimeException("not Support");
    }

    @Override
    public void removeFootView() {
        throw new RuntimeException("not Support");
    }

    @Override
    public void enableEmptyView(boolean show) {
        throw new RuntimeException("not Support");
    }

    @Override
    public void setEmptyView(View view) {
        throw new RuntimeException("not Support");
    }

    @Override
    public void setOnItemClickListener(AdapterDelegate.OnItemClickListener<T> clickListener) {
        throw new RuntimeException("not Support");
    }

    @Override
    public void setOnItemLongClickListener(AdapterDelegate.OnItemLongClickListener<T> clickListener) {
        throw new RuntimeException("not Support");
    }

    public void ennableChach(boolean ennable) {
        this.mEnnableChach = ennable;
    }

    public PowViewHolder<T> getPage(int index) {
        return this.mCache[index];
    }
}

