/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.adapter;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.text.TextPaint;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.powyin.scroll.R;
import com.powyin.scroll.adapter.AdapterDelegate;
import com.powyin.scroll.adapter.PowViewHolder;
import com.powyin.scroll.adapter.RecycleViewHolder;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class MultipleRecycleAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements AdapterDelegate<T> {
    private final int ITYPE_Empty = 272;
    private final int ITYPE_ERROR = 273;
    private final int ITYPE_LOAD = 274;
    private final int ITYPE_HEAD = 275;
    private final int ITYPE_FOOT = 276;
    private PowViewHolder[] mHolderInstances;
    private Constructor<? extends PowViewHolder>[] mHolderConstructor;
    private Class[] mHolderGenericDataClass;
    private Activity mActivity;
    private boolean isMovingEnable = false;
    List<T> mDataList = new ArrayList<T>();
    private RecyclerView mRecyclerView;
    private AdapterDelegate.LoadedStatus mLoadStatus = null;
    private boolean mIsProgressLoadMore = false;
    private long mLoadViewBeginShowTime = -1L;
    private String mLoadCompleteInfo = "load completed";
    private AdapterDelegate.OnLoadMoreListener mOnLoadMoreListener;
    AdapterDelegate.OnItemClickListener<T> mOnItemClickListener;
    AdapterDelegate.OnItemLongClickListener<T> mOnItemLongClickListener;
    private IncludeTypeLoad mLoad;
    private View mSpaceView;
    private View mHeadView;
    private View mFootView;
    private boolean mSpaceEnable = false;
    boolean mHasHead = false;
    private boolean mHasFoot = false;
    private boolean mHasLoad = false;
    private ItemTouchHelper itemTouchHelper = new ItemTouchHelper(new ItemTouchHelper.Callback(){

        public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            PowViewHolder powViewHolder = ((RecycleViewHolder)viewHolder).mPowViewHolder;
            if (powViewHolder != null && powViewHolder.isEnableDragAndDrop()) {
                return 1.makeMovementFlags((int)15, (int)0);
            }
            return 0;
        }

        public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
            PowViewHolder oriViewHolder = ((RecycleViewHolder)viewHolder).mPowViewHolder;
            PowViewHolder tarViewHolder = ((RecycleViewHolder)target).mPowViewHolder;
            if (oriViewHolder == null || tarViewHolder == null || !oriViewHolder.isEnableDragAndDrop() || !tarViewHolder.isEnableDragAndDrop()) {
                return false;
            }
            int ori = viewHolder.getAdapterPosition();
            int tar = target.getAdapterPosition();
            MultipleRecycleAdapter.this.mDataList.set(ori, MultipleRecycleAdapter.this.mDataList.set(tar, MultipleRecycleAdapter.this.mDataList.get(ori)));
            MultipleRecycleAdapter.this.notifyItemMoved(ori, tar);
            return true;
        }

        public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
            int index = viewHolder.getAdapterPosition();
            MultipleRecycleAdapter.this.mDataList.remove(index);
            MultipleRecycleAdapter.this.notifyItemRemoved(index);
        }
    });

    @SafeVarargs
    public static <T> MultipleRecycleAdapter<T> getByViewHolder(Activity activity, Class<? extends PowViewHolder<? extends T>> ... arrClass) {
        return new MultipleRecycleAdapter<T>(activity, arrClass);
    }

    @SafeVarargs
    public MultipleRecycleAdapter(Activity activity, Class<? extends PowViewHolder<? extends T>> ... viewHolderClass) {
        int i;
        Class[] arrClass = new Class[viewHolderClass.length];
        System.arraycopy(viewHolderClass, 0, arrClass, 0, viewHolderClass.length);
        this.mActivity = activity;
        this.mHolderInstances = new PowViewHolder[arrClass.length];
        this.mHolderGenericDataClass = new Class[arrClass.length];
        this.mHolderConstructor = new Constructor[arrClass.length];
        for (i = 0; i < arrClass.length; ++i) {
            try {
                this.mHolderConstructor[i] = arrClass[i].getConstructor(Activity.class, ViewGroup.class);
                this.mHolderConstructor[i].setAccessible(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i < arrClass.length; ++i) {
            Type genericType;
            Class typeClass = arrClass[i];
            do {
                genericType = typeClass.getGenericSuperclass();
            } while ((typeClass = typeClass.getSuperclass()) != PowViewHolder.class && typeClass != Object.class);
            if (typeClass != PowViewHolder.class || genericType == PowViewHolder.class) {
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u7ee7\u627f\u6cdb\u578bViewHolder");
            }
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type genericClass = paramType.getActualTypeArguments()[0];
            if (genericClass instanceof Class) {
                this.mHolderGenericDataClass[i] = (Class)genericClass;
            } else if (genericClass instanceof ParameterizedType) {
                this.mHolderGenericDataClass[i] = (Class)((ParameterizedType)genericClass).getRawType();
            } else {
                throw new RuntimeException("get genericClass error");
            }
            try {
                this.mHolderInstances[i] = this.mHolderConstructor[i].newInstance(this.mActivity, null);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        for (PowViewHolder holder : this.mHolderInstances) {
            this.isMovingEnable |= holder.isEnableDragAndDrop();
            if (this.isMovingEnable) break;
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        PowViewHolder holder;
        switch (viewType) {
            case 272: {
                FrameLayout contain = this.getSpaceContain(parent);
                return new IncludeTypeEmpty(contain);
            }
            case 273: {
                return new IncludeTypeError(parent);
            }
            case 274: {
                return new IncludeTypeLoad(parent);
            }
            case 275: {
                return new IncludeTypeHead(parent);
            }
            case 276: {
                return new IncludeTypeFoot(parent);
            }
        }
        try {
            holder = this.mHolderConstructor[viewType].newInstance(this.mActivity, parent);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return holder.mViewHolder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int oriPosition) {
        switch (holder.getItemViewType()) {
            case 272: {
                IncludeTypeEmpty empty = (IncludeTypeEmpty)holder;
                empty.loadView();
                break;
            }
            case 273: {
                int position = this.mHasHead ? oriPosition - 1 : oriPosition;
                IncludeTypeError error = (IncludeTypeError)holder;
                error.loadData(this.mDataList.get(position));
                break;
            }
            case 274: {
                IncludeTypeLoad load;
                this.mLoad = load = (IncludeTypeLoad)holder;
                load.progressBar.ensureLoading();
                break;
            }
            case 275: {
                IncludeTypeHead head = (IncludeTypeHead)holder;
                head.loadView();
                break;
            }
            case 276: {
                IncludeTypeFoot foot = (IncludeTypeFoot)holder;
                foot.loadView();
                break;
            }
            default: {
                int position = this.mHasHead ? oriPosition - 1 : oriPosition;
                Object itemData = position < this.mDataList.size() ? (Object)this.mDataList.get(position) : null;
                PowViewHolder powViewHolder = ((RecycleViewHolder)holder).mPowViewHolder;
                powViewHolder.mData = itemData;
                powViewHolder.mMultipleAdapter = this;
                if (this.mOnItemClickListener != null) {
                    powViewHolder.registerAutoItemClick();
                }
                if (this.mOnItemLongClickListener != null) {
                    powViewHolder.registerAutoItemLongClick();
                }
                powViewHolder.loadData(this, itemData, position);
            }
        }
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        switch (holder.getItemViewType()) {
            case 274: {
                IncludeTypeLoad load = (IncludeTypeLoad)holder;
                load.progressBar.ensureStopAnimation();
            }
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
        if (this.isMovingEnable) {
            this.itemTouchHelper.attachToRecyclerView(this.mRecyclerView);
        }
    }

    public int getItemCount() {
        return this.mSpaceEnable ? 1 : this.mDataList.size() + (this.mHasHead ? 1 : 0) + (this.mHasFoot ? 1 : 0) + (this.mHasLoad ? 1 : 0);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        ((RecycleViewHolder)holder).onViewAttachedToWindow();
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        ((RecycleViewHolder)holder).onViewDetachedFromWindow();
    }

    public long getItemId(int position) {
        if (this.mSpaceEnable) {
            return 272L;
        }
        if (this.mHasHead) {
            if (position == 0) {
                return 275L;
            }
            --position;
        }
        if (position < this.mDataList.size()) {
            T data = this.mDataList.get(position);
            return data == null ? 0L : (long)data.hashCode();
        }
        if (this.mHasFoot && (position -= this.mDataList.size()) == 0) {
            return 276L;
        }
        return 274L;
    }

    public int getItemViewType(int position) {
        if (this.mSpaceEnable) {
            return 272;
        }
        if (this.mHasHead) {
            if (position == 0) {
                return 275;
            }
            --position;
        }
        if (position < this.mDataList.size()) {
            for (int i = 0; i < this.mHolderInstances.length; ++i) {
                T itemData = this.mDataList.get(position);
                if (itemData == null || !this.mHolderGenericDataClass[i].isAssignableFrom(itemData.getClass()) || !this.mHolderInstances[i].acceptData(itemData)) continue;
                return i;
            }
            return 273;
        }
        position -= this.mDataList.size();
        if (this.mHasFoot) {
            if (position == 0) {
                return 276;
            }
            --position;
        }
        if (position == 0 && this.mHasLoad) {
            return 274;
        }
        throw new RuntimeException(" what happen ");
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mRecyclerView = null;
    }

    @Override
    public List<T> getDataList() {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.addAll(this.mDataList);
        return arrayList;
    }

    @Override
    public int getDataCount() {
        return this.mDataList.size();
    }

    @Override
    public void loadData(List<T> dataList) {
        this.mDataList.clear();
        this.mDataList.addAll(dataList);
        this.notifyDataSetChanged();
    }

    @Override
    public void addData(int position, T data) {
        if (data == null) {
            return;
        }
        this.mDataList.add(position, data);
        this.notifyItemInserted(this.mHasHead ? position + 1 : position);
    }

    @Override
    public void addData(int position, List<T> dataList) {
        if (dataList == null) {
            return;
        }
        this.mDataList.addAll(position, dataList);
        this.notifyDataSetChanged();
    }

    @Override
    public void addDataAtLast(List<T> dataList) {
        this.addDataAtLast(dataList, null, 0);
    }

    @Override
    public void addDataAtLast(final List<T> dataList, final AdapterDelegate.LoadedStatus status, int delayTime) {
        if (delayTime <= 0) {
            if (dataList != null && dataList.size() > 0) {
                this.mDataList.addAll(this.mDataList.size(), dataList);
                this.notifyItemRangeInserted(this.mDataList.size(), dataList.size());
            }
            this.setLoadMoreStatus(status);
        } else {
            this.mActivity.getWindow().getDecorView().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (dataList != null && dataList.size() > 0) {
                        MultipleRecycleAdapter.this.mDataList.addAll(MultipleRecycleAdapter.this.mDataList.size(), dataList);
                        MultipleRecycleAdapter.this.notifyDataSetChanged();
                    }
                    MultipleRecycleAdapter.this.setLoadMoreStatus(status);
                }
            }, (long)delayTime);
        }
    }

    @Override
    public T removeData(int position) {
        T ret = this.mDataList.remove(position);
        this.notifyItemRemoved(this.mHasHead ? position + 1 : position);
        return ret;
    }

    @Override
    public void removeData(T data) {
        int index = this.mDataList.indexOf(data);
        if (index >= 0) {
            this.removeData(index);
        }
    }

    @Override
    public void clearData() {
        if (this.mDataList.size() != 0) {
            this.mDataList.clear();
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void enableLoadMore(boolean show) {
        if (this.mHasLoad != show) {
            this.mHasLoad = show;
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setLoadMoreStatus(AdapterDelegate.LoadedStatus status) {
        if (status == null) {
            return;
        }
        this.mLoadStatus = status;
        this.mIsProgressLoadMore = false;
        if (this.mLoad != null) {
            this.mLoad.progressBar.invalidate();
        }
    }

    @Override
    public void loadMore() {
        if (this.mOnLoadMoreListener != null) {
            this.mIsProgressLoadMore = true;
            this.mOnLoadMoreListener.onLoadMore();
        }
    }

    @Override
    public void completeLoadMore() {
        this.mIsProgressLoadMore = false;
        if (this.mLoad != null) {
            this.mLoad.progressBar.ensureLoading();
        }
    }

    @Override
    public void setOnLoadMoreListener(AdapterDelegate.OnLoadMoreListener loadMoreListener) {
        this.mOnLoadMoreListener = loadMoreListener;
    }

    @Override
    public void setOnItemClickListener(AdapterDelegate.OnItemClickListener<T> clickListener) {
        this.mOnItemClickListener = clickListener;
    }

    @Override
    public void setOnItemLongClickListener(AdapterDelegate.OnItemLongClickListener<T> longClickListener) {
        this.mOnItemLongClickListener = longClickListener;
    }

    @Override
    public void setHeadView(View view) {
        if (view == null) {
            return;
        }
        this.mHasHead = true;
        this.mHeadView = view;
        this.notifyDataSetChanged();
    }

    @Override
    public void removeHeadView() {
        if (!this.mHasHead) {
            return;
        }
        this.mHasHead = false;
        this.mHeadView = null;
        this.notifyDataSetChanged();
    }

    @Override
    public void setFootView(View view) {
        if (view == null) {
            return;
        }
        this.mHasFoot = true;
        this.mFootView = view;
        this.notifyDataSetChanged();
    }

    @Override
    public void removeFootView() {
        if (!this.mHasFoot) {
            return;
        }
        this.mHasFoot = false;
        this.mFootView = null;
        this.notifyDataSetChanged();
    }

    @Override
    public void enableEmptyView(boolean show) {
        if (this.mSpaceEnable != show) {
            this.mSpaceEnable = show;
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setEmptyView(View view) {
        if (view == null) {
            return;
        }
        if (this.mSpaceView != view) {
            this.mSpaceView = view;
            this.notifyDataSetChanged();
        }
    }

    private FrameLayout getSpaceContain(ViewGroup viewGroup) {
        FrameLayout frameLayout = new FrameLayout(viewGroup.getContext()){

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)heightMeasureSpec), (int)0x40000000);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        };
        TextView textView = new TextView(viewGroup.getContext());
        textView.setText((CharSequence)"space");
        textView.setTextColor(-16777216);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
        RecyclerView.LayoutParams params = new RecyclerView.LayoutParams(-1, -1);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        return frameLayout;
    }

    class LoadProgressBar
    extends View {
        boolean mAttached;
        ValueAnimator animator;
        Paint circlePaint;
        TextPaint textPaint;
        int canvasWei;
        int canvasHei;
        float canvasTextX;
        float canvasTextY;
        int ballCount;
        float divide;

        public LoadProgressBar(Context context) {
            super(context);
            this.mAttached = false;
            this.ballCount = 13;
            this.circlePaint = new Paint();
            this.circlePaint.setColor(0x77000000);
            this.circlePaint.setStrokeWidth(4.0f);
            this.textPaint = new TextPaint();
            this.textPaint.setColor(-1711276033);
            float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
            int target = (int)(13.0f * fontScale + 0.5f);
            this.textPaint.setTextSize((float)target);
            this.textPaint.setAntiAlias(true);
            this.textPaint.setStrokeWidth(1.0f);
        }

        public void addOnLayoutChangeListener(View.OnLayoutChangeListener listener) {
            super.addOnLayoutChangeListener(listener);
        }

        private void ensureAnimation() {
            if (!this.mAttached || MultipleRecycleAdapter.this.mLoadViewBeginShowTime == -1L || MultipleRecycleAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.NO_MORE || MultipleRecycleAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.ERROR) {
                if (this.animator != null) {
                    this.animator.cancel();
                    this.animator = null;
                }
                this.invalidate();
                return;
            }
            if (this.animator != null && this.animator.isStarted()) {
                return;
            }
            this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.animator.setDuration(2500L);
            this.animator.setRepeatCount(-1);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    if (valueAnimator != LoadProgressBar.this.animator) {
                        valueAnimator.cancel();
                        return;
                    }
                    if (!LoadProgressBar.this.mAttached || MultipleRecycleAdapter.this.mLoadViewBeginShowTime == -1L || MultipleRecycleAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.NO_MORE || MultipleRecycleAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.ERROR) {
                        if (LoadProgressBar.this.animator != null) {
                            LoadProgressBar.this.animator.cancel();
                            LoadProgressBar.this.animator = null;
                        }
                        LoadProgressBar.this.invalidate();
                        return;
                    }
                    LoadProgressBar.this.divide = 10.0f * (float)(System.currentTimeMillis() % 3200L - 1600L) / 3200.0f;
                    LoadProgressBar.this.invalidate();
                }
            });
            this.animator.start();
        }

        private void ensureStopAnimation() {
            if (this.animator != null) {
                this.animator.cancel();
                this.animator = null;
            }
        }

        private float getSplit(float value) {
            int positive = value >= 0.0f ? 1 : -1;
            if ((value = Math.abs(value)) <= 1.0f) {
                return value * (float)positive;
            }
            return (float)Math.pow(value, 2.0) * (float)positive;
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mAttached = true;
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.mAttached = false;
            this.ensureStopAnimation();
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            float scale = this.getContext().getResources().getDisplayMetrics().density;
            int target = (int)(40.0f * scale + 0.5f);
            this.setMeasuredDimension(this.getMeasuredWidth(), target);
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            if (MultipleRecycleAdapter.this.mLoadViewBeginShowTime == -1L) {
                return;
            }
            int timeBe = (int)(System.currentTimeMillis() - MultipleRecycleAdapter.this.mLoadViewBeginShowTime);
            float alpha = (float)timeBe / 2000.0f;
            alpha = alpha > 1.0f ? 1.0f : alpha;
            alpha = alpha < 0.0f ? 1.0f : alpha;
            int colorAlpha = (int)(alpha * 200.0f);
            this.circlePaint.setAlpha(colorAlpha);
            if (MultipleRecycleAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.NO_MORE) {
                canvas.drawText(MultipleRecycleAdapter.this.mLoadCompleteInfo, this.canvasTextX, this.canvasTextY, (Paint)this.textPaint);
                canvas.drawLine(20.0f, (float)(this.canvasHei / 2), this.canvasTextX - 20.0f, (float)(this.canvasHei / 2), (Paint)this.textPaint);
                canvas.drawLine((float)this.canvasWei - this.canvasTextX + 20.0f, (float)(this.canvasHei / 2), (float)(this.canvasWei - 20), (float)(this.canvasHei / 2), (Paint)this.textPaint);
            }
            if (MultipleRecycleAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.ERROR) {
                canvas.drawText("error", this.canvasTextX, this.canvasTextY, (Paint)this.textPaint);
                canvas.drawLine(20.0f, (float)(this.canvasHei / 2), this.canvasTextX - 20.0f, (float)(this.canvasHei / 2), (Paint)this.textPaint);
                canvas.drawLine((float)this.canvasWei - this.canvasTextX + 20.0f, (float)(this.canvasHei / 2), (float)(this.canvasWei - 20), (float)(this.canvasHei / 2), (Paint)this.textPaint);
            }
            if (MultipleRecycleAdapter.this.mLoadStatus == null) {
                for (int i = 0; i < this.ballCount; ++i) {
                    float wei = 5.0f * (1.0f * (float)i / (float)this.ballCount - 0.5f) + this.divide;
                    wei = (float)(this.canvasWei / 2) + this.getSplit(wei) * (float)this.canvasWei * 0.08f;
                    canvas.drawCircle(wei, (float)(this.canvasHei / 2 + 6), 8.0f, this.circlePaint);
                }
            }
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            super.onLayout(changed, left, top, right, bottom);
            this.canvasHei = this.getHeight();
            this.canvasWei = this.getWidth();
            this.canvasTextX = (float)(this.canvasWei / 2) - this.textPaint.measureText(MultipleRecycleAdapter.this.mLoadCompleteInfo) / 2.0f;
            this.canvasTextY = (float)(this.canvasHei / 2) + this.textPaint.getTextSize() / 2.55f;
            if (bottom < ((ViewGroup)this.getParent()).getHeight()) {
                MultipleRecycleAdapter.this.mLoadViewBeginShowTime = -1L;
            } else {
                MultipleRecycleAdapter.this.mLoadViewBeginShowTime = System.currentTimeMillis();
                this.ensureAnimation();
            }
            this.ensureLoading();
        }

        void ensureLoading() {
            if (MultipleRecycleAdapter.this.mOnLoadMoreListener != null && MultipleRecycleAdapter.this.mLoadStatus == null && !MultipleRecycleAdapter.this.mIsProgressLoadMore && this.mAttached && MultipleRecycleAdapter.this.mLoadViewBeginShowTime != -1L) {
                MultipleRecycleAdapter.this.mIsProgressLoadMore = true;
                MultipleRecycleAdapter.this.mOnLoadMoreListener.onLoadMore();
            }
        }
    }

    private class IncludeTypeFoot
    extends RecycleViewHolder<Object> {
        FrameLayout frameLayout;

        IncludeTypeFoot(ViewGroup viewGroup) {
            super(MultipleRecycleAdapter.this.mActivity.getLayoutInflater().inflate(R.layout.powyin_scroll_multiple_adapter_foot, viewGroup, false), null);
            this.frameLayout = (FrameLayout)this.itemView;
        }

        void loadView() {
            if (MultipleRecycleAdapter.this.mFootView != null) {
                ViewParent parent = MultipleRecycleAdapter.this.mFootView.getParent();
                if (parent != null) {
                    ((ViewGroup)parent).removeView(MultipleRecycleAdapter.this.mFootView);
                }
                this.frameLayout.removeAllViews();
                this.frameLayout.addView(MultipleRecycleAdapter.this.mFootView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            }
        }
    }

    private class IncludeTypeHead
    extends RecycleViewHolder<Object> {
        FrameLayout frameLayout;

        IncludeTypeHead(ViewGroup viewGroup) {
            super(MultipleRecycleAdapter.this.mActivity.getLayoutInflater().inflate(R.layout.powyin_scroll_multiple_adapter_head, viewGroup, false), null);
            this.frameLayout = (FrameLayout)this.itemView;
        }

        void loadView() {
            if (MultipleRecycleAdapter.this.mHeadView != null) {
                ViewParent parent = MultipleRecycleAdapter.this.mHeadView.getParent();
                if (parent != null) {
                    ((ViewGroup)parent).removeView(MultipleRecycleAdapter.this.mHeadView);
                }
                this.frameLayout.removeAllViews();
                this.frameLayout.addView(MultipleRecycleAdapter.this.mHeadView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            }
        }
    }

    private class IncludeTypeLoad
    extends RecycleViewHolder<Object> {
        LoadProgressBar progressBar;

        IncludeTypeLoad(ViewGroup viewGroup) {
            super(new LoadProgressBar((Context)MultipleRecycleAdapter.this.mActivity), null);
            this.progressBar = (LoadProgressBar)this.itemView;
        }
    }

    private class IncludeTypeError
    extends RecycleViewHolder<Object> {
        TextView errorInfo;

        IncludeTypeError(ViewGroup viewGroup) {
            super(MultipleRecycleAdapter.this.mActivity.getLayoutInflater().inflate(R.layout.powyin_scroll_multiple_adapter_err, viewGroup, false), null);
            this.errorInfo = (TextView)this.itemView.findViewById(R.id.powyin_scroll_err_text);
        }

        private void loadData(T data) {
            this.errorInfo.setText((CharSequence)(data == null ? " you has one empty data inside " : data.toString()));
        }
    }

    private class IncludeTypeEmpty
    extends RecycleViewHolder<Object> {
        FrameLayout mainView;

        IncludeTypeEmpty(FrameLayout viewGroup) {
            super((View)viewGroup, null);
            this.mainView = viewGroup;
        }

        void loadView() {
            if (MultipleRecycleAdapter.this.mSpaceView != null) {
                ViewParent parent = MultipleRecycleAdapter.this.mSpaceView.getParent();
                if (parent != null) {
                    ((ViewGroup)parent).removeView(MultipleRecycleAdapter.this.mSpaceView);
                }
                this.mainView.removeAllViews();
                this.mainView.addView(MultipleRecycleAdapter.this.mSpaceView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }
        }
    }
}

