/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.ListView;
import android.widget.ScrollView;
import com.powyin.scroll.R;
import com.powyin.scroll.widget.ISwipe;
import com.powyin.scroll.widget.SwipeControl;
import com.powyin.scroll.widget.SwipeControlStyleNormal;

public class SwipeRefresh
extends ViewGroup
implements NestedScrollingParent,
ISwipe {
    private int mTouchSlop;
    private final NestedScrollingParentHelper mParentHelper;
    private boolean mNestedScrollInProgress = false;
    private int mActivePointerId = -1;
    private float mDragBeginY;
    private float mDragBeginDirect;
    private float mDragLastY;
    private boolean mIsTouchEventMode = false;
    private boolean mPreScroll;
    private boolean mDraggedDispatch;
    private boolean mDraggedIntercept;
    private SwipeControl mSwipeControl;
    private ValueAnimator animationReBackToRefreshing;
    private ValueAnimator animationReBackToTop;
    private boolean mRefreshStatusContinueRunning = false;
    private ISwipe.FreshStatus mFreshStatus = ISwipe.FreshStatus.CONTINUE;
    private boolean mLoadedStatusContinueRunning = false;
    private ISwipe.LoadedStatus mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
    private SwipeControl.SwipeModel mModel = SwipeControl.SwipeModel.SWIPE_BOTH;
    private ISwipe.OnRefreshListener mOnRefreshListener;
    private ISwipe.OnStatusListener mOnStatusListener;
    private View mViewTop;
    private View mViewBottom;
    private View mTargetView;
    private int contentScroll;
    private int overScrollTop;
    private int overScrollBottom;

    public SwipeRefresh(Context context) {
        this(context, null);
    }

    public SwipeRefresh(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeRefresh(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeRefresh);
            int modelIndex = a.getInt(R.styleable.SwipeRefresh_fresh_model, -1);
            if (modelIndex >= 0 && modelIndex < SwipeControl.SwipeModel.values().length) {
                this.mModel = SwipeControl.SwipeModel.values()[modelIndex];
            }
            a.recycle();
        }
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.initSwipeControl();
    }

    private void ensureTarget() {
        if (this.mTargetView == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child == this.mViewTop || child == this.mViewBottom) continue;
                this.mTargetView = child;
            }
            this.mTargetView.getViewTreeObserver().addOnScrollChangedListener(new ViewTreeObserver.OnScrollChangedListener(){

                public void onScrollChanged() {
                    if (!(SwipeRefresh.this.mNestedScrollInProgress || SwipeRefresh.this.mLoadedStatusContinueRunning || SwipeRefresh.this.mDraggedDispatch || SwipeRefresh.this.mDraggedIntercept || SwipeRefresh.this.mOnRefreshListener == null || SwipeRefresh.this.canChildScrollUp() || !SwipeRefresh.this.canChildScrollDown())) {
                        SwipeRefresh.this.mLoadedStatusContinueRunning = true;
                        SwipeRefresh.this.mOnRefreshListener.onLoading(false);
                    }
                }
            });
        }
    }

    private void initSwipeControl() {
        this.mSwipeControl = new SwipeControlStyleNormal(this.getContext());
        this.mViewTop = this.mSwipeControl.getSwipeHead();
        this.mViewBottom = this.mSwipeControl.getSwipeFoot();
        this.addView(this.mViewTop, 0);
        this.addView(this.mViewBottom, this.getChildCount());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthTarget = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightTarget = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidMeasure = View.MeasureSpec.makeMeasureSpec((int)widthTarget, (int)0x40000000);
        int spHei = View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)Integer.MIN_VALUE);
        int targetHei = heightTarget;
        System.out.println(":                " + widthTarget + "          " + heightTarget);
        block4: for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || this.mViewTop == child || this.mViewBottom == child) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            switch (lp.height) {
                case -2: {
                    child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)0));
                    targetHei = child.getMeasuredHeight();
                    continue block4;
                }
                case -1: {
                    child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)0x40000000));
                    targetHei = child.getMeasuredHeight();
                    continue block4;
                }
                default: {
                    child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000));
                    targetHei = child.getMeasuredHeight();
                }
            }
        }
        if (this.mViewTop != null) {
            this.mViewTop.measure(childWidMeasure, spHei);
        }
        if (this.mViewBottom != null) {
            this.mViewBottom.measure(childWidMeasure, spHei);
        }
        System.out.println(":     XXXXX           " + widthTarget + "          " + targetHei);
        this.setMeasuredDimension(widthTarget, targetHei);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.ensureTarget();
        if (this.getChildCount() > 3) {
            throw new RuntimeException("can not holder only one View");
        }
        this.contentScroll = 0;
        this.overScrollTop = this.mViewTop.getMeasuredHeight();
        this.overScrollBottom = this.mViewBottom.getMeasuredHeight();
        this.mViewTop.layout(left, -this.mViewTop.getMeasuredHeight(), right, 0);
        System.out.println("            " + this.mTargetView);
        this.mTargetView.layout(0, 0, right - left, bottom - top);
        this.mViewBottom.layout(0, bottom - top, right - left, bottom - top + this.overScrollBottom);
        if (this.mModel == SwipeControl.SwipeModel.SWIPE_NONE || this.mModel == SwipeControl.SwipeModel.SWIPE_ONLY_LOADINN) {
            this.overScrollTop = 0;
        }
        if (this.mModel == SwipeControl.SwipeModel.SWIPE_NONE || this.mModel == SwipeControl.SwipeModel.SWIPE_ONLY_REFRESH) {
            this.overScrollBottom = 0;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.mDraggedIntercept = false;
            this.mPreScroll = false;
            this.mDraggedDispatch = false;
            this.mActivePointerId = ev.getPointerId(0);
            this.mDragBeginY = (int)ev.getY();
            this.mDragBeginDirect = 0.0f;
            this.mIsTouchEventMode = true;
            this.mDragLastY = this.mDragBeginY;
        }
        if (ev.getAction() == 1 || ev.getAction() == 3) {
            this.mIsTouchEventMode = false;
        }
        if (this.mNestedScrollInProgress) {
            return super.dispatchTouchEvent(ev);
        }
        if (ev.getAction() == 0 && this.getScrollY() != 0) {
            this.mPreScroll = true;
        }
        if (this.mPreScroll) {
            int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
            switch (action) {
                case 0: {
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                    this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    break;
                }
                case 5: {
                    int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                    this.mActivePointerId = ev.getPointerId(pointerIndex);
                    this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    break;
                }
                case 2: {
                    float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    float yDiff = this.mDragBeginY - y;
                    if (Math.abs(yDiff) > (float)(this.mTouchSlop / 2) && !this.mDraggedDispatch) {
                        this.mDraggedDispatch = true;
                        this.mDragLastY = y;
                    }
                    if (!this.mDraggedDispatch) break;
                    this.offSetScroll((int)(this.mDragLastY - y), true);
                    if (this.getScrollY() == 0) {
                        this.mPreScroll = false;
                    }
                    this.mDragLastY = y;
                    return true;
                }
                case 6: {
                    this.onSecondaryPointerUp(ev);
                }
            }
        }
        if ((ev.getAction() == 1 || ev.getAction() == 3) && (this.tryBackToRefreshing() || this.tryBackToFreshFinish() || this.mDraggedDispatch || this.mDraggedIntercept)) {
            ev.setAction(3);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.ensureTarget();
        if (this.mNestedScrollInProgress || !this.isEnabled() || this.canChildScrollDown() && this.canChildScrollUp()) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 5: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 2: {
                float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                float yDiff = this.mDragBeginY - y;
                if (!this.isSameDirection(this.mDragBeginDirect, -yDiff)) {
                    this.mDragBeginDirect = -yDiff;
                    this.mDragBeginY = y;
                    return false;
                }
                if (!(Math.abs(yDiff) > (float)this.mTouchSlop) || this.mDraggedIntercept || !(yDiff > 0.0f && !this.canChildScrollUp()) && (!(yDiff < 0.0f) || this.canChildScrollDown())) break;
                this.mDraggedIntercept = true;
                this.mDragLastY = y;
                ViewParent parent = this.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mDraggedIntercept;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int pointerIndex;
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                this.mDragLastY = (int)ev.getY();
                break;
            }
            case 5: {
                pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 2: {
                float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                int deltaY = (int)this.mDragBeginY - (int)y;
                if (!this.mDraggedIntercept && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mDraggedIntercept = true;
                }
                if (!this.mDraggedIntercept) break;
                this.offSetScroll((int)(this.mDragLastY - y), false);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
        if (pointerIndex >= 0) {
            this.mDragLastY = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
        }
        return true;
    }

    private boolean isSameDirection(float arg1, float arg2) {
        return arg1 == 0.0f || arg1 > 0.0f && arg2 > 0.0f || arg1 < 0.0f && arg2 < 0.0f;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mDragLastY = (int)ev.getY(newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
    }

    private boolean canChildScrollDown() {
        this.ensureTarget();
        return ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1);
    }

    private boolean canChildScrollUp() {
        this.ensureTarget();
        return ViewCompat.canScrollVertically((View)this.mTargetView, (int)1);
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
        this.ensureTarget();
        if (this.mTargetView == null || this.mTargetView instanceof NestedScrollingChild) {
            super.requestDisallowInterceptTouchEvent(b);
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.mNestedScrollInProgress = true;
        this.stopAllScroll();
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta;
        consumed[1] = delta = this.offSetScroll(dy, true);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        if (!this.tryBackToRefreshing()) {
            this.tryBackToFreshFinish();
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.offSetScroll(dyUnconsumed, false);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.getScrollY() != 0;
    }

    private int offSetScroll(int deltaOriginY, boolean pre) {
        int deltaY = deltaOriginY;
        if (deltaOriginY == 0) {
            return 0;
        }
        int middleHei = -this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeControl.getOverScrollHei() : 0;
        int currentScrollY = this.getScrollY();
        if (deltaOriginY < 0 && currentScrollY < middleHei) {
            deltaY = (int)((double)deltaY * Math.pow((float)(this.mSwipeControl.getOverScrollHei() - (middleHei - currentScrollY)) * 1.0f / (float)this.mSwipeControl.getOverScrollHei(), 2.0));
        }
        if (currentScrollY != 0 && currentScrollY != this.contentScroll || !pre) {
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, this.overScrollBottom);
            willTo = Math.max(willTo, -this.overScrollTop);
            if (currentScrollY > 0 && willTo < 0 || currentScrollY < 0 && willTo > 0) {
                willTo = 0;
            }
            if (currentScrollY > this.contentScroll && willTo < this.contentScroll || currentScrollY < this.contentScroll && willTo > this.contentScroll) {
                willTo = this.contentScroll;
            }
            if (this.mDragBeginDirect > 0.0f && willTo > this.contentScroll) {
                willTo = this.contentScroll;
            }
            if (this.mDragBeginDirect < 0.0f && willTo < 0) {
                willTo = 0;
            }
            if (willTo > 0 && !this.canChildScrollDown()) {
                willTo = 0;
            }
            if (willTo == currentScrollY) {
                return deltaOriginY;
            }
            this.scrollTo(0, willTo);
            if (!(0 <= willTo || willTo <= middleHei || this.mFreshStatus != ISwipe.FreshStatus.ERROR && this.mFreshStatus != ISwipe.FreshStatus.ERROR_NET && this.mFreshStatus != ISwipe.FreshStatus.SUCCESS || this.mRefreshStatusContinueRunning)) {
                this.mFreshStatus = ISwipe.FreshStatus.CONTINUE;
                if (this.mOnStatusListener != null) {
                    this.mOnStatusListener.onFreshStatue(this.mFreshStatus);
                }
            }
            if (0 > willTo) {
                int swipeViewVisibilityHei = 0 - willTo;
                switch (this.mFreshStatus) {
                    case CONTINUE: {
                        if (this.mRefreshStatusContinueRunning) {
                            this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_LOADING, swipeViewVisibilityHei, this.mViewTop.getHeight());
                            break;
                        }
                        if (willTo < middleHei) {
                            this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_OVER, swipeViewVisibilityHei, this.mViewTop.getHeight());
                            break;
                        }
                        this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_TOAST, swipeViewVisibilityHei, this.mViewTop.getHeight());
                        break;
                    }
                    case SUCCESS: {
                        this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, swipeViewVisibilityHei, this.mViewTop.getHeight());
                        break;
                    }
                    case ERROR: {
                        this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR, swipeViewVisibilityHei, this.mViewTop.getHeight());
                        break;
                    }
                    case ERROR_NET: {
                        this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR_NET, swipeViewVisibilityHei, this.mViewTop.getHeight());
                    }
                }
            }
            if (willTo > this.contentScroll && !this.mLoadedStatusContinueRunning) {
                this.mLoadedStatusContinueRunning = true;
                if (this.mOnRefreshListener != null) {
                    this.mOnRefreshListener.onLoading(true);
                }
            }
            if (willTo > this.contentScroll) {
                if (this.mLoadedStatus == ISwipe.LoadedStatus.NO_MORE) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_LOAD_NO_MORE, willTo - this.contentScroll, this.mViewBottom.getHeight());
                } else if (this.mLoadedStatus == ISwipe.LoadedStatus.ERROR) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_LOAD_ERROR, willTo - this.contentScroll, this.mViewBottom.getHeight());
                } else if (this.mLoadedStatus == ISwipe.LoadedStatus.CONTINUE) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_LOAD_LOADING, willTo - this.contentScroll, this.mViewBottom.getHeight());
                }
            }
            return deltaOriginY;
        }
        return 0;
    }

    private boolean tryBackToRefreshing() {
        boolean isOverProgress;
        if (this.mIsTouchEventMode || this.mFreshStatus == ISwipe.FreshStatus.SUCCESS || this.mFreshStatus == ISwipe.FreshStatus.ERROR || this.mFreshStatus == ISwipe.FreshStatus.ERROR_NET) {
            return false;
        }
        int scrollY = this.getScrollY();
        int middleHei = this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeControl.getOverScrollHei() : 0;
        boolean bl = isOverProgress = scrollY < middleHei;
        if (isOverProgress) {
            this.stopAllScroll();
            this.animationReBackToRefreshing = ValueAnimator.ofInt((int[])new int[]{scrollY, middleHei});
            this.animationReBackToRefreshing.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (value > SwipeRefresh.this.getScrollY()) {
                        SwipeRefresh.this.scrollTo(0, value);
                    }
                }
            });
            this.animationReBackToRefreshing.addListener(new Animator.AnimatorListener(){
                boolean isCancel = false;

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        switch (SwipeRefresh.this.mFreshStatus) {
                            case CONTINUE: {
                                SwipeRefresh.this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_LOADING, SwipeRefresh.this.mViewTop.getHeight(), SwipeRefresh.this.mViewTop.getHeight());
                            }
                        }
                        if (!SwipeRefresh.this.mRefreshStatusContinueRunning) {
                            SwipeRefresh.this.mRefreshStatusContinueRunning = true;
                            if (SwipeRefresh.this.mOnRefreshListener != null) {
                                SwipeRefresh.this.mOnRefreshListener.onRefresh();
                            }
                        }
                    }
                    this.isCancel = true;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.animationReBackToRefreshing.setDuration((long)Math.abs(550 * (middleHei - scrollY) / this.mViewTop.getHeight()));
            this.animationReBackToRefreshing.start();
        }
        return isOverProgress;
    }

    private boolean tryBackToFreshFinish() {
        int middleHei;
        if (this.mIsTouchEventMode) {
            return false;
        }
        int scrollY = this.getScrollY();
        int n = middleHei = this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeControl.getOverScrollHei() : 0;
        if (this.mFreshStatus == ISwipe.FreshStatus.CONTINUE && scrollY == middleHei) {
            return false;
        }
        if (scrollY < 0) {
            this.stopAllScroll();
            this.animationReBackToTop = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
            this.animationReBackToTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    SwipeRefresh.this.scrollTo(0, value);
                }
            });
            this.animationReBackToTop.addListener(new Animator.AnimatorListener(){
                boolean isCancel;

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        SwipeRefresh.this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_TOAST, 0, SwipeRefresh.this.mViewTop.getHeight());
                    }
                    this.isCancel = true;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            if (scrollY == middleHei) {
                this.animationReBackToTop.setDuration((long)Math.abs(550 * (0 - scrollY) / this.mViewTop.getHeight()));
                this.animationReBackToTop.setStartDelay(650L);
            } else {
                this.animationReBackToTop.setDuration(320L);
            }
            this.animationReBackToTop.start();
            return true;
        }
        return false;
    }

    private void stopAllScroll() {
        if (this.animationReBackToRefreshing != null) {
            this.animationReBackToRefreshing.cancel();
        }
        if (this.animationReBackToTop != null) {
            this.animationReBackToTop.cancel();
        }
    }

    @Override
    public void setOnRefreshListener(ISwipe.OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    @Override
    public void setOnStatusListener(ISwipe.OnStatusListener onStatusListener) {
        this.mOnStatusListener = onStatusListener;
    }

    @Override
    public void setFreshStatue(ISwipe.FreshStatus statue) {
        switch (statue) {
            case CONTINUE: {
                this.mFreshStatus = ISwipe.FreshStatus.CONTINUE;
                if (this.mOnStatusListener != null) {
                    this.mOnStatusListener.onFreshStatue(this.mFreshStatus);
                }
                this.mRefreshStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
                this.mLoadedStatusContinueRunning = false;
                if (this.mOnRefreshListener != null) {
                    this.mOnRefreshListener.onRefresh();
                }
                this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_LOADING, -this.getScrollY(), this.mViewTop.getHeight());
                this.tryBackToRefreshing();
                break;
            }
            case SUCCESS: {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeRefresh.this.mFreshStatus = ISwipe.FreshStatus.SUCCESS;
                        if (SwipeRefresh.this.mOnStatusListener != null) {
                            SwipeRefresh.this.mOnStatusListener.onFreshStatue(SwipeRefresh.this.mFreshStatus);
                        }
                        SwipeRefresh.this.mRefreshStatusContinueRunning = false;
                        SwipeRefresh.this.mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
                        SwipeRefresh.this.mLoadedStatusContinueRunning = false;
                        SwipeRefresh.this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, -SwipeRefresh.this.getScrollY(), SwipeRefresh.this.mViewTop.getHeight());
                        SwipeRefresh.this.tryBackToFreshFinish();
                    }
                }, 1000L);
                break;
            }
            case ERROR_NET: {
                if (this.mOnStatusListener != null) {
                    this.mOnStatusListener.onFreshStatue(ISwipe.FreshStatus.ERROR_NET);
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeRefresh.this.mFreshStatus = ISwipe.FreshStatus.ERROR_NET;
                        if (SwipeRefresh.this.mOnStatusListener != null) {
                            SwipeRefresh.this.mOnStatusListener.onFreshStatue(SwipeRefresh.this.mFreshStatus);
                        }
                        SwipeRefresh.this.mRefreshStatusContinueRunning = false;
                        SwipeRefresh.this.mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
                        SwipeRefresh.this.mLoadedStatusContinueRunning = false;
                        SwipeRefresh.this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR_NET, -SwipeRefresh.this.getScrollY(), SwipeRefresh.this.mViewTop.getHeight());
                        SwipeRefresh.this.tryBackToFreshFinish();
                    }
                }, 1000L);
                break;
            }
            case ERROR: {
                if (this.mOnStatusListener != null) {
                    this.mOnStatusListener.onFreshStatue(ISwipe.FreshStatus.ERROR);
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeRefresh.this.mFreshStatus = ISwipe.FreshStatus.ERROR;
                        if (SwipeRefresh.this.mOnStatusListener != null) {
                            SwipeRefresh.this.mOnStatusListener.onFreshStatue(SwipeRefresh.this.mFreshStatus);
                        }
                        SwipeRefresh.this.mRefreshStatusContinueRunning = false;
                        SwipeRefresh.this.mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
                        SwipeRefresh.this.mLoadedStatusContinueRunning = false;
                        SwipeRefresh.this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR, -SwipeRefresh.this.getScrollY(), SwipeRefresh.this.mViewTop.getHeight());
                        SwipeRefresh.this.tryBackToFreshFinish();
                    }
                }, 1000L);
            }
        }
    }

    @Override
    public void setLoadMoreStatus(ISwipe.LoadedStatus status) {
        switch (status) {
            case CONTINUE: {
                this.ensureTarget();
                int currentScrollY = this.getScrollY();
                if (currentScrollY > 0) {
                    if ((this.mTargetView instanceof RecyclerView || this.mTargetView instanceof ListView || this.mTargetView instanceof ScrollView || this.mTargetView instanceof NestedScrollView) && this.canChildScrollUp()) {
                        this.mTargetView.scrollBy(0, currentScrollY);
                    }
                    this.stopAllScroll();
                    this.scrollTo(0, 0);
                }
                this.mLoadedStatusContinueRunning = false;
                this.mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
                this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_LOAD_LOADING, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
                break;
            }
            case ERROR: {
                this.mLoadedStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.ERROR;
                this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_LOAD_ERROR, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
                break;
            }
            case NO_MORE: {
                this.mLoadedStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.NO_MORE;
                this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_LOAD_NO_MORE, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
            }
        }
    }

    @Override
    public void setSwipeModel(SwipeControl.SwipeModel model) {
        if (this.mModel != model && model != null) {
            this.mModel = model;
            this.requestLayout();
        }
    }

    @Override
    public void setSwipeControl(SwipeControl control) {
        if (control != null && this.mSwipeControl != control) {
            this.removeView(this.mViewTop);
            this.removeView(this.mViewBottom);
            this.mSwipeControl = control;
            this.mViewTop = this.mSwipeControl.getSwipeHead();
            this.mViewBottom = this.mSwipeControl.getSwipeFoot();
            this.addView(this.mViewTop);
            this.addView(this.mViewBottom);
            this.requestLayout();
        }
    }
}

