/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.adapter;

import android.app.Activity;
import android.database.DataSetObservable;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import android.widget.TextView;
import com.powyin.scroll.R;
import com.powyin.scroll.adapter.AdapterDelegate;
import com.powyin.scroll.adapter.MultipleListAdapter;
import com.powyin.scroll.adapter.PowViewHolder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultipleRecycleAdapter<T>
extends RecyclerView.Adapter<PowViewHolder.RecycleViewHolder>
implements AdapterDelegate<T> {
    private PowViewHolder[] mHolderInstances;
    private Class<? extends PowViewHolder>[] mHolderClasses;
    private Class[] mHolderGenericDataClass;
    private Activity mActivity;
    private List<T> mDataList = new ArrayList<T>();
    private boolean mShowError = true;
    private Map<T, PowViewHolder> mDataToViewHolder = new HashMap<T, PowViewHolder>();
    private final DataSetObservable mDataSetObservable = new DataSetObservable();

    @SafeVarargs
    public static <T, N extends T> MultipleListAdapter<N> getByViewHolder(Activity activity, Class<? extends PowViewHolder<? extends T>> ... arrClass) {
        return new MultipleListAdapter(activity, arrClass);
    }

    @SafeVarargs
    public MultipleRecycleAdapter(Activity activity, Class<? extends PowViewHolder<? extends T>> ... viewHolderClass) {
        Class[] arrClass = new Class[viewHolderClass.length + 1];
        System.arraycopy(viewHolderClass, 0, arrClass, 0, viewHolderClass.length);
        arrClass[arrClass.length - 1] = ErrorPowViewHolder.class;
        this.mActivity = activity;
        this.mHolderClasses = arrClass;
        this.mHolderInstances = new PowViewHolder[arrClass.length];
        this.mHolderGenericDataClass = new Class[arrClass.length];
        for (int i = 0; i < arrClass.length; ++i) {
            Type genericType;
            Class<? extends PowViewHolder> typeClass = this.mHolderClasses[i];
            do {
                genericType = typeClass.getGenericSuperclass();
            } while ((typeClass = typeClass.getSuperclass()) != PowViewHolder.class && typeClass != Object.class);
            if (typeClass != PowViewHolder.class || genericType == PowViewHolder.class) {
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u7ee7\u627f\u6cdb\u578bViewHolder");
            }
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type genericClass = paramType.getActualTypeArguments()[0];
            this.mHolderGenericDataClass[i] = (Class)genericClass;
            try {
                this.mHolderInstances[i] = this.mHolderClasses[i].getConstructor(Activity.class, ViewGroup.class).newInstance(this.mActivity, null);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u5b9e\u73b0\uff08Activity\uff09\u5355\u4e00\u53c2\u6570\u7684\u6784\u9020\u65b9\u6cd5  \u6216\u8005 ImageView \u8f7d\u5165\u56fe\u7247\u5c3a\u5bf8\u8fc7\u5927 \u6216\u8005 " + e.getMessage());
            }
        }
    }

    public PowViewHolder.RecycleViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        PowViewHolder holder;
        try {
            holder = this.mHolderClasses[viewType].getConstructor(Activity.class, ViewGroup.class).newInstance(this.mActivity, parent);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u5b9e\u73b0\uff08Activity\uff09\u5355\u4e00\u53c2\u6570\u7684\u6784\u9020\u65b9\u6cd5  \u6216\u8005 ImageView \u8f7d\u5165\u56fe\u7247\u5c3a\u5bf8\u8fc7\u5927 \u6216\u8005 " + e.getMessage());
        }
        return holder.mViewHolder;
    }

    public void onBindViewHolder(PowViewHolder.RecycleViewHolder holder, int position) {
        T itemData = this.mDataList.get(position);
        PowViewHolder powViewHolder = holder.mPowViewHolder;
        powViewHolder.mData = itemData;
        powViewHolder.loadData(null, this, itemData);
        if (itemData != null) {
            this.mDataToViewHolder.remove(itemData);
            this.mDataToViewHolder.put(itemData, powViewHolder);
        }
    }

    public int getItemCount() {
        return this.mDataList.size();
    }

    public long getItemId(int position) {
        T date = this.mDataList.get(position);
        return date == null ? 0L : (long)date.hashCode();
    }

    public int getItemViewType(int position) {
        if (position == this.mDataList.size()) {
            return this.mHolderInstances.length;
        }
        for (int i = 0; i < this.mHolderInstances.length - 1; ++i) {
            T itemData = this.mDataList.get(position);
            if (itemData == null || !this.mHolderGenericDataClass[i].isAssignableFrom(itemData.getClass()) || !this.mHolderInstances[i].acceptData(itemData)) continue;
            return i;
        }
        return this.mHolderInstances.length - 1;
    }

    @Override
    public void loadData(List<T> dataList) {
        this.mDataList.clear();
        this.mDataList.addAll(dataList);
        this.notifyDataSetChanged();
    }

    @Override
    public void deleteFirst() {
        this.mDataList.remove(0);
        this.notifyDataSetChanged();
    }

    @Override
    public void deleteLast() {
        this.mDataList.remove(this.mDataList.size() - 1);
        this.notifyDataSetChanged();
    }

    @Override
    public void addFirst(T data) {
        this.mDataList.add(0, data);
        this.notifyDataSetChanged();
    }

    @Override
    public void addFirst(List<T> datas) {
        this.mDataList.addAll(0, datas);
        this.notifyDataSetChanged();
    }

    @Override
    public void addLast(T data) {
        this.mDataList.add(this.mDataList.size(), data);
        this.notifyDataSetChanged();
    }

    @Override
    public void addLast(List<T> dataList) {
        this.mDataList.addAll(this.mDataList.size(), dataList);
        this.notifyDataSetChanged();
    }

    @Override
    public void notifyDataChange(T data) {
        PowViewHolder holder = this.mDataToViewHolder.get(data);
        if (holder != null && holder.mData == data) {
            holder.loadData(null, this, data);
        }
    }

    @Override
    public void deleteData(T data) {
        if (this.mDataList.contains(data)) {
            this.mDataList.remove(data);
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setShowErrorHolder(boolean show) {
        if (this.mShowError != show) {
            this.mShowError = show;
            this.notifyDataSetChanged();
        }
    }

    private static class ErrorPowViewHolder
    extends PowViewHolder<Object> {
        TextView errorInfo;

        public ErrorPowViewHolder(Activity activity, ViewGroup viewGroup) {
            super(activity, viewGroup);
            this.errorInfo = (TextView)this.mViewHolder.itemView.findViewById(R.id.powyin_scroll_err_text);
        }

        @Override
        public void loadData(MultipleListAdapter<? super Object> multipleListAdapter, MultipleRecycleAdapter<? super Object> multipleRecycleAdapter, Object data) {
            if (((MultipleRecycleAdapter)multipleRecycleAdapter).mShowError) {
                this.errorInfo.setVisibility(0);
                this.errorInfo.setText((CharSequence)(data == null ? "null" : data.toString()));
            } else {
                this.errorInfo.setVisibility(8);
            }
        }

        @Override
        protected int getItemViewRes() {
            return R.layout.powyin_scroll_multiple_adapter_err;
        }

        @Override
        protected boolean acceptData(Object data) {
            return true;
        }
    }
}

