/*
 * Decompiled with CFR 0.152.
 */
package wigzo.android.sdk;

import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class CertificateTrustManager
implements X509TrustManager {
    private final List<byte[]> keys;

    public CertificateTrustManager(List<String> certificates) throws CertificateException {
        if (certificates == null || certificates.size() == 0) {
            throw new IllegalArgumentException("You must specify non-empty keys list");
        }
        this.keys = new ArrayList<byte[]>();
        for (String key : certificates) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(new ByteArrayInputStream(Base64.decode((String)key, (int)0)));
            this.keys.add(cert.getPublicKey().getEncoded());
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null) {
            throw new IllegalArgumentException("PublicKeyManager: X509Certificate array is null");
        }
        if (chain.length <= 0) {
            throw new IllegalArgumentException("PublicKeyManager: X509Certificate is empty");
        }
        if (null == authType || !authType.equalsIgnoreCase("RSA")) {
            throw new CertificateException("PublicKeyManager: AuthType is not RSA");
        }
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init((KeyStore)null);
            for (TrustManager trustManager : tmf.getTrustManagers()) {
                ((X509TrustManager)trustManager).checkServerTrusted(chain, authType);
            }
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
        byte[] server = chain[0].getPublicKey().getEncoded();
        for (byte[] key : this.keys) {
            if (!Arrays.equals(key, server)) continue;
            return;
        }
        throw new CertificateException("Public keys didn't pass checks");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String string) {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

