/*
 * Decompiled with CFR 0.152.
 */
package com.prakritibansal.posttextrequest.Utils;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCredentialsProvider;
import com.amazonaws.services.lexrts.model.PostTextRequest;
import com.prakritibansal.posttextrequest.config.InteractionConfig;
import java.util.HashMap;
import java.util.Map;

public class CreateLexServiceRequest {
    public static PostTextRequest generatePostTextRequest(Map<String, String> sessionAttributes, InteractionConfig interactionConfig, AWSCredentialsProvider credentialsProvider, String text) {
        PostTextRequest request = CreateLexServiceRequest.generateRequestInternal(sessionAttributes, interactionConfig, credentialsProvider);
        request.setInputText(text);
        return request;
    }

    private static PostTextRequest generateRequestInternal(Map<String, String> sessionAttributes, InteractionConfig interactionConfig, AWSCredentialsProvider credentialsProvider) {
        PostTextRequest request = new PostTextRequest();
        request.setBotName(interactionConfig.getBotName());
        request.setBotAlias(interactionConfig.getBotAlias());
        HashMap<String, String> newSessionAttributes = new HashMap<String, String>();
        newSessionAttributes.putAll(interactionConfig.getGlobalSessionAttributes());
        if (sessionAttributes != null) {
            newSessionAttributes.putAll(sessionAttributes);
        }
        request.setSessionAttributes(newSessionAttributes);
        if (interactionConfig.getUserId() == null || interactionConfig.getUserId().isEmpty()) {
            CognitoCredentialsProvider cognitoCredentialsProvider = (CognitoCredentialsProvider)credentialsProvider;
            request.setUserId(cognitoCredentialsProvider.getIdentityId());
        } else {
            request.setUserId(interactionConfig.getUserId());
        }
        return request;
    }
}

