/*
 * Decompiled with CFR 0.152.
 */
package com.prakritibansal.posttextrequest;

import android.content.Context;
import android.os.Handler;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCredentialsProvider;
import com.amazonaws.mobileconnectors.lex.interactionkit.exceptions.DialogFailedException;
import com.amazonaws.mobileconnectors.lex.interactionkit.exceptions.InvalidParameterException;
import com.amazonaws.mobileconnectors.lex.interactionkit.exceptions.LexClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.lexrts.AmazonLexRuntime;
import com.amazonaws.services.lexrts.AmazonLexRuntimeClient;
import com.amazonaws.services.lexrts.model.DialogState;
import com.amazonaws.services.lexrts.model.PostTextRequest;
import com.amazonaws.services.lexrts.model.PostTextResult;
import com.amazonaws.util.StringUtils;
import com.prakritibansal.posttextrequest.Continuations.LexServiceContinuation;
import com.prakritibansal.posttextrequest.Listeners.DefaultInteractionListener;
import com.prakritibansal.posttextrequest.Listeners.InteractionListener;
import com.prakritibansal.posttextrequest.TextResponse;
import com.prakritibansal.posttextrequest.Utils.CreateLexServiceRequest;
import com.prakritibansal.posttextrequest.config.InteractionConfig;
import java.util.Map;

public class InteractionClient {
    private final String TAG = "Lex";
    private static final String INTERACTION_CLIENT_USER_AGENT = "INTERACTION_CLIENT";
    private final Context context;
    private final AmazonLexRuntime amazonlex;
    private final InteractionConfig interactionConfig;
    private final AWSCredentialsProvider credentialsProvider;
    private InteractionListener interactionListener;
    public static final int SAMPLE_SIZE = 16;
    private final boolean BUSY = true;
    private final boolean NOT_BUSY = false;
    private volatile boolean requestInProgress;

    public InteractionClient(Context context, AWSCredentialsProvider credentialsProvider, Regions region, String botName, String botAlias) {
        this(context, credentialsProvider, region, new InteractionConfig(botName, botAlias));
    }

    public InteractionClient(Context context, AWSCredentialsProvider credentialsProvider, Regions region, InteractionConfig interactionConfig) {
        this(context, credentialsProvider, region, interactionConfig, null);
    }

    public InteractionClient(Context context, AWSCredentialsProvider credentialsProvider, Regions region, InteractionConfig interactionConfig, ClientConfiguration clientConfiguration) {
        if (context == null) {
            throw new InvalidParameterException("Context cannot be null.");
        }
        this.context = context;
        if (credentialsProvider == null) {
            throw new InvalidParameterException("Credentials are not set.");
        }
        if (interactionConfig == null) {
            throw new InvalidParameterException("Interaction config is not set.");
        }
        if ((interactionConfig.getUserId() == null || interactionConfig.getUserId().isEmpty()) && !(credentialsProvider instanceof CognitoCredentialsProvider)) {
            throw new InvalidParameterException("User id must be set in the config or Amazon Cognito Identity must used as the credentials provider");
        }
        this.interactionConfig = interactionConfig;
        this.credentialsProvider = credentialsProvider;
        this.interactionListener = new DefaultInteractionListener();
        if (null == clientConfiguration) {
            clientConfiguration = new ClientConfiguration();
        }
        String userAgent = INTERACTION_CLIENT_USER_AGENT;
        if (!StringUtils.isBlank((CharSequence)clientConfiguration.getUserAgent())) {
            userAgent = userAgent + clientConfiguration.getUserAgent();
        }
        clientConfiguration.setUserAgent(userAgent);
        this.amazonlex = new AmazonLexRuntimeClient(credentialsProvider, clientConfiguration);
        this.amazonlex.setRegion(Region.getRegion((Regions)region));
    }

    public void textInForTextOut(String text, Map<String, String> sessionAttributes) {
        this.carryOnWithText(text, sessionAttributes);
    }

    public void cancel() {
        this.setBusyState(false);
    }

    private void carryOnWithText(final String text, final Map<String, String> sessionAttributes) {
        this.checkBusyState();
        final InteractionClient client = this;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Handler handler = new Handler(InteractionClient.this.context.getMainLooper());
                try {
                    PostTextRequest request = CreateLexServiceRequest.generatePostTextRequest(sessionAttributes, InteractionClient.this.interactionConfig, InteractionClient.this.credentialsProvider, text);
                    PostTextResult result = InteractionClient.this.amazonlex.postText(request);
                    InteractionClient.this.processResponse(handler, result, client);
                }
                catch (Exception e) {
                    Runnable returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            InteractionClient.this.interactionListener.onInteractionError(null, e);
                        }
                    };
                    handler.post(returnCallback);
                }
                finally {
                    InteractionClient.this.setBusyState(false);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(Handler handler, final PostTextResult result, InteractionClient client) {
        Runnable response;
        try {
            this.setBusyState(false);
            final TextResponse serviceResponse = new TextResponse(result);
            if (DialogState.Failed.toString().equals(result.getDialogState())) {
                response = new Runnable(){

                    @Override
                    public void run() {
                        InteractionClient.this.interactionListener.onInteractionError(serviceResponse, (Exception)new DialogFailedException("Failed to fulfill current request."));
                    }
                };
            } else if (DialogState.ReadyForFulfillment.toString().equals(result.getDialogState())) {
                response = new Runnable(){

                    @Override
                    public void run() {
                        InteractionClient.this.interactionListener.onReadyForFulfillment(new TextResponse(result));
                        InteractionClient.this.interactionListener.promptUserToRespond(serviceResponse, null);
                    }
                };
            } else if (DialogState.Fulfilled.toString().equals(result.getDialogState())) {
                response = new Runnable(){

                    @Override
                    public void run() {
                        InteractionClient.this.interactionListener.promptUserToRespond(serviceResponse, null);
                    }
                };
            } else {
                final LexServiceContinuation continuation = new LexServiceContinuation(client);
                continuation.setSessionAttributes(serviceResponse.getSessionAttributes());
                response = new Runnable(){

                    @Override
                    public void run() {
                        InteractionClient.this.interactionListener.promptUserToRespond(serviceResponse, continuation);
                    }
                };
            }
        }
        catch (Exception e) {
            response = new Runnable(){

                @Override
                public void run() {
                    InteractionClient.this.interactionListener.onInteractionError(null, e);
                }
            };
        }
        finally {
            this.setBusyState(false);
        }
        handler.post(response);
    }

    public void setInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null) {
            interactionListener = new DefaultInteractionListener();
        }
        this.interactionListener = interactionListener;
    }

    private void checkBusyState() {
        if (this.isBusy()) {
            throw new LexClientException("Client is busy with a request.");
        }
        this.setBusyState(true);
    }

    private boolean isBusy() {
        return this.requestInProgress;
    }

    private void setBusyState(boolean busyState) {
        this.requestInProgress = busyState;
    }
}

