/*
 * Decompiled with CFR 0.152.
 */
package name.pgollangi.gradle.sonarlinter;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import name.pgollangi.gradle.sonarlinter.SonarSourceFile;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.sonarlint.core.client.api.common.ClientFileSystem;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;

public class FolderFileSystem
implements ClientFileSystem {
    private Path folder;

    public FolderFileSystem(Path folder) {
        this.folder = folder;
    }

    public Stream<ClientInputFile> files(String suffix, InputFile.Type type) {
        try {
            return Files.walk(this.folder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(filePath -> filePath.toString().endsWith("." + suffix)).filter(filePath -> this.typeMatches(filePath.toUri(), type)).map(filePath -> this.toClientInputFile((Path)filePath, type));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot browse the files", e);
        }
    }

    private boolean typeMatches(URI uri, InputFile.Type type) {
        return true;
    }

    public Stream<ClientInputFile> files() {
        try {
            return Files.walk(this.folder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(filePath -> this.toClientInputFile((Path)filePath, this.isTestFile(filePath.toUri()) ? InputFile.Type.TEST : InputFile.Type.MAIN));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot browse the files", e);
        }
    }

    private boolean isTestFile(URI uri) {
        return false;
    }

    private ClientInputFile toClientInputFile(Path filePath, InputFile.Type type) {
        return new SonarSourceFile(filePath, this.folder.relativize(filePath).toString(), this.isTestType(type));
    }

    private boolean isTestType(InputFile.Type type) {
        return false;
    }
}

