/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengrad.mapscaleview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import com.github.pengrad.mapscaleview.Scale;
import com.github.pengrad.mapscaleview.Scales;

public class Drawer {
    private final Paint textPaint = new Paint();
    private final Paint strokePaint = new Paint();
    private final Path strokePath = new Path();
    private final Paint outlinePaint = new Paint();
    private final Path outlineDiffPath = new Path();
    private float outlineStrokeWidth = 2.0f;
    private float outlineStrokeDiff = this.outlineStrokeWidth / 2.0f / 2.0f;
    private float outlineTextStrokeWidth = 3.0f;
    private boolean outlineEnabled = true;
    private float textHeight;
    private float horizontalLineY;
    private boolean expandRtlEnabled;
    private int viewWidth;
    private Scales scales = new Scales(null, null);

    Drawer(int color, float textSize, float strokeWidth, float density, boolean outlineEnabled, boolean expandRtlEnabled) {
        this.textPaint.setAntiAlias(true);
        this.textPaint.setColor(color);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setTextSize(textSize);
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setColor(color);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setStrokeWidth(strokeWidth);
        this.outlinePaint.set(this.strokePaint);
        this.outlinePaint.setARGB(255, 255, 255, 255);
        this.outlineStrokeWidth = strokeWidth * 2.0f;
        this.outlineStrokeDiff = strokeWidth / 2.0f;
        this.outlineTextStrokeWidth = density * 2.0f;
        this.outlineEnabled = outlineEnabled;
        this.expandRtlEnabled = expandRtlEnabled;
        this.update();
    }

    private void update() {
        this.outlinePaint.setTextSize(this.textPaint.getTextSize());
        this.outlinePaint.setStrokeWidth(this.outlineTextStrokeWidth);
        Rect textRect = new Rect();
        Paint highestPaint = this.outlineEnabled ? this.outlinePaint : this.textPaint;
        String possibleText = "1234567890kmift";
        highestPaint.getTextBounds(possibleText, 0, possibleText.length(), textRect);
        this.textHeight = textRect.height();
        this.horizontalLineY = this.textHeight + this.textHeight / 2.0f;
    }

    int getWidth() {
        return (int)(this.scales.maxLength() + this.strokePaint.getStrokeWidth());
    }

    int getHeight() {
        if (this.scales.bottom() != null) {
            return (int)(this.textHeight * 3.0f + this.outlineTextStrokeWidth / 2.0f);
        }
        return (int)(this.horizontalLineY + this.strokePaint.getStrokeWidth());
    }

    void setScales(Scales scales) {
        this.scales = scales;
    }

    void setColor(int color) {
        this.textPaint.setColor(color);
        this.strokePaint.setColor(color);
    }

    void setTextSize(float textSize) {
        this.textPaint.setTextSize(textSize);
        this.update();
    }

    void setStrokeWidth(float strokeWidth) {
        this.strokePaint.setStrokeWidth(strokeWidth);
        this.outlineStrokeWidth = strokeWidth * 2.0f;
        this.outlineStrokeDiff = strokeWidth / 2.0f;
        this.update();
    }

    void setOutlineEnabled(boolean enabled) {
        this.outlineEnabled = enabled;
        this.update();
    }

    void setExpandRtlEnabled(boolean enabled) {
        this.expandRtlEnabled = enabled;
    }

    void setViewWidth(int width) {
        this.viewWidth = width;
    }

    void draw(Canvas canvas) {
        Scale top = this.scales.top();
        if (top == null) {
            return;
        }
        if (this.expandRtlEnabled && this.viewWidth == 0) {
            this.expandRtlEnabled = false;
        }
        if (this.expandRtlEnabled) {
            this.outlinePaint.setTextAlign(Paint.Align.RIGHT);
            this.textPaint.setTextAlign(Paint.Align.RIGHT);
        } else {
            this.outlinePaint.setTextAlign(Paint.Align.LEFT);
            this.textPaint.setTextAlign(Paint.Align.LEFT);
        }
        if (this.outlineEnabled) {
            this.outlinePaint.setStrokeWidth(this.outlineTextStrokeWidth);
            canvas.drawText(top.text(), this.expandRtlEnabled ? (float)this.viewWidth : 0.0f, this.textHeight, this.outlinePaint);
        }
        canvas.drawText(top.text(), this.expandRtlEnabled ? (float)this.viewWidth : 0.0f, this.textHeight, this.textPaint);
        this.strokePath.rewind();
        this.strokePath.moveTo(this.expandRtlEnabled ? (float)this.viewWidth - this.outlineStrokeDiff : this.outlineStrokeDiff, this.horizontalLineY);
        this.strokePath.lineTo(this.expandRtlEnabled ? (float)this.viewWidth - top.length() : top.length(), this.horizontalLineY);
        if (this.outlineEnabled) {
            this.strokePath.lineTo(this.expandRtlEnabled ? (float)this.viewWidth - top.length() : top.length(), this.textHeight + this.outlineStrokeDiff);
        } else {
            this.strokePath.lineTo(this.expandRtlEnabled ? (float)this.viewWidth - top.length() : top.length(), this.textHeight);
        }
        Scale bottom = this.scales.bottom();
        if (bottom != null) {
            if (bottom.length() > top.length()) {
                this.strokePath.moveTo(this.expandRtlEnabled ? (float)this.viewWidth - top.length() : top.length(), this.horizontalLineY);
                this.strokePath.lineTo(this.expandRtlEnabled ? (float)this.viewWidth - bottom.length() : bottom.length(), this.horizontalLineY);
            } else {
                this.strokePath.moveTo(this.expandRtlEnabled ? (float)this.viewWidth - bottom.length() : bottom.length(), this.horizontalLineY);
            }
            this.strokePath.lineTo(this.expandRtlEnabled ? (float)this.viewWidth - bottom.length() : bottom.length(), this.textHeight * 2.0f);
            float bottomTextY = this.horizontalLineY + this.textHeight + this.textHeight / 2.0f;
            if (this.outlineEnabled) {
                canvas.drawText(bottom.text(), this.expandRtlEnabled ? (float)this.viewWidth : 0.0f, bottomTextY, this.outlinePaint);
            }
            canvas.drawText(bottom.text(), this.expandRtlEnabled ? (float)this.viewWidth : 0.0f, bottomTextY, this.textPaint);
        }
        if (this.outlineEnabled) {
            this.outlinePaint.setStrokeWidth(this.outlineStrokeWidth);
            this.outlineDiffPath.rewind();
            this.outlineDiffPath.moveTo(this.expandRtlEnabled ? (float)this.viewWidth : 0.0f, this.horizontalLineY);
            this.outlineDiffPath.lineTo(this.expandRtlEnabled ? (float)this.viewWidth - this.outlineStrokeDiff : this.outlineStrokeDiff, this.horizontalLineY);
            this.outlineDiffPath.moveTo(this.expandRtlEnabled ? (float)this.viewWidth - top.length() : top.length(), this.textHeight + this.outlineStrokeDiff);
            this.outlineDiffPath.lineTo(this.expandRtlEnabled ? (float)this.viewWidth - top.length() : top.length(), this.textHeight);
            if (bottom != null) {
                this.outlineDiffPath.moveTo(this.expandRtlEnabled ? (float)this.viewWidth - bottom.length() : bottom.length(), this.textHeight * 2.0f);
                this.outlineDiffPath.lineTo(this.expandRtlEnabled ? (float)this.viewWidth - bottom.length() : bottom.length(), this.textHeight * 2.0f + this.outlineStrokeDiff);
            }
            canvas.drawPath(this.outlineDiffPath, this.outlinePaint);
            canvas.drawPath(this.strokePath, this.outlinePaint);
        }
        canvas.drawPath(this.strokePath, this.strokePaint);
    }
}

