/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengrad.mapscaleview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import com.github.pengrad.mapscaleview.R;

class ViewConfig {
    final int desiredWidth;
    final int color;
    final float textSize;
    final float strokeWidth;
    final boolean isMiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ViewConfig(Context context, AttributeSet attrs) {
        float density = context.getResources().getDisplayMetrics().density;
        this.desiredWidth = (int)(100.0f * density);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MapScaleView, 0, 0);
        try {
            this.color = a.getColor(R.styleable.MapScaleView_scale_color, Color.parseColor((String)"#333333"));
            this.textSize = a.getDimension(R.styleable.MapScaleView_scale_textSize, 12.0f * density);
            this.strokeWidth = a.getDimension(R.styleable.MapScaleView_scale_strokeWidth, 1.5f * density + 0.5f);
            this.isMiles = a.getBoolean(R.styleable.MapScaleView_scale_miles, false);
        }
        finally {
            a.recycle();
        }
    }
}

